/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutsadmin.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.exportimportconfiguration.ExportImportConfigurationHelper;
import com.liferay.portal.kernel.lar.exportimportconfiguration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BackgroundTask;
import com.liferay.portal.model.ExportImportConfiguration;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.BackgroundTaskLocalServiceUtil;
import com.liferay.portal.service.ExportImportConfigurationServiceUtil;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.sites.action.ActionUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditExportConfigurationAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(EditExportConfigurationAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateExportConfiguration(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteExportImportConfiguration(actionRequest, false);
            } else if (cmd.equals("export")) {
                long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
                LayoutServiceUtil.exportLayoutsAsFileInBackground((long)exportImportConfigurationId);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteExportImportConfiguration(actionRequest, true);
            } else if (cmd.equals("relaunch")) {
                this.relaunchExportLayoutConfiguration(actionRequest);
            } else if (Validator.isNull((String)cmd)) {
                this.addSessionMessages(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            String pagesRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
            this.sendRedirect(actionRequest, actionResponse, pagesRedirect);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.layouts_admin.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layouts_admin.export_layouts"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/portlet/layouts_admin/export_layouts_processes.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void addSessionMessages(ActionRequest actionRequest) throws Exception {
        String portletId = PortalUtil.getPortletId((PortletRequest)actionRequest);
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "exportImportConfigurationId"), (Object)exportImportConfigurationId);
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "name"), (Object)name);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "description"), (Object)description);
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        Map settingsMap = ExportImportConfigurationSettingsMapFactory.buildSettingsMap((PortletRequest)actionRequest, (long)groupId, (int)0);
        SessionMessages.add((PortletRequest)actionRequest, (String)(portletId + "settingsMap"), (Object)settingsMap);
    }

    protected void deleteExportImportConfiguration(ActionRequest actionRequest, boolean moveToTrash) throws PortalException {
        long[] deleteExportImportConfigurationIds = null;
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        deleteExportImportConfigurationIds = exportImportConfigurationId > 0L ? new long[]{exportImportConfigurationId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"deleteExportImportConfigurationIds"), (long)0L);
        ArrayList<ExportImportConfiguration> trashedModels = new ArrayList<ExportImportConfiguration>();
        for (long deleteExportImportConfigurationId : deleteExportImportConfigurationIds) {
            if (moveToTrash) {
                ExportImportConfiguration exportImportConfiguration = ExportImportConfigurationServiceUtil.moveExportImportConfigurationToTrash((long)deleteExportImportConfigurationId);
                trashedModels.add(exportImportConfiguration);
                continue;
            }
            ExportImportConfigurationServiceUtil.deleteExportImportConfiguration((long)deleteExportImportConfigurationId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void relaunchExportLayoutConfiguration(ActionRequest actionRequest) throws Exception {
        long backgroundTaskId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"backgroundTaskId");
        BackgroundTask backgroundTask = BackgroundTaskLocalServiceUtil.getBackgroundTask((long)backgroundTaskId);
        Map taskContextMap = backgroundTask.getTaskContextMap();
        long exportImportConfigurationId = MapUtil.getLong((Map)taskContextMap, (String)"exportImportConfigurationId");
        LayoutServiceUtil.exportLayoutsAsFileInBackground((long)exportImportConfigurationId);
    }

    protected ExportImportConfiguration updateExportConfiguration(ActionRequest actionRequest) throws Exception {
        long exportImportConfigurationId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"exportImportConfigurationId");
        if (exportImportConfigurationId > 0L) {
            return ExportImportConfigurationHelper.updateExportLayoutExportImportConfiguration((PortletRequest)actionRequest);
        }
        return ExportImportConfigurationHelper.addExportLayoutExportImportConfiguration((PortletRequest)actionRequest);
    }
}

