/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutprototypes.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.LayoutPrototypeLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class LayoutPrototypeStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutPrototype> {
    public static final String[] CLASS_NAMES = new String[]{LayoutPrototype.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        LayoutPrototype layoutPrototype = this.fetchStagedModelByUuidAndCompanyId(uuid, group.getCompanyId());
        if (layoutPrototype != null) {
            LayoutPrototypeLocalServiceUtil.deleteLayoutPrototype((LayoutPrototype)layoutPrototype);
        }
    }

    public LayoutPrototype fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        return LayoutPrototypeLocalServiceUtil.fetchLayoutPrototypeByUuidAndCompanyId((String)uuid, (long)companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(LayoutPrototype layoutPrototype) {
        return layoutPrototype.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) throws Exception {
        this.exportLayouts(portletDataContext, layoutPrototype);
        Element layoutPrototypeElement = portletDataContext.getExportDataElement((ClassedModel)layoutPrototype);
        portletDataContext.addClassedModel(layoutPrototypeElement, ExportImportPathUtil.getModelPath((StagedModel)layoutPrototype), (ClassedModel)layoutPrototype);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) throws Exception {
        long userId = portletDataContext.getUserId(layoutPrototype.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)layoutPrototype);
        serviceContext.setAttribute("addDefaultLayout", (Serializable)Boolean.valueOf(false));
        LayoutPrototype importedLayoutPrototype = null;
        if (portletDataContext.isDataStrategyMirror()) {
            LayoutPrototype existingLayoutPrototype = this.fetchStagedModelByUuidAndCompanyId(layoutPrototype.getUuid(), portletDataContext.getCompanyId());
            if (existingLayoutPrototype == null) {
                serviceContext.setUuid(layoutPrototype.getUuid());
                importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutPrototype.getNameMap(), (Map)layoutPrototype.getDescriptionMap(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
            } else {
                importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.updateLayoutPrototype((long)existingLayoutPrototype.getLayoutPrototypeId(), (Map)layoutPrototype.getNameMap(), (Map)layoutPrototype.getDescriptionMap(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
            }
        } else {
            importedLayoutPrototype = LayoutPrototypeLocalServiceUtil.addLayoutPrototype((long)userId, (long)portletDataContext.getCompanyId(), (Map)layoutPrototype.getNameMap(), (Map)layoutPrototype.getDescriptionMap(), (boolean)layoutPrototype.isActive(), (ServiceContext)serviceContext);
        }
        this.importLayouts(portletDataContext, layoutPrototype, importedLayoutPrototype.getGroupId());
        portletDataContext.importClassedModel((ClassedModel)layoutPrototype, (ClassedModel)importedLayoutPrototype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportLayouts(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) throws Exception {
        long groupId = portletDataContext.getGroupId();
        boolean privateLayout = portletDataContext.isPrivateLayout();
        long scopeGroupId = portletDataContext.getScopeGroupId();
        List layouts = LayoutLocalServiceUtil.getLayouts((long)layoutPrototype.getGroupId(), (boolean)true, (long)0L);
        try {
            portletDataContext.setGroupId(layoutPrototype.getGroupId());
            portletDataContext.setPrivateLayout(true);
            portletDataContext.setScopeGroupId(layoutPrototype.getGroupId());
            for (Layout layout : layouts) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutPrototype, (StagedModel)layout, (String)"embedded");
            }
        }
        finally {
            portletDataContext.setGroupId(groupId);
            portletDataContext.setPrivateLayout(privateLayout);
            portletDataContext.setScopeGroupId(scopeGroupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importLayouts(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype, long importedGroupId) throws PortalException {
        long groupId = portletDataContext.getGroupId();
        boolean privateLayout = portletDataContext.isPrivateLayout();
        long scopeGroupId = portletDataContext.getScopeGroupId();
        try {
            portletDataContext.setGroupId(importedGroupId);
            portletDataContext.setPrivateLayout(true);
            portletDataContext.setScopeGroupId(importedGroupId);
            StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)layoutPrototype, Layout.class);
        }
        finally {
            portletDataContext.setGroupId(groupId);
            portletDataContext.setPrivateLayout(privateLayout);
            portletDataContext.setScopeGroupId(scopeGroupId);
        }
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, LayoutPrototype layoutPrototype) {
    }
}

