/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontentsearch.util;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

public class ContentHits {
    private boolean _showListed = true;

    public boolean isShowListed() {
        return this._showListed;
    }

    public void recordHits(Hits hits, long groupId, boolean privateLayout, int start, int end) throws Exception {
        List<Document> docs = new ArrayList();
        List<Float> scores = new ArrayList();
        Document[] docsArray = hits.getDocs();
        for (int i = 0; i < docsArray.length; ++i) {
            Document doc = hits.doc(i);
            String articleId = doc.get("articleId");
            long articleGroupId = GetterUtil.getLong((String)doc.get("groupId"));
            int layoutIdsCount = JournalContentSearchLocalServiceUtil.getLayoutIdsCount((long)groupId, (boolean)privateLayout, (String)articleId);
            if (layoutIdsCount <= 0 && (this.isShowListed() || articleGroupId != groupId)) continue;
            docs.add(hits.doc(i));
            scores.add(Float.valueOf(hits.score(i)));
        }
        int length = docs.size();
        hits.setLength(length);
        if (end > length) {
            end = length;
        }
        docs = docs.subList(start, end);
        scores = scores.subList(start, end);
        hits.setDocs(docs.toArray(new Document[docs.size()]));
        hits.setScores(ArrayUtil.toFloatArray(scores));
        hits.setSearchTime((float)(System.currentTimeMillis() - hits.getStart()) / 1000.0f);
    }

    public void setShowListed(boolean showListed) {
        this._showListed = showListed;
    }
}

