/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journalcontent.util;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journalcontent.util.JournalContent;
import java.io.Serializable;
import org.apache.commons.lang.time.StopWatch;

@DoPrivileged
public class JournalContentImpl
implements JournalContent {
    protected static final String CACHE_NAME = JournalContent.class.getName();
    protected static PortalCache<String, JournalArticleDisplay> portalCache = MultiVMPoolUtil.getCache((String)CACHE_NAME);
    private static Log _log = LogFactoryUtil.getLog(JournalContentImpl.class);

    public void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        portalCache.removeAll();
    }

    public void clearCache(long groupId, String articleId, String ddmTemplateKey) {
        this.clearCache();
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, portletRequestModel, null);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, portletRequestModel, null);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        JournalArticleDisplay articleDisplay = this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay != null) {
            return articleDisplay.getContent();
        }
        return null;
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        articleId = StringUtil.toUpperCase((String)GetterUtil.getString((String)articleId));
        ddmTemplateKey = StringUtil.toUpperCase((String)GetterUtil.getString((String)ddmTemplateKey));
        long layoutSetId = 0L;
        boolean secure = false;
        if (themeDisplay != null) {
            try {
                if (!JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), groupId, articleId, "VIEW")) {
                    return null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            LayoutSet layoutSet = themeDisplay.getLayoutSet();
            layoutSetId = layoutSet.getLayoutSetId();
            secure = themeDisplay.isSecure();
        }
        String key = this.encodeKey(groupId, articleId, version, ddmTemplateKey, layoutSetId, viewMode, languageId, page, secure);
        JournalArticleDisplay articleDisplay = (JournalArticleDisplay)portalCache.get((Serializable)((Object)key));
        boolean lifecycleRender = false;
        if (portletRequestModel != null) {
            lifecycleRender = "RENDER_PHASE".equals(portletRequestModel.getLifecycle());
        }
        if ((articleDisplay == null || !lifecycleRender) && (articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay)) != null && articleDisplay.isCacheable() && lifecycleRender) {
            portalCache.put((Serializable)((Object)key), (Object)articleDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + groupId + ", " + articleId + ", " + ddmTemplateKey + ", " + viewMode + ", " + languageId + ", " + page + "} takes " + stopWatch.getTime() + " ms"));
        }
        return articleDisplay;
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, int page, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, page, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, 1, portletRequestModel, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, 0.0, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, viewMode, languageId, 1, themeDisplay);
    }

    protected String encodeKey(long groupId, String articleId, double version, String ddmTemplateKey, long layoutSetId, String viewMode, String languageId, int page, boolean secure) {
        StringBundler sb = new StringBundler(17);
        sb.append(StringUtil.toHexString((long)groupId));
        sb.append("_ARTICLE_");
        sb.append(articleId);
        sb.append("_VERSION_");
        sb.append(version);
        sb.append("_TEMPLATE_");
        sb.append(ddmTemplateKey);
        if (layoutSetId > 0L) {
            sb.append("_LAYOUT_SET_");
            sb.append(StringUtil.toHexString((long)layoutSetId));
        }
        if (Validator.isNotNull((String)viewMode)) {
            sb.append("_VIEW_MODE_");
            sb.append(viewMode);
        }
        if (Validator.isNotNull((String)languageId)) {
            sb.append("_LANGUAGE_");
            sb.append(languageId);
        }
        if (page > 0) {
            sb.append("_PAGE_");
            sb.append(StringUtil.toHexString((int)page));
        }
        sb.append("_SECURE_");
        sb.append(secure);
        return sb.toString();
    }

    protected JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get article display {" + groupId + ", " + articleId + ", " + ddmTemplateKey + "}"));
            }
            return JournalArticleLocalServiceUtil.getArticleDisplay((long)groupId, (String)articleId, (String)ddmTemplateKey, (String)viewMode, (String)languageId, (int)page, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + groupId + " " + articleId + " " + languageId));
            }
            return null;
        }
    }
}

