/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocaleTransformerListener
extends BaseTransformerListener {
    private static Log _log = LogFactoryUtil.getLog(LocaleTransformerListener.class);

    public String onScript(String script, Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return StringUtil.replace((String)script, (String)"@language_id@", (String)languageId);
    }

    public Document onXml(Document document, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        this.filterByLanguage(document, languageId);
        return document;
    }

    protected void filterByLanguage(Document document, String languageId) {
        Element rootElement = document.getRootElement();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
        String[] availableLocales = StringUtil.split((String)rootElement.attributeValue("available-locales", defaultLanguageId));
        String defaultLocale = rootElement.attributeValue("default-locale", defaultLanguageId);
        boolean supportedLocale = false;
        for (String availableLocale : availableLocales) {
            if (!StringUtil.equalsIgnoreCase((String)availableLocale, (String)languageId)) continue;
            supportedLocale = true;
            break;
        }
        if (!supportedLocale) {
            this.filterByLanguage(rootElement, defaultLocale, defaultLanguageId);
        } else {
            this.filterByLanguage(rootElement, languageId, defaultLanguageId);
        }
    }

    protected void filterByLanguage(Element root, String languageId, String defaultLanguageId) {
        Element defaultLanguageElement = null;
        boolean hasLanguageIdElement = false;
        List elements = root.elements();
        for (int listIndex = elements.size() - 1; listIndex >= 0; --listIndex) {
            Element element = (Element)elements.get(listIndex);
            String tempLanguageId = element.attributeValue("language-id", languageId);
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)languageId)) {
                hasLanguageIdElement = true;
                this.filterByLanguage(element, languageId, defaultLanguageId);
                continue;
            }
            if (StringUtil.equalsIgnoreCase((String)tempLanguageId, (String)defaultLanguageId)) {
                defaultLanguageElement = element;
            }
            root.remove(element);
        }
        if (!hasLanguageIdElement && defaultLanguageElement != null) {
            root.add(defaultLanguageElement);
            this.filterByLanguage(defaultLanguageElement, languageId, defaultLanguageId);
        }
    }
}

