/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.xsl.XSLURIResolver;
import com.liferay.portlet.journal.util.JournalUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class JournalXSLURIResolver
implements Externalizable,
XSLURIResolver {
    private static final String _PATH_GET_TEMPLATE = "/c/journal/get_template?template_id=";
    private static Log _log = LogFactoryUtil.getLog(JournalXSLURIResolver.class);
    private String _languageId;
    private Map<String, String> _tokens;

    public JournalXSLURIResolver(Map<String, String> tokens, String languageId) {
        if (tokens == null) {
            throw new IllegalArgumentException("Tokens map is null");
        }
        this._tokens = tokens;
        this._languageId = languageId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JournalXSLURIResolver)) {
            return false;
        }
        JournalXSLURIResolver journalXSLURIResolver = (JournalXSLURIResolver)obj;
        return Validator.equals((Object)this._languageId, (Object)journalXSLURIResolver._languageId) && this._tokens.equals(journalXSLURIResolver._tokens);
    }

    @Override
    public String getLanguageId() {
        return this._languageId;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash((int)0, (Object)this._languageId);
        return HashUtil.hash((int)hashCode, this._tokens);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._languageId = objectInput.readUTF();
        if (this._languageId.equals("")) {
            this._languageId = null;
        }
        this._tokens = (Map)objectInput.readObject();
    }

    @Override
    public Source resolve(String href, String base) {
        try {
            String content = null;
            int templatePathIndex = href.indexOf(_PATH_GET_TEMPLATE);
            if (templatePathIndex >= 0) {
                long articleGroupId = GetterUtil.getLong((String)this._tokens.get("article_group_id"));
                int templateIdIndex = templatePathIndex + _PATH_GET_TEMPLATE.length();
                String templateId = href.substring(templateIdIndex);
                content = JournalUtil.getTemplateScript(articleGroupId, templateId, this._tokens, this._languageId);
            } else {
                content = HttpUtil.URLtoString((String)href);
            }
            return new StreamSource((Reader)new UnsyncStringReader(content));
        }
        catch (Exception e) {
            _log.error((Object)(href + " does not reference a valid template"));
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this._languageId == null) {
            objectOutput.writeUTF("");
        } else {
            objectOutput.writeUTF(this._languageId);
        }
        objectOutput.writeObject(this._tokens);
    }
}

