/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.diff.CompareVersionsException;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.ThemeDisplayModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.util.comparator.ArticleCreateDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleReviewDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleTitleComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.util.FiniteUniqueStack;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalUtil {
    public static final int MAX_STACK_SIZE = 20;
    public static final String[] SELECTED_FIELD_NAMES = new String[]{"articleId", "companyId", "groupId", "uid"};
    private static Log _log = LogFactoryUtil.getLog(JournalUtil.class);
    private static Map<String, String> _customTokens;
    private static Pattern _friendlyURLPattern;
    private static Transformer _transformer;

    public static void addAllReservedEls(Element rootElement, Map<String, String> tokens, JournalArticle article, String languageId, ThemeDisplay themeDisplay) {
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-id", article.getArticleId());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-version", article.getVersion());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-title", article.getTitle(languageId));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-url-title", article.getUrlTitle());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-description", article.getDescription(languageId));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-type", article.getType());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-create-date", article.getCreateDate());
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-modified-date", article.getModifiedDate());
        if (article.getDisplayDate() != null) {
            JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-display-date", article.getDisplayDate());
        }
        String smallImageURL = "";
        if (Validator.isNotNull((String)article.getSmallImageURL())) {
            smallImageURL = article.getSmallImageURL();
        } else if (themeDisplay != null && article.isSmallImage()) {
            StringBundler sb = new StringBundler(5);
            sb.append(themeDisplay.getPathImage());
            sb.append("/journal/article?img_id=");
            sb.append(article.getSmallImageId());
            sb.append("&t=");
            sb.append(WebServerServletTokenUtil.getToken((long)article.getSmallImageId()));
            smallImageURL = sb.toString();
        }
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-small-image-url", smallImageURL);
        Object[] assetTagNames = new String[]{};
        try {
            assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)JournalArticle.class.getName(), (long)article.getResourcePrimKey());
        }
        catch (SystemException se) {
            // empty catch block
        }
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-asset-tag-names", StringUtil.merge((Object[])assetTagNames));
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-id", String.valueOf(article.getUserId()));
        String userName = "";
        String userEmailAddress = "";
        String userComments = "";
        String userJobTitle = "";
        try {
            User user = UserLocalServiceUtil.fetchUserById((long)article.getUserId());
            if (user != null) {
                userName = user.getFullName();
                userEmailAddress = user.getEmailAddress();
                userComments = user.getComments();
                userJobTitle = user.getJobTitle();
            }
        }
        catch (SystemException se) {
            // empty catch block
        }
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-name", userName);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-email-address", userEmailAddress);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-comments", userComments);
        JournalUtil.addReservedEl(rootElement, tokens, "reserved-article-author-job-title", userJobTitle);
    }

    public static void addPortletBreadcrumbEntries(JournalArticle article, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        JournalFolder folder = article.getFolder();
        if (folder.getFolderId() != 0L) {
            JournalUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        JournalArticle unescapedArticle = article.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/article/view_article");
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        portletURL.setParameter("articleId", String.valueOf(article.getArticleId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedArticle.getTitle(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String strutsAction = ParamUtil.getString((HttpServletRequest)request, (String)"struts_action");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        if (strutsAction.equals("/journal/select_folder")) {
            portletURL.setParameter("struts_action", "/journal/select_folder");
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            portletURL.setParameter("struts_action", "/journal/view");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", 0L);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        }
        if (folder == null) {
            return;
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (JournalFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            JournalFolder unescapedFolder = folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public static void addPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)renderResponse;
        JournalUtil.addPortletBreadcrumbEntries(folder, request, liferayPortletResponse);
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        if (folderId == 0L) {
            return;
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        JournalUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
    }

    public static void addRecentArticle(PortletRequest portletRequest, JournalArticle article) {
        if (article != null) {
            Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
            stack.push(article);
        }
    }

    public static void addRecentDDMStructure(PortletRequest portletRequest, DDMStructure ddmStructure) {
        if (ddmStructure != null) {
            Stack<DDMStructure> stack = JournalUtil.getRecentDDMStructures(portletRequest);
            stack.push(ddmStructure);
        }
    }

    public static void addRecentDDMTemplate(PortletRequest portletRequest, DDMTemplate ddmTemplate) {
        if (ddmTemplate != null) {
            Stack<DDMTemplate> stack = JournalUtil.getRecentDDMTemplates(portletRequest);
            stack.push(ddmTemplate);
        }
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, Date value) {
        JournalUtil.addReservedEl(rootElement, tokens, name, Time.getRFC822((Date)value));
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, double value) {
        JournalUtil.addReservedEl(rootElement, tokens, name, String.valueOf(value));
    }

    public static void addReservedEl(Element rootElement, Map<String, String> tokens, String name, String value) {
        if (rootElement != null) {
            Element dynamicElementElement = rootElement.addElement("dynamic-element");
            dynamicElementElement.addAttribute("name", name);
            dynamicElementElement.addAttribute("type", "text");
            Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
            dynamicContentElement.setText(value);
        }
        tokens.put(StringUtil.replace((String)name, (char)'-', (char)'_'), value);
    }

    public static String diffHtml(long groupId, String articleId, double sourceVersion, double targetVersion, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws Exception {
        JournalArticle sourceArticle = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)sourceVersion);
        if (!JournalArticleLocalServiceUtil.isRenderable((JournalArticle)sourceArticle, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay)) {
            throw new CompareVersionsException(sourceVersion);
        }
        JournalArticleDisplay sourceArticleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)sourceArticle, null, (String)"view", (String)languageId, (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
        JournalArticle targetArticle = JournalArticleLocalServiceUtil.getArticle((long)groupId, (String)articleId, (double)targetVersion);
        if (!JournalArticleLocalServiceUtil.isRenderable((JournalArticle)targetArticle, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay)) {
            throw new CompareVersionsException(targetVersion);
        }
        JournalArticleDisplay targetArticleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)targetArticle, null, (String)"view", (String)languageId, (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
        return DiffHtmlUtil.diff((Reader)new UnsyncStringReader(sourceArticleDisplay.getContent()), (Reader)new UnsyncStringReader(targetArticleDisplay.getContent()));
    }

    public static String doTransform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, com.liferay.portal.kernel.xml.Document document, PortletRequestModel portletRequestModel, String script, String langType) throws Exception {
        return _transformer.doTransform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType);
    }

    public static String formatVM(String vm) {
        return vm;
    }

    public static String getAbsolutePath(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (folderId == 0L) {
            return themeDisplay.translate("home");
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        List folders = folder.getAncestors();
        Collections.reverse(folders);
        StringBundler sb = new StringBundler(folders.size() * 3 + 5);
        sb.append(themeDisplay.translate("home"));
        sb.append(" ");
        for (JournalFolder curFolder : folders) {
            sb.append("\u00bb");
            sb.append(" ");
            sb.append(curFolder.getName());
        }
        sb.append("\u00bb");
        sb.append(" ");
        sb.append(folder.getName());
        return sb.toString();
    }

    public static Layout getArticleLayout(String layoutUuid, long groupId) {
        if (Validator.isNull((String)layoutUuid)) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)false);
        if (layout == null) {
            layout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)groupId, (boolean)true);
        }
        return layout;
    }

    public static OrderByComparator<JournalArticle> getArticleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ArticleCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new ArticleCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("display-date")) {
            orderByComparator = new ArticleDisplayDateComparator(orderByAsc);
        } else if (orderByCol.equals("id")) {
            orderByComparator = new ArticleIDComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new ArticleModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("review-date")) {
            orderByComparator = new ArticleReviewDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new ArticleTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new ArticleVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public static List<JournalArticle> getArticles(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>(documents.size());
        for (Document document : documents) {
            String articleId = document.get("articleId");
            long groupId = GetterUtil.getLong((String)document.get("groupId"));
            JournalArticle article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)groupId, (String)articleId, (int)0);
            if (article == null) {
                articles = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(JournalArticle.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (articles == null) continue;
            articles.add(article);
        }
        return articles;
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long groupId, String articleId, double sourceVersion, double targetVersion) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List articles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)-1, (int)-1, (OrderByComparator)new ArticleVersionComparator(true));
        for (JournalArticle article : articles) {
            if (article.getVersion() < sourceVersion && article.getVersion() > previousVersion) {
                previousVersion = article.getVersion();
            }
            if (!(article.getVersion() > targetVersion) || !(article.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = article.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (JournalArticle article : articles) {
            DiffVersion diffVersion = new DiffVersion(article.getUserId(), article.getVersion(), article.getModifiedDate());
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static String getDisplayStyle(LiferayPortletRequest liferayPortletRequest, String[] displayViews) {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
        String displayStyle = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = portalPreferences.getValue("15", "display-style", PropsValues.JOURNAL_DEFAULT_DISPLAY_VIEW);
        } else if (ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            portalPreferences.setValue("15", "display-style", displayStyle);
        }
        if (!ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            displayStyle = displayViews[0];
        }
        return displayStyle;
    }

    public static Map<Locale, String> getEmailArticleAddedBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleAddedBody", (String)"journal.email.article.added.body");
    }

    public static boolean getEmailArticleAddedEnabled(PortletPreferences preferences) {
        String emailArticleAddedEnabled = preferences.getValue("emailArticleAddedEnabled", "");
        if (Validator.isNotNull((String)emailArticleAddedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleAddedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.added.enabled"));
    }

    public static Map<Locale, String> getEmailArticleAddedSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleAddedSubject", (String)"journal.email.article.added.subject");
    }

    public static boolean getEmailArticleAnyEventEnabled(PortletPreferences preferences) {
        return JournalUtil.getEmailArticleAddedEnabled(preferences) || JournalUtil.getEmailArticleApprovalDeniedEnabled(preferences) || JournalUtil.getEmailArticleApprovalGrantedEnabled(preferences) || JournalUtil.getEmailArticleApprovalRequestedEnabled(preferences) || JournalUtil.getEmailArticleReviewEnabled(preferences) || JournalUtil.getEmailArticleUpdatedEnabled(preferences);
    }

    public static Map<Locale, String> getEmailArticleApprovalDeniedBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalDeniedBody", (String)"journal.email.article.approval.denied.body");
    }

    public static boolean getEmailArticleApprovalDeniedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalDeniedEnabled = preferences.getValue("emailArticleApprovalDeniedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalDeniedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalDeniedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.denied.enabled"));
    }

    public static Map<Locale, String> getEmailArticleApprovalDeniedSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalDeniedSubject", (String)"journal.email.article.approval.denied.subject");
    }

    public static Map<Locale, String> getEmailArticleApprovalGrantedBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalGrantedBody", (String)"journal.email.article.approval.granted.body");
    }

    public static boolean getEmailArticleApprovalGrantedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalGrantedEnabled = preferences.getValue("emailArticleApprovalGrantedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalGrantedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalGrantedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.granted.enabled"));
    }

    public static Map<Locale, String> getEmailArticleApprovalGrantedSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalGrantedSubject", (String)"journal.email.article.approval.granted.subject");
    }

    public static Map<Locale, String> getEmailArticleApprovalRequestedBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalRequestedBody", (String)"journal.email.article.approval.requested.body");
    }

    public static boolean getEmailArticleApprovalRequestedEnabled(PortletPreferences preferences) {
        String emailArticleApprovalRequestedEnabled = preferences.getValue("emailArticleApprovalRequestedEnabled", "");
        if (Validator.isNotNull((String)emailArticleApprovalRequestedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleApprovalRequestedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.approval.requested.enabled"));
    }

    public static Map<Locale, String> getEmailArticleApprovalRequestedSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleApprovalRequestedSubject", (String)"journal.email.article.approval.requested.subject");
    }

    public static Map<Locale, String> getEmailArticleReviewBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleReviewBody", (String)"journal.email.article.review.body");
    }

    public static boolean getEmailArticleReviewEnabled(PortletPreferences preferences) {
        String emailArticleReviewEnabled = preferences.getValue("emailArticleReviewEnabled", "");
        if (Validator.isNotNull((String)emailArticleReviewEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleReviewEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.review.enabled"));
    }

    public static Map<Locale, String> getEmailArticleReviewSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleReviewSubject", (String)"journal.email.article.review.subject");
    }

    public static Map<Locale, String> getEmailArticleUpdatedBodyMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleUpdatedBody", (String)"journal.email.article.updated.body");
    }

    public static boolean getEmailArticleUpdatedEnabled(PortletPreferences preferences) {
        String emailArticleUpdatedEnabled = preferences.getValue("emailArticleUpdatedEnabled", "");
        if (Validator.isNotNull((String)emailArticleUpdatedEnabled)) {
            return GetterUtil.getBoolean((String)emailArticleUpdatedEnabled);
        }
        return GetterUtil.getBoolean((String)PropsUtil.get("journal.email.article.updated.enabled"));
    }

    public static Map<Locale, String> getEmailArticleUpdatedSubjectMap(PortletPreferences preferences) {
        return LocalizationUtil.getLocalizationMap((PortletPreferences)preferences, (String)"emailArticleUpdatedSubject", (String)"journal.email.article.updated.subject");
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$ARTICLE_CONTENT]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content"));
        definitionTerms.put("[$ARTICLE_DIFFS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-compared-with-the-previous-version-web-content"));
        definitionTerms.put("[$ARTICLE_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-id"));
        definitionTerms.put("[$ARTICLE_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-title"));
        definitionTerms.put("[$ARTICLE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-url"));
        definitionTerms.put("[$ARTICLE_VERSION$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-version"));
        definitionTerms.put("[$FROM_ADDRESS$]", HtmlUtil.escape((String)emailFromAddress));
        definitionTerms.put("[$FROM_NAME$]", HtmlUtil.escape((String)emailFromName));
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        definitionTerms.put("[$PORTLET_NAME$]", PortalUtil.getPortletTitle((PortletRequest)portletRequest));
        definitionTerms.put("[$TO_ADDRESS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient"));
        definitionTerms.put("[$TO_NAME$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient"));
        return definitionTerms;
    }

    public static String getEmailFromAddress(PortletPreferences preferences, long companyId) {
        return PortalUtil.getEmailFromAddress((PortletPreferences)preferences, (long)companyId, (String)PropsValues.JOURNAL_EMAIL_FROM_ADDRESS);
    }

    public static String getEmailFromName(PortletPreferences preferences, long companyId) {
        return PortalUtil.getEmailFromName((PortletPreferences)preferences, (long)companyId, (String)PropsValues.JOURNAL_EMAIL_FROM_NAME);
    }

    public static String getJournalControlPanelLink(PortletRequest portletRequest, long folderId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)"15", (long)PortalUtil.getControlPanelPlid((long)themeDisplay.getCompanyId()), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/view");
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public static long getPreviewPlid(JournalArticle article, ThemeDisplay themeDisplay) throws Exception {
        Layout layout;
        if (article != null && (layout = article.getLayout()) != null) {
            return layout.getPlid();
        }
        layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (long)0L);
        if (layout == null) {
            layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)true, (long)0L);
        }
        if (layout != null) {
            return layout.getPlid();
        }
        return themeDisplay.getPlid();
    }

    public static Stack<JournalArticle> getRecentArticles(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentArticles = (Stack)portletSession.getAttribute("JOURNAL_RECENT_ARTICLES");
        if (recentArticles == null) {
            recentArticles = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_ARTICLES", (Object)recentArticles);
        }
        return recentArticles;
    }

    public static Stack<DDMStructure> getRecentDDMStructures(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentDDMStructures = (Stack)portletSession.getAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_STRUCTURES");
        if (recentDDMStructures == null) {
            recentDDMStructures = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_STRUCTURES", (Object)recentDDMStructures);
        }
        return recentDDMStructures;
    }

    public static Stack<DDMTemplate> getRecentDDMTemplates(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        Stack recentDDMTemplates = (Stack)portletSession.getAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_TEMPLATES");
        if (recentDDMTemplates == null) {
            recentDDMTemplates = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_DYNAMIC_DATA_MAPPING_TEMPLATES", (Object)recentDDMTemplates);
        }
        return recentDDMTemplates;
    }

    public static int getRestrictionType(long folderId) {
        int restrictionType = 0;
        JournalFolder folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId);
        if (folder != null) {
            restrictionType = folder.getRestrictionType();
        }
        return restrictionType;
    }

    public static String getTemplateScript(DDMTemplate ddmTemplate, Map<String, String> tokens, String languageId, boolean transform) {
        String[] transformerListenerClassNames;
        String script = ddmTemplate.getScript();
        if (!transform) {
            return script;
        }
        for (String transformerListenerClassName : transformerListenerClassNames = PropsUtil.getArray("journal.transformer.listener")) {
            TransformerListener transformerListener = null;
            try {
                transformerListener = (TransformerListener)InstanceFactory.newInstance((String)transformerListenerClassName);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                script = transformerListener.onScript(script, (com.liferay.portal.kernel.xml.Document)null, languageId, tokens);
            }
        }
        return script;
    }

    public static String getTemplateScript(long groupId, String ddmTemplateKey, Map<String, String> tokens, String languageId) throws PortalException {
        return JournalUtil.getTemplateScript(groupId, ddmTemplateKey, tokens, languageId, true);
    }

    public static String getTemplateScript(long groupId, String ddmTemplateKey, Map<String, String> tokens, String languageId, boolean transform) throws PortalException {
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)groupId, (long)PortalUtil.getClassNameId(DDMStructure.class), (String)ddmTemplateKey, (boolean)true);
        return JournalUtil.getTemplateScript(ddmTemplate, tokens, languageId, transform);
    }

    public static Map<String, String> getTokens(long articleGroupId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        HashMap<String, String> tokens;
        block5: {
            ThemeDisplayModel themeDisplayModel;
            tokens = new HashMap<String, String>();
            if (themeDisplay != null) {
                JournalUtil._populateTokens(tokens, articleGroupId, themeDisplay);
            } else if (portletRequestModel != null && (themeDisplayModel = portletRequestModel.getThemeDisplayModel()) != null) {
                try {
                    JournalUtil._populateTokens(tokens, articleGroupId, themeDisplayModel);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)e, (Throwable)e);
                }
            }
        }
        return tokens;
    }

    public static Map<String, String> getTokens(long articleGroupId, ThemeDisplay themeDisplay) throws PortalException {
        return JournalUtil.getTokens(articleGroupId, null, themeDisplay);
    }

    public static String getUrlTitle(long id, String title) {
        if (title == null) {
            return String.valueOf(id);
        }
        title = Validator.isNull((String)(title = StringUtil.toLowerCase((String)title.trim()))) || Validator.isNumber((String)title) || title.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalize((String)title, (Pattern)_friendlyURLPattern);
        return ModelHintsUtil.trimString((String)JournalArticle.class.getName(), (String)"urlTitle", (String)title);
    }

    public static boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException {
        return JournalUtil.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    public static boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
            ancestorFolderIds.add(folderId);
            if (recursive) {
                ancestorFolderIds.addAll(folder.getAncestorFolderIds());
                ancestorFolderIds.add(groupId);
            }
        } else {
            ancestorFolderIds.add(groupId);
        }
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)JournalFolder.class.getName(), (long[])ArrayUtil.toLongArray(ancestorFolderIds));
    }

    public static boolean isSubscribedToStructure(long companyId, long groupId, long userId, long ddmStructureId) {
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DDMStructure.class.getName(), (long)ddmStructureId);
    }

    public static String mergeArticleContent(String curContent, String newContent, boolean removeNullElements) {
        try {
            com.liferay.portal.kernel.xml.Document curDocument = SAXReaderUtil.read((String)curContent);
            com.liferay.portal.kernel.xml.Document newDocument = SAXReaderUtil.read((String)newContent);
            Element curRootElement = curDocument.getRootElement();
            Element newRootElement = newDocument.getRootElement();
            curRootElement.addAttribute("default-locale", newRootElement.attributeValue("default-locale"));
            curRootElement.addAttribute("available-locales", newRootElement.attributeValue("available-locales"));
            JournalUtil._mergeArticleContentUpdate(curDocument, newRootElement, LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()));
            if (removeNullElements) {
                JournalUtil._mergeArticleContentDelete(curRootElement, newDocument);
            }
            curContent = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)curDocument);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return curContent;
    }

    public static String prepareLocalizedContentForImport(String content, Locale defaultImportLocale) throws LocaleException {
        try {
            Attribute defaultLocaleAttribute;
            Locale defaultContentLocale;
            com.liferay.portal.kernel.xml.Document oldDocument = SAXReaderUtil.read((String)content);
            com.liferay.portal.kernel.xml.Document newDocument = SAXReaderUtil.read((String)content);
            Element newRootElement = newDocument.getRootElement();
            Attribute availableLocalesAttribute = newRootElement.attribute("available-locales");
            String defaultImportLanguageId = LocaleUtil.toLanguageId((Locale)defaultImportLocale);
            if (!StringUtil.contains((String)availableLocalesAttribute.getValue(), (String)defaultImportLanguageId)) {
                availableLocalesAttribute.setValue(availableLocalesAttribute.getValue() + "," + defaultImportLanguageId);
                JournalUtil._mergeArticleContentUpdate(oldDocument, newRootElement, LocaleUtil.toLanguageId((Locale)defaultImportLocale));
                content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)newDocument);
            }
            if (!LocaleUtil.equals((Locale)(defaultContentLocale = LocaleUtil.fromLanguageId((String)(defaultLocaleAttribute = newRootElement.attribute("default-locale")).getValue())), (Locale)defaultImportLocale)) {
                defaultLocaleAttribute.setValue(defaultImportLanguageId);
                content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)newDocument);
            }
        }
        catch (Exception e) {
            throw new LocaleException(3, "The locale " + defaultImportLocale + " is not available");
        }
        return content;
    }

    public static String removeArticleLocale(com.liferay.portal.kernel.xml.Document document, String content, String languageId) {
        try {
            Element rootElement = document.getRootElement();
            String availableLocales = rootElement.attributeValue("available-locales");
            if (availableLocales == null) {
                return content;
            }
            if ((availableLocales = StringUtil.removeFromList((String)availableLocales, (String)languageId)).endsWith(",")) {
                availableLocales = availableLocales.substring(0, availableLocales.length() - 1);
            }
            rootElement.addAttribute("available-locales", availableLocales);
            JournalUtil.removeArticleLocale(rootElement, languageId);
            content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)document);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return content;
    }

    public static void removeArticleLocale(Element element, String languageId) throws PortalException {
        for (Element dynamicElementElement : element.elements("dynamic-element")) {
            for (Element dynamicContentElement : dynamicElementElement.elements("dynamic-content")) {
                String curLanguageId = GetterUtil.getString((String)dynamicContentElement.attributeValue("language-id"));
                if (!curLanguageId.equals(languageId)) continue;
                long id = GetterUtil.getLong((String)dynamicContentElement.attributeValue("id"));
                if (id > 0L) {
                    ImageLocalServiceUtil.deleteImage((long)id);
                }
                dynamicContentElement.detach();
            }
            JournalUtil.removeArticleLocale(dynamicElementElement, languageId);
        }
    }

    public static String removeOldContent(String content, String xsd) {
        try {
            com.liferay.portal.kernel.xml.Document contentDoc = SAXReaderUtil.read((String)content);
            com.liferay.portal.kernel.xml.Document xsdDoc = SAXReaderUtil.read((String)xsd);
            Element contentRoot = contentDoc.getRootElement();
            Stack<String> path = new Stack<String>();
            path.push(contentRoot.getName());
            JournalUtil._removeOldContent(path, contentRoot, xsdDoc);
            content = DDMXMLUtil.formatXML((com.liferay.portal.kernel.xml.Document)contentDoc);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return content;
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId) {
        JournalUtil.removeRecentArticle(portletRequest, articleId, 0.0);
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId, double version) {
        Stack<JournalArticle> stack = JournalUtil.getRecentArticles(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalArticle journalArticle = (JournalArticle)itr.next();
            if (!journalArticle.getArticleId().equals(articleId) || journalArticle.getVersion() != version && version != 0.0) continue;
            itr.remove();
        }
    }

    public static void removeRecentDDMStructure(PortletRequest portletRequest, String ddmStructureKey) {
        Stack<DDMStructure> stack = JournalUtil.getRecentDDMStructures(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            DDMStructure ddmStructure = (DDMStructure)itr.next();
            if (!ddmStructureKey.equals(ddmStructure.getStructureKey())) continue;
            itr.remove();
            break;
        }
    }

    public static void removeRecentDDMTemplate(PortletRequest portletRequest, String ddmTemplateKey) {
        Stack<DDMTemplate> stack = JournalUtil.getRecentDDMTemplates(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            DDMTemplate ddmTemplate = (DDMTemplate)itr.next();
            if (!ddmTemplateKey.equals(ddmTemplate.getTemplateKey())) continue;
            itr.remove();
            break;
        }
    }

    public static String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, com.liferay.portal.kernel.xml.Document document, PortletRequestModel portletRequestModel, String script, String langType) throws Exception {
        return _transformer.transform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType);
    }

    private static void _addElementOptions(Element curContentElement, Element newContentElement) {
        List newElementOptions = newContentElement.elements("option");
        for (Element newElementOption : newElementOptions) {
            Element curElementOption = SAXReaderUtil.createElement((String)"option");
            curElementOption.addCDATA(newElementOption.getText());
            curContentElement.add(curElementOption);
        }
    }

    private static Element _getElementByInstanceId(com.liferay.portal.kernel.xml.Document document, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            return null;
        }
        XPath xPathSelector = SAXReaderUtil.createXPath((String)("//dynamic-element[@instance-id=" + HtmlUtil.escapeXPathAttribute((String)instanceId) + "]"));
        List nodes = xPathSelector.selectNodes((Object)document);
        if (nodes.size() == 1) {
            return (Element)nodes.get(0);
        }
        return null;
    }

    private static void _mergeArticleContentDelete(Element curParentElement, com.liferay.portal.kernel.xml.Document newDocument) throws Exception {
        List curElements = curParentElement.elements("dynamic-element");
        for (int i = 0; i < curElements.size(); ++i) {
            Element curElement = (Element)curElements.get(i);
            JournalUtil._mergeArticleContentDelete(curElement, newDocument);
            String instanceId = curElement.attributeValue("instance-id");
            Element newElement = JournalUtil._getElementByInstanceId(newDocument, instanceId);
            if (newElement != null) continue;
            curElement.detach();
        }
    }

    private static void _mergeArticleContentUpdate(com.liferay.portal.kernel.xml.Document curDocument, Element newParentElement, Element newElement, int pos, String defaultLocale) throws Exception {
        JournalUtil._mergeArticleContentUpdate(curDocument, newElement, defaultLocale);
        String instanceId = newElement.attributeValue("instance-id");
        Element curElement = JournalUtil._getElementByInstanceId(curDocument, instanceId);
        if (curElement != null) {
            JournalUtil._mergeArticleContentUpdate(curElement, newElement, defaultLocale);
        } else {
            String parentInstanceId = newParentElement.attributeValue("instance-id");
            if (Validator.isNull((String)parentInstanceId)) {
                Element curRoot = curDocument.getRootElement();
                List curRootElements = curRoot.elements();
                curRootElements.add(pos, newElement.createCopy());
            } else {
                Element curParentElement = JournalUtil._getElementByInstanceId(curDocument, parentInstanceId);
                if (curParentElement != null) {
                    List curParentElements = curParentElement.elements();
                    curParentElements.add(pos, newElement.createCopy());
                }
            }
        }
    }

    private static void _mergeArticleContentUpdate(com.liferay.portal.kernel.xml.Document curDocument, Element newParentElement, String defaultLocale) throws Exception {
        List newElements = newParentElement.elements("dynamic-element");
        for (int i = 0; i < newElements.size(); ++i) {
            Element newElement = (Element)newElements.get(i);
            JournalUtil._mergeArticleContentUpdate(curDocument, newParentElement, newElement, i, defaultLocale);
        }
    }

    private static void _mergeArticleContentUpdate(Element curElement, Element newElement, String defaultLocale) {
        Attribute curTypeAttribute = curElement.attribute("type");
        Attribute newTypeAttribute = newElement.attribute("type");
        curTypeAttribute.setValue(newTypeAttribute.getValue());
        Attribute curIndexTypeAttribute = curElement.attribute("index-type");
        Attribute newIndexTypeAttribute = newElement.attribute("index-type");
        if (newIndexTypeAttribute != null) {
            if (curIndexTypeAttribute == null) {
                curElement.addAttribute("index-type", newIndexTypeAttribute.getValue());
            } else {
                curIndexTypeAttribute.setValue(newIndexTypeAttribute.getValue());
            }
        }
        List elements = newElement.elements("dynamic-content");
        Element newContentElement = (Element)elements.get(0);
        String newLanguageId = newContentElement.attributeValue("language-id");
        String newValue = newContentElement.getText();
        String indexType = newElement.attributeValue("index-type");
        if (Validator.isNotNull((String)indexType)) {
            curElement.addAttribute("index-type", indexType);
        }
        List curContentElements = curElement.elements("dynamic-content");
        if (Validator.isNull((String)newLanguageId)) {
            for (Element curContentElement : curContentElements) {
                curContentElement.detach();
            }
            Element curContentElement = SAXReaderUtil.createElement((String)"dynamic-content");
            if (newContentElement.element("option") != null) {
                JournalUtil._addElementOptions(curContentElement, newContentElement);
            } else {
                curContentElement.addCDATA(newValue);
            }
            curElement.add(curContentElement);
        } else {
            boolean alreadyExists = false;
            for (Element curContentElement : curContentElements) {
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (!newLanguageId.equals(curLanguageId)) continue;
                alreadyExists = true;
                curContentElement.clearContent();
                if (newContentElement.element("option") != null) {
                    JournalUtil._addElementOptions(curContentElement, newContentElement);
                    break;
                }
                curContentElement.addCDATA(newValue);
                break;
            }
            if (!alreadyExists) {
                Element curContentElement = (Element)curContentElements.get(0);
                String curLanguageId = curContentElement.attributeValue("language-id");
                if (Validator.isNull((String)curLanguageId)) {
                    if (newLanguageId.equals(defaultLocale)) {
                        curContentElement.clearContent();
                        if (newContentElement.element("option") != null) {
                            JournalUtil._addElementOptions(curContentElement, newContentElement);
                        } else {
                            curContentElement.addCDATA(newValue);
                        }
                    } else {
                        curElement.add(newContentElement.createCopy());
                    }
                    curContentElement.addAttribute("language-id", defaultLocale);
                } else {
                    curElement.add(newContentElement.createCopy());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void _populateCustomTokens(Map<String, String> tokens) {
        if (_customTokens == null) {
            Class<JournalUtil> clazz = JournalUtil.class;
            // MONITORENTER : com.liferay.portlet.journal.util.JournalUtil.class
            _customTokens = new HashMap<String, String>();
            for (String customToken : PropsValues.JOURNAL_ARTICLE_CUSTOM_TOKENS) {
                String value = PropsUtil.get("journal.article.custom.token.value", new Filter(customToken));
                _customTokens.put(customToken, value);
            }
            // MONITOREXIT : clazz
        }
        if (_customTokens.isEmpty()) return;
        tokens.putAll(_customTokens);
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplay.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplay.getPathFriendlyURLPrivateUser() : themeDisplay.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplay.getI18nPath();
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname) || !virtualHostname.equals(themeDisplay.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplay.getCDNHost());
        tokens.put("company_id", String.valueOf(themeDisplay.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplay.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplay.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplay.getPathMain());
        tokens.put("portal_ctx", themeDisplay.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplay.getURLPortal()));
        tokens.put("root_path", themeDisplay.getPathContext());
        tokens.put("site_group_id", String.valueOf(themeDisplay.getSiteGroupId()));
        tokens.put("scope_group_id", String.valueOf(themeDisplay.getScopeGroupId()));
        tokens.put("theme_image_path", themeDisplay.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens);
        tokens.put("friendly_url", themeDisplay.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplay.getPathFriendlyURLPrivateGroup());
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplay.getPathFriendlyURLPublic());
    }

    private static void _populateTokens(Map<String, String> tokens, long articleGroupId, ThemeDisplayModel themeDisplayModel) throws Exception {
        Layout layout = LayoutLocalServiceUtil.getLayout((long)themeDisplayModel.getPlid());
        Group group = layout.getGroup();
        LayoutSet layoutSet = layout.getLayoutSet();
        String friendlyUrlCurrent = null;
        friendlyUrlCurrent = layout.isPublicLayout() ? themeDisplayModel.getPathFriendlyURLPublic() : (group.isUserGroup() ? themeDisplayModel.getPathFriendlyURLPrivateUser() : themeDisplayModel.getPathFriendlyURLPrivateGroup());
        String layoutSetFriendlyUrl = themeDisplayModel.getI18nPath();
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull((String)virtualHostname) || !virtualHostname.equals(themeDisplayModel.getServerName())) {
            layoutSetFriendlyUrl = friendlyUrlCurrent + group.getFriendlyURL();
        }
        tokens.put("article_group_id", String.valueOf(articleGroupId));
        tokens.put("cdn_host", themeDisplayModel.getCdnHost());
        tokens.put("company_id", String.valueOf(themeDisplayModel.getCompanyId()));
        tokens.put("friendly_url_current", friendlyUrlCurrent);
        tokens.put("friendly_url_private_group", themeDisplayModel.getPathFriendlyURLPrivateGroup());
        tokens.put("friendly_url_private_user", themeDisplayModel.getPathFriendlyURLPrivateUser());
        tokens.put("friendly_url_public", themeDisplayModel.getPathFriendlyURLPublic());
        tokens.put("group_friendly_url", group.getFriendlyURL());
        tokens.put("image_path", themeDisplayModel.getPathImage());
        tokens.put("layout_set_friendly_url", layoutSetFriendlyUrl);
        tokens.put("main_path", themeDisplayModel.getPathMain());
        tokens.put("portal_ctx", themeDisplayModel.getPathContext());
        tokens.put("portal_url", HttpUtil.removeProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("protocol", HttpUtil.getProtocol((String)themeDisplayModel.getURLPortal()));
        tokens.put("root_path", themeDisplayModel.getPathContext());
        tokens.put("scope_group_id", String.valueOf(themeDisplayModel.getScopeGroupId()));
        tokens.put("theme_image_path", themeDisplayModel.getPathThemeImages());
        JournalUtil._populateCustomTokens(tokens);
        tokens.put("friendly_url", themeDisplayModel.getPathFriendlyURLPublic());
        tokens.put("friendly_url_private", themeDisplayModel.getPathFriendlyURLPrivateGroup());
        tokens.put("group_id", String.valueOf(articleGroupId));
        tokens.put("page_url", themeDisplayModel.getPathFriendlyURLPublic());
    }

    private static void _removeOldContent(Stack<String> path, Element contentElement, com.liferay.portal.kernel.xml.Document xsdDocument) {
        int i;
        String elementPath = "";
        for (i = 0; i < path.size(); ++i) {
            elementPath = elementPath + "/" + (String)path.elementAt(i);
        }
        for (i = 0; i < contentElement.nodeCount(); ++i) {
            Node contentNode = contentElement.node(i);
            if (!(contentNode instanceof Element)) continue;
            JournalUtil._removeOldContent(path, (Element)contentNode, xsdDocument, elementPath);
        }
    }

    private static void _removeOldContent(Stack<String> path, Element contentElement, com.liferay.portal.kernel.xml.Document xsdDocument, String elementPath) {
        String name = contentElement.attributeValue("name");
        if (Validator.isNull((String)name)) {
            return;
        }
        String localPath = "dynamic-element[@name=" + HtmlUtil.escapeXPathAttribute((String)name) + "]";
        String fullPath = elementPath + "/" + localPath;
        XPath xPathSelector = SAXReaderUtil.createXPath((String)fullPath);
        List curNodes = xPathSelector.selectNodes((Object)xsdDocument);
        if (curNodes.isEmpty()) {
            contentElement.detach();
        }
        path.push(localPath);
        JournalUtil._removeOldContent(path, contentElement, xsdDocument);
        path.pop();
    }

    static {
        _friendlyURLPattern = Pattern.compile("[^a-z0-9_-]");
        _transformer = new Transformer("journal.transformer.listener", "journal.error.template", true);
    }
}

