/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.StructureFieldException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexerUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;

public class JournalArticleIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    public static final String PORTLET_ID = "15";
    private static Log _log = LogFactoryUtil.getLog(JournalArticleIndexer.class);

    public JournalArticleIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"articleId", "companyId", "defaultLanguageId", "entryClassName", "entryClassPK", "groupId", "version", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "description", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
        this.setSelectAllLocales(true);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getPortletId() {
        return PORTLET_ID;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        List articles = JournalArticleLocalServiceUtil.getArticlesByResourcePrimKey((long)classPK);
        for (JournalArticle article : articles) {
            if (!this.isVisible(article.getStatus(), status)) continue;
            return true;
        }
        return false;
    }

    public void postProcessContextQuery(BooleanQuery contextQuery, SearchContext searchContext) throws Exception {
        String ddmTemplateKey;
        String ddmStructureKey;
        String articleType;
        Long classNameId = (Long)searchContext.getAttribute("classNameId");
        if (classNameId != null && classNameId != 0L) {
            contextQuery.addRequiredTerm("classNameId", classNameId.toString());
        }
        this.addStatus(contextQuery, searchContext);
        this.addSearchClassTypeIds(contextQuery, searchContext);
        String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            String[] ddmStructureFieldNameParts = StringUtil.split((String)ddmStructureFieldName, (String)"__");
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)GetterUtil.getLong((String)ddmStructureFieldNameParts[1]));
            String fieldName = StringUtil.replaceLast((String)ddmStructureFieldNameParts[2], (String)"_".concat(LocaleUtil.toLanguageId((Locale)searchContext.getLocale())), (String)"");
            try {
                ddmStructureFieldValue = DDMUtil.getIndexedFieldValue((Serializable)ddmStructureFieldValue, (String)structure.getFieldType(fieldName));
            }
            catch (StructureFieldException sfe) {
                // empty catch block
            }
            contextQuery.addRequiredTerm(ddmStructureFieldName, "\"" + ddmStructureFieldValue + "\"");
        }
        if (Validator.isNotNull((String)(articleType = (String)((Object)searchContext.getAttribute("articleType"))))) {
            contextQuery.addRequiredTerm("type", articleType);
        }
        if (Validator.isNotNull((String)(ddmStructureKey = (String)((Object)searchContext.getAttribute("ddmStructureKey"))))) {
            contextQuery.addRequiredTerm("ddmStructureKey", ddmStructureKey);
        }
        if (Validator.isNotNull((String)(ddmTemplateKey = (String)((Object)searchContext.getAttribute("ddmTemplateKey"))))) {
            contextQuery.addRequiredTerm("ddmTemplateKey", ddmTemplateKey);
        }
        boolean head = GetterUtil.getBoolean((Object)searchContext.getAttribute("head"), (boolean)Boolean.TRUE);
        boolean relatedClassName = GetterUtil.getBoolean((Object)searchContext.getAttribute("relatedClassName"));
        if (head && !relatedClassName) {
            contextQuery.addRequiredTerm("head", Boolean.TRUE);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "articleId", false);
        this.addSearchTerm(searchQuery, searchContext, "classPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "type", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addDDMStructureAttributes(Document document, JournalArticle article) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
        if (ddmStructure == null) {
            return;
        }
        document.addKeyword("classTypeId", ddmStructure.getStructureId());
        Fields fields = null;
        try {
            fields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (com.liferay.portal.kernel.xml.Document)article.getDocument());
        }
        catch (Exception e) {
            return;
        }
        if (fields != null) {
            DDMIndexerUtil.addAttributes((Document)document, (DDMStructure)ddmStructure, (Fields)fields);
        }
    }

    protected void addSearchLocalizedTerm(BooleanQuery searchQuery, SearchContext searchContext, String field, boolean like) throws Exception {
        if (Validator.isNull((String)field)) {
            return;
        }
        String value = String.valueOf(searchContext.getAttribute(field));
        if (Validator.isNull((String)value)) {
            value = searchContext.getKeywords();
        }
        if (Validator.isNull((String)value)) {
            return;
        }
        String localizedField = DocumentImpl.getLocalizedName((Locale)searchContext.getLocale(), (String)field);
        if (Validator.isNull((String)searchContext.getKeywords())) {
            BooleanQuery localizedQuery = BooleanQueryFactoryUtil.create((SearchContext)searchContext);
            localizedQuery.addTerm(field, value, like);
            localizedQuery.addTerm(localizedField, value, like);
            BooleanClauseOccur booleanClauseOccur = BooleanClauseOccur.SHOULD;
            if (searchContext.isAndSearch()) {
                booleanClauseOccur = BooleanClauseOccur.MUST;
            }
            searchQuery.add((Query)localizedQuery, booleanClauseOccur);
        } else {
            searchQuery.addTerm(localizedField, value, like);
        }
    }

    protected void doDelete(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        long classPK = article.getId();
        if (!PropsValues.JOURNAL_ARTICLE_INDEX_ALL_VERSIONS) {
            classPK = article.getResourcePrimKey();
        }
        this.deleteDocument(article.getCompanyId(), classPK);
        if (!article.isApproved()) {
            return;
        }
        JournalArticle latestIndexableArticle = JournalArticleLocalServiceUtil.fetchLatestIndexableArticle((long)article.getResourcePrimKey());
        if (latestIndexableArticle == null || PropsValues.JOURNAL_ARTICLE_INDEX_ALL_VERSIONS && latestIndexableArticle.getVersion() > article.getVersion()) {
            return;
        }
        SearchEngineUtil.updateDocument((String)this.getSearchEngineId(), (long)article.getCompanyId(), (Document)this.getDocument(latestIndexableArticle), (boolean)this.isCommitImmediately());
    }

    protected Document doGetDocument(Object obj) throws Exception {
        String[] languageIds;
        JournalArticle article = (JournalArticle)obj;
        Document document = this.getBaseModelDocument(PORTLET_ID, (BaseModel)article);
        long classPK = article.getId();
        if (!PropsValues.JOURNAL_ARTICLE_INDEX_ALL_VERSIONS) {
            classPK = article.getResourcePrimKey();
        }
        document.addUID(PORTLET_ID, classPK);
        String articleDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((com.liferay.portal.kernel.xml.Document)article.getDocument());
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        for (String languageId : languageIds = this.getLanguageIds(defaultLanguageId, article.getDocument())) {
            String content = this.extractDDMContent(article, languageId);
            String description = article.getDescription(languageId);
            String title = article.getTitle(languageId);
            if (languageId.equals(articleDefaultLanguageId)) {
                document.addText("content", content);
                document.addText("description", description);
                document.addText("title", title);
                document.addText("defaultLanguageId", languageId);
            }
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), content);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), title);
        }
        document.addKeyword("folderId", article.getFolderId());
        String articleId = article.getArticleId();
        if (article.isInTrash()) {
            articleId = TrashUtil.getOriginalTitle((String)articleId);
        }
        document.addKeyword("articleId", articleId);
        document.addKeyword("layoutUuid", article.getLayoutUuid());
        document.addKeyword("treePath", StringUtil.split((String)article.getTreePath(), (char)'/'));
        document.addKeyword("type", article.getType());
        document.addKeyword("version", article.getVersion());
        document.addKeyword("ddmStructureKey", article.getStructureId());
        document.addKeyword("ddmTemplateKey", article.getTemplateId());
        document.addDate("displayDate", article.getDisplayDate());
        document.addKeyword("head", this.isHead(article));
        this.addDDMStructureAttributes(document, article);
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("display-date")) {
            return "displayDate";
        }
        if (orderByCol.equals("id")) {
            return "entryClassPK";
        }
        if (orderByCol.equals("modified-date")) {
            return "modified";
        }
        if (orderByCol.equals("title")) {
            return "title";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletURL portletURL, PortletRequest portletRequest, PortletResponse portletResponse) {
        Locale snippetLocale = this.getSnippetLocale(document, locale);
        String localizedTitleName = DocumentImpl.getLocalizedName((Locale)locale, (String)"title");
        if (snippetLocale == null || document.getField(localizedTitleName) == null) {
            snippetLocale = LocaleUtil.fromLanguageId((String)document.get("defaultLanguageId"));
        }
        String title = document.get(snippetLocale, "snippet_title", "title");
        String content = this.getDDMContentSummary(document, snippetLocale, portletRequest, portletResponse);
        String articleId = document.get("articleId");
        String groupId = document.get("groupId");
        String version = document.get("version");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("groupId", groupId);
        portletURL.setParameter("articleId", articleId);
        portletURL.setParameter("version", version);
        return new Summary(snippetLocale, title, content, portletURL);
    }

    protected void doReindex(Object obj) throws Exception {
        JournalArticle article = (JournalArticle)obj;
        if (PortalUtil.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            Document document = this.getDocument(article);
            SearchEngineUtil.deleteDocument((String)this.getSearchEngineId(), (long)article.getCompanyId(), (String)document.get("uid"), (boolean)this.isCommitImmediately());
            return;
        }
        this.reindexArticleVersions(article);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchJournalArticle((long)classPK);
        if (article == null) {
            article = JournalArticleLocalServiceUtil.fetchLatestIndexableArticle((long)classPK);
        }
        if (article != null) {
            this.doReindex(article);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexArticles(companyId);
    }

    protected void doReindexDDMStructures(List<Long> ddmStructureIds) throws Exception {
        String[] ddmStructureKeys = new String[ddmStructureIds.size()];
        for (int i = 0; i < ddmStructureIds.size(); ++i) {
            long structureId = ddmStructureIds.get(i);
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getDDMStructure((long)structureId);
            ddmStructureKeys[i] = ddmStructure.getStructureKey();
        }
        List articles = JournalArticleLocalServiceUtil.getStructureArticles((String[])ddmStructureKeys);
        for (JournalArticle article : articles) {
            this.doReindex(article);
        }
    }

    protected String extractDDMContent(JournalArticle article, String languageId) throws Exception {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
        if (ddmStructure == null) {
            return "";
        }
        Fields fields = null;
        try {
            fields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (com.liferay.portal.kernel.xml.Document)article.getDocument());
        }
        catch (Exception e) {
            return "";
        }
        if (fields == null) {
            return "";
        }
        return DDMIndexerUtil.extractAttributes((DDMStructure)ddmStructure, (Fields)fields, (Locale)LocaleUtil.fromLanguageId((String)languageId));
    }

    protected Collection<Document> getArticleVersions(JournalArticle article) throws PortalException {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<JournalArticle> articles = null;
        if (PropsValues.JOURNAL_ARTICLE_INDEX_ALL_VERSIONS) {
            articles = JournalArticleLocalServiceUtil.getIndexableArticlesByResourcePrimKey((long)article.getResourcePrimKey());
        } else {
            articles = new ArrayList<JournalArticle>();
            JournalArticle latestIndexableArticle = JournalArticleLocalServiceUtil.fetchLatestIndexableArticle((long)article.getResourcePrimKey());
            if (latestIndexableArticle != null) {
                articles.add(latestIndexableArticle);
            }
        }
        for (JournalArticle curArticle : articles) {
            Document document = this.getDocument(curArticle);
            documents.add(document);
        }
        return documents;
    }

    protected String getDDMContentSummary(Document document, Locale snippetLocale, PortletRequest portletRequest, PortletResponse portletResponse) {
        String content;
        block4: {
            content = "";
            if (portletRequest == null || portletResponse == null) {
                return content;
            }
            try {
                String articleId = document.get("articleId");
                long groupId = GetterUtil.getLong((String)document.get("groupId"));
                double version = GetterUtil.getDouble((String)document.get("version"));
                PortletRequestModel portletRequestModel = new PortletRequestModel(portletRequest, portletResponse);
                ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                JournalArticleDisplay articleDisplay = JournalContentUtil.getDisplay((long)groupId, (String)articleId, (double)version, null, (String)"view", (String)LocaleUtil.toLanguageId((Locale)snippetLocale), (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
                content = HtmlUtil.escape((String)articleDisplay.getDescription());
                content = HtmlUtil.replaceNewLine((String)content);
                if (Validator.isNull((String)content)) {
                    content = HtmlUtil.extractText((String)articleDisplay.getContent());
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return content;
    }

    protected String[] getLanguageIds(String defaultLanguageId, com.liferay.portal.kernel.xml.Document document) {
        String[] languageIds = LocalizationUtil.getAvailableLanguageIds((com.liferay.portal.kernel.xml.Document)document);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected boolean isHead(JournalArticle article) {
        if (!PropsValues.JOURNAL_ARTICLE_INDEX_ALL_VERSIONS) {
            return true;
        }
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)article.getResourcePrimKey(), (int[])new int[]{0, 8});
        if (latestArticle != null && !latestArticle.isIndexable()) {
            return false;
        }
        return latestArticle != null && article.getId() == latestArticle.getId();
    }

    protected void reindexArticles(long companyId) throws PortalException {
        final ActionableDynamicQuery actionableDynamicQuery = JournalArticleLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                JournalArticle article = (JournalArticle)object;
                Document document = JournalArticleIndexer.this.getDocument(article);
                actionableDynamicQuery.addDocument(document);
            }
        });
        actionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        actionableDynamicQuery.performActions();
    }

    protected void reindexArticleVersions(JournalArticle article) throws PortalException {
        SearchEngineUtil.updateDocuments((String)this.getSearchEngineId(), (long)article.getCompanyId(), this.getArticleVersions(article), (boolean)this.isCommitImmediately());
    }
}

