/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.trash;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.InvalidDDMStructureException;
import com.liferay.portlet.journal.asset.JournalFolderAssetRenderer;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.journal.trash.JournalBaseTrashHandler;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.trash.RestoreEntryException;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class JournalFolderTrashHandler
extends JournalBaseTrashHandler {
    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        this.checkRestorableEntry(classPK, 0L, containerModelId, folder.getName(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        JournalFolderLocalServiceUtil.deleteFolder((long)classPK, (boolean)false);
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        JournalFolder folder = this.getJournalFolder(classPK);
        long parentFolderId = folder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, folder.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalUtil.getJournalControlPanelLink(portletRequest, folder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalUtil.getAbsolutePath(portletRequest, folder.getParentFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return new JournalFolderAssetRenderer(folder);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return JournalFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isInTrash(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException {
        JournalFolder folder = this.getJournalFolder(classPK);
        return folder.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException {
        JournalFolder folder = this.getJournalFolder(classPK);
        if (folder.getParentFolderId() > 0L && JournalFolderLocalServiceUtil.fetchFolder((long)folder.getParentFolderId()) == null) {
            return false;
        }
        return !folder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        JournalFolderLocalServiceUtil.moveFolder((long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        JournalFolderLocalServiceUtil.moveFolderFromTrash((long)userId, (long)classPK, (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        JournalFolderLocalServiceUtil.restoreFolderFromTrash((long)userId, (long)classPK);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        folder.setName(name);
        JournalFolderLocalServiceUtil.updateJournalFolder((JournalFolder)folder);
    }

    protected void checkDuplicateEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        JournalFolder duplicateFolder;
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        if (containerModelId == -1L) {
            containerModelId = 0L;
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateFolder = JournalFolderLocalServiceUtil.fetchFolder((long)folder.getGroupId(), (long)containerModelId, (String)originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateFolder.getFolderId());
            ree.setOldName(duplicateFolder.getName());
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        this.checkValidContainer(classPK, containerModelId);
        this.checkDuplicateEntry(classPK, trashEntryId, containerModelId, originalTitle, newName);
    }

    protected void checkValidContainer(long classPK, long containerModelId) throws PortalException {
        try {
            JournalFolderLocalServiceUtil.validateFolderDDMStructures((long)classPK, (long)containerModelId);
        }
        catch (InvalidDDMStructureException iddmse) {
            throw new RestoreEntryException(2);
        }
    }

    @Override
    protected long getGroupId(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder.getGroupId();
    }

    protected JournalFolder getJournalFolder(long classPK) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return folder;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderPermission.contains(permissionChecker, folder, actionId);
    }
}

