/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.base.JournalFolderServiceBaseImpl;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import java.util.ArrayList;
import java.util.List;

public class JournalFolderServiceImpl
extends JournalFolderServiceBaseImpl {
    public JournalFolder addFolder(long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentFolderId, "ADD_FOLDER");
        return this.journalFolderLocalService.addFolder(this.getUserId(), groupId, parentFolderId, name, description, serviceContext);
    }

    public void deleteFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.journalFolderLocalService.deleteFolder(folderId);
    }

    public void deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        this.journalFolderLocalService.deleteFolder(folderId, includeTrashedEntries);
    }

    public JournalFolder fetchFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.fetchFolder(folderId);
        if (folder != null) {
            JournalFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        }
        return folder;
    }

    public JournalFolder getFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "VIEW");
        return folder;
    }

    public List<Long> getFolderIds(long groupId, long folderId) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "VIEW");
        List<Long> folderIds = this.getSubfolderIds(groupId, folderId, true);
        folderIds.add(0, folderId);
        return folderIds;
    }

    public List<JournalFolder> getFolders(long groupId) {
        return this.journalFolderPersistence.filterFindByGroupId(groupId);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, 0);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        return this.journalFolderPersistence.filterFindByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalFolderFinder.filterFindF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int start, int end, OrderByComparator<?> obc) {
        return this.getFoldersAndArticles(groupId, folderId, -1, start, end, obc);
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.journalArticleFinder.filterCountByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int articlesCount = this.journalArticleFinder.filterCountByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        folderIds.subList(start, end).clear();
        return articlesCount += this.getFoldersAndArticlesCount(groupId, folderIds, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId) {
        return this.getFoldersAndArticlesCount(groupId, folderId, -1);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId, int status) {
        return this.journalFolderFinder.filterCountF_A_ByG_F(groupId, folderId, new QueryDefinition(status));
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        if (status == -1) {
            return this.journalFolderPersistence.filterCountByG_P_NotS(groupId, parentFolderId, 8);
        }
        return this.journalFolderPersistence.filterCountByG_P_S(groupId, parentFolderId, status);
    }

    @Deprecated
    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        this.getSubfolderIds(folderIds, groupId, folderId, true);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId, boolean recurse) {
        List folders = this.journalFolderPersistence.filterFindByG_P_NotS(groupId, folderId, 8);
        for (JournalFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            if (!recurse) continue;
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId(), recurse);
        }
    }

    public List<Long> getSubfolderIds(long groupId, long folderId, boolean recurse) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        this.getSubfolderIds(folderIds, groupId, folderId, recurse);
        return folderIds;
    }

    public JournalFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.journalFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderFromTrash(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.journalFolderLocalService.moveFolderFromTrash(this.getUserId(), folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderToTrash(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "DELETE");
        return this.journalFolderLocalService.moveFolderToTrash(this.getUserId(), folderId);
    }

    public void restoreFolderFromTrash(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        this.journalFolderLocalService.restoreFolderFromTrash(this.getUserId(), folderId);
    }

    public void subscribe(long groupId, long folderId) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "SUBSCRIBE");
        this.journalFolderLocalService.subscribe(this.getUserId(), groupId, folderId);
    }

    public void unsubscribe(long groupId, long folderId) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), groupId, folderId, "SUBSCRIBE");
        this.journalFolderLocalService.unsubscribe(this.getUserId(), groupId, folderId);
    }

    public JournalFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.getFolder(folderId);
        JournalFolderPermission.check(this.getPermissionChecker(), folder, "UPDATE");
        return this.journalFolderLocalService.updateFolder(this.getUserId(), folderId, parentFolderId, name, description, mergeWithParentFolder, serviceContext);
    }

    public JournalFolder updateFolder(long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        JournalFolderPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), folderId, "UPDATE");
        return this.journalFolderLocalService.updateFolder(this.getUserId(), folderId, parentFolderId, name, description, ddmStructureIds, restrictionType, mergeWithParentFolder, serviceContext);
    }
}

