/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.TreeModelTasks;
import com.liferay.portal.kernel.util.TreeModelTasksAdapter;
import com.liferay.portal.kernel.util.TreePathUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.TreeModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.FolderNameException;
import com.liferay.portlet.journal.InvalidDDMStructureException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.base.JournalFolderLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.comparator.FolderIdComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JournalFolderLocalServiceImpl
extends JournalFolderLocalServiceBaseImpl {
    public JournalFolder addFolder(long userId, long groupId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validateFolder(0L, groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        JournalFolder folder = this.journalFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setUserName(user.getFullName());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.resourceLocalService.addModelResources((AuditedModel)folder, serviceContext);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public JournalFolder deleteFolder(JournalFolder folder) throws PortalException {
        return this.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, type=1)
    public JournalFolder deleteFolder(JournalFolder folder, boolean includeTrashedEntries) throws PortalException {
        List folders = this.journalFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (JournalFolder curFolder : folders) {
            if (!includeTrashedEntries && curFolder.isInTrashExplicitly()) continue;
            this.journalFolderLocalService.deleteFolder(curFolder, includeTrashedEntries);
        }
        Set<Long> ddmStructureIds = this.getDDMStructureIds(this.journalFolderPersistence.getDDMStructures(folder.getFolderId()));
        if (ddmStructureIds.isEmpty()) {
            ddmStructureIds.add(-1L);
        }
        this.journalFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource((AuditedModel)folder, 4);
        this.journalArticleLocalService.deleteArticles(folder.getGroupId(), folder.getFolderId(), includeTrashedEntries);
        this.assetEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(JournalFolder.class.getName(), folder.getFolderId());
        if (folder.isInTrashExplicitly()) {
            this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        } else {
            this.trashVersionLocalService.deleteTrashVersion(JournalFolder.class.getName(), folder.getFolderId());
        }
        for (long ddmStructureId : ddmStructureIds) {
            WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(folder.getCompanyId(), folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), ddmStructureId);
            if (workflowDefinitionLink == null) continue;
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
        return folder;
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, true);
    }

    @Indexable(type=IndexableType.DELETE)
    public JournalFolder deleteFolder(long folderId, boolean includeTrashedEntries) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        return this.journalFolderLocalService.deleteFolder(folder, includeTrashedEntries);
    }

    public void deleteFolders(long groupId) throws PortalException {
        List folders = this.journalFolderPersistence.findByGroupId(groupId);
        for (JournalFolder folder : folders) {
            this.journalFolderLocalService.deleteFolder(folder);
        }
    }

    public JournalFolder fetchFolder(long folderId) {
        return this.journalFolderPersistence.fetchByPrimaryKey(folderId);
    }

    public JournalFolder fetchFolder(long groupId, long parentFolderId, String name) {
        return this.journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
    }

    public JournalFolder fetchFolder(long groupId, String name) {
        return this.journalFolderPersistence.fetchByG_N(groupId, name);
    }

    public List<JournalFolder> getCompanyFolders(long companyId, int start, int end) {
        return this.journalFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) {
        return this.journalFolderPersistence.countByCompanyId(companyId);
    }

    public JournalFolder getFolder(long folderId) throws PortalException {
        return this.journalFolderPersistence.findByPrimaryKey(folderId);
    }

    public List<JournalFolder> getFolders(long groupId) {
        return this.journalFolderPersistence.findByGroupId(groupId);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId) {
        return this.getFolders(groupId, parentFolderId, 0);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int start, int end) {
        return this.getFolders(groupId, parentFolderId, 0, start, end);
    }

    public List<JournalFolder> getFolders(long groupId, long parentFolderId, int status, int start, int end) {
        return this.journalFolderPersistence.findByG_P_S(groupId, parentFolderId, status, start, end);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public List<Object> getFoldersAndArticles(long groupId, long folderId, int start, int end, OrderByComparator<?> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(-1, start, end, obc);
        return this.journalFolderFinder.findF_A_ByG_F(groupId, folderId, queryDefinition);
    }

    public int getFoldersAndArticlesCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        if (folderIds.size() <= PropsValues.SQL_DATA_MAX_PARAMETERS) {
            return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
        }
        int start = 0;
        int end = PropsValues.SQL_DATA_MAX_PARAMETERS;
        int articlesCount = this.journalArticleFinder.countByG_F(groupId, folderIds.subList(start, end), queryDefinition);
        folderIds.subList(start, end).clear();
        return articlesCount += this.getFoldersAndArticlesCount(groupId, folderIds, status);
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId) {
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, new QueryDefinition(-1));
    }

    public int getFoldersAndArticlesCount(long groupId, long folderId, int status) {
        return this.journalFolderFinder.countF_A_ByG_F(groupId, folderId, new QueryDefinition(status));
    }

    public int getFoldersCount(long groupId, long parentFolderId) {
        return this.getFoldersCount(groupId, parentFolderId, 0);
    }

    public int getFoldersCount(long groupId, long parentFolderId, int status) {
        return this.journalFolderPersistence.countByG_P_S(groupId, parentFolderId, status);
    }

    public long getInheritedWorkflowFolderId(long folderId) throws NoSuchFolderException {
        JournalFolder folder;
        while (folderId != 0L && (folder = this.journalFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() == 0) {
            folderId = folder.getParentFolderId();
        }
        return folderId;
    }

    public List<JournalFolder> getNoAssetFolders() {
        return this.journalFolderFinder.findF_ByNoAssets();
    }

    public long getOverridedDDMStructuresFolderId(long folderId) throws NoSuchFolderException {
        JournalFolder folder;
        while (folderId != 0L && (folder = this.journalFolderPersistence.findByPrimaryKey(folderId)).getRestrictionType() != 1) {
            folderId = folder.getParentFolderId();
        }
        return folderId;
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) {
        List folders = this.journalFolderPersistence.findByG_P(groupId, folderId);
        for (JournalFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        this.validateFolderDDMStructures(folder.getFolderId(), parentFolderId);
        this.validateFolder(folder.getFolderId(), folder.getGroupId(), parentFolderId, folder.getName());
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.rebuildTree(folder.getCompanyId(), folderId, folder.getTreePath(), true);
        return folder;
    }

    public JournalFolder moveFolderFromTrash(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        if (folder.isInTrashExplicitly()) {
            this.restoreFolderFromTrash(userId, folderId);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(JournalFolder.class.getName(), folderId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, folder, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(foldersAndArticles);
        }
        return this.journalFolderLocalService.moveFolder(folderId, parentFolderId, serviceContext);
    }

    public JournalFolder moveFolderToTrash(long userId, long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        String title = folder.getName();
        folder = this.updateStatus(userId, folder, 8);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", folder.getName());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), null, 0, null, typeSettingsProperties);
        folder.setName(TrashUtil.getTrashTitle((long)trashEntry.getEntryId()));
        this.journalFolderPersistence.update((BaseModel)folder);
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
        this.moveDependentsToTrash(foldersAndArticles, trashEntry.getEntryId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", title);
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), 10007, extraDataJSONObject.toString(), 0L);
        return folder;
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.rebuildTree(companyId, 0L, "/", false);
    }

    public void rebuildTree(long companyId, long parentFolderId, String parentTreePath, final boolean reindex) throws PortalException {
        TreePathUtil.rebuildTree((long)companyId, (long)parentFolderId, (String)parentTreePath, (TreeModelTasks)new TreeModelTasksAdapter<JournalFolder>(){

            public List<JournalFolder> findTreeModels(long previousId, long companyId, long parentPrimaryKey, int size) {
                return JournalFolderLocalServiceImpl.this.journalFolderPersistence.findByF_C_P_NotS(previousId, companyId, parentPrimaryKey, 8, -1, size, (OrderByComparator)new FolderIdComparator(true));
            }

            public void rebuildDependentModelsTreePaths(long parentPrimaryKey, String treePath) throws PortalException {
                JournalFolderLocalServiceImpl.this.journalArticleLocalService.setTreePaths(parentPrimaryKey, treePath, false);
            }

            public void reindexTreeModels(List<TreeModel> treeModels) throws PortalException {
                if (!reindex) {
                    return;
                }
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
                for (TreeModel treeModel : treeModels) {
                    indexer.reindex((Object)treeModel);
                }
            }
        });
    }

    public void restoreFolderFromTrash(long userId, long folderId) throws PortalException {
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        folder.setName(TrashUtil.getOriginalTitle((String)folder.getName()));
        this.journalFolderPersistence.update((BaseModel)folder);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalFolder.class.getName(), folderId);
        this.updateStatus(userId, folder, trashEntry.getStatus());
        List foldersAndArticles = this.journalFolderLocalService.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
        this.restoreDependentsFromTrash(foldersAndArticles);
        this.trashEntryLocalService.deleteEntry(JournalFolder.class.getName(), folder.getFolderId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", folder.getName());
        this.socialActivityLocalService.addActivity(userId, folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), 10008, extraDataJSONObject.toString(), 0L);
    }

    public void subscribe(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.addSubscription(userId, groupId, JournalFolder.class.getName(), folderId);
    }

    public void unsubscribe(long userId, long groupId, long folderId) throws PortalException {
        if (folderId == 0L) {
            folderId = groupId;
        }
        this.subscriptionLocalService.deleteSubscription(userId, JournalFolder.class.getName(), folderId);
    }

    public void updateAsset(long userId, JournalFolder folder, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, folder.getGroupId(), folder.getCreateDate(), folder.getModifiedDate(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, "text/plain", folder.getName(), folder.getDescription(), null, null, null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder updateFolder(long userId, long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        return this.updateFolder(userId, folderId, parentFolderId, name, description, new long[0], 0, mergeWithParentFolder, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalFolder updateFolder(long userId, long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        JournalFolder folder = null;
        Set<Object> originalDDMStructureIds = new HashSet();
        if (folderId > 0L) {
            originalDDMStructureIds = this.getDDMStructureIds(this.journalFolderPersistence.getDDMStructures(folderId));
            folder = this.doUpdateFolder(userId, folderId, parentFolderId, name, description, ddmStructureIds, restrictionType, mergeWithParentFolder, serviceContext);
        }
        ArrayList<ObjectValuePair> workflowDefinitionOVPs = new ArrayList<ObjectValuePair>();
        if (restrictionType == 1) {
            workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)""));
            for (long ddmStructureId : ddmStructureIds) {
                String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)("workflowDefinition" + ddmStructureId));
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)ddmStructureId, (Object)workflowDefinition));
            }
        } else if (restrictionType == 0) {
            if (originalDDMStructureIds.isEmpty()) {
                originalDDMStructureIds.add(-1L);
            }
            Iterator<Object> i$ = originalDDMStructureIds.iterator();
            while (i$.hasNext()) {
                long originalDDMStructureId = (Long)i$.next();
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalDDMStructureId, (Object)""));
            }
        } else if (restrictionType == 2) {
            String workflowDefinition = ParamUtil.getString((ServiceContext)serviceContext, (String)"workflowDefinition-1");
            workflowDefinitionOVPs.add(new ObjectValuePair((Object)-1L, (Object)workflowDefinition));
            Iterator<Object> i$ = originalDDMStructureIds.iterator();
            while (i$.hasNext()) {
                long originalDDMStructureId = (Long)i$.next();
                workflowDefinitionOVPs.add(new ObjectValuePair((Object)originalDDMStructureId, (Object)""));
            }
        }
        this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLinks(serviceContext.getUserId(), serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), JournalFolder.class.getName(), folderId, workflowDefinitionOVPs);
        return folder;
    }

    public void updateFolderDDMStructures(JournalFolder folder, long[] ddmStructureIdsArray) {
        Set<Long> originalDDMStructureIds;
        Set ddmStructureIds = SetUtil.fromArray((long[])ddmStructureIdsArray);
        if (ddmStructureIds.equals(originalDDMStructureIds = this.getDDMStructureIds(this.journalFolderPersistence.getDDMStructures(folder.getFolderId())))) {
            return;
        }
        for (Long ddmStructureId : ddmStructureIds) {
            if (originalDDMStructureIds.contains(ddmStructureId)) continue;
            this.journalFolderPersistence.addDDMStructure(folder.getFolderId(), ddmStructureId.longValue());
        }
        for (Long originalDDMStructureId : originalDDMStructureIds) {
            if (ddmStructureIds.contains(originalDDMStructureId)) continue;
            this.journalFolderPersistence.removeDDMStructure(folder.getFolderId(), originalDDMStructureId.longValue());
        }
    }

    public JournalFolder updateStatus(long userId, JournalFolder folder, int status) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        folder.setStatus(status);
        folder.setStatusByUserId(userId);
        folder.setStatusByUserName(user.getFullName());
        folder.setStatusDate(new Date());
        this.journalFolderPersistence.update((BaseModel)folder);
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
        indexer.reindex((Object)folder);
        return folder;
    }

    public void validateFolderDDMStructures(long folderId, long parentFolderId) throws PortalException {
        JournalFolder folder = this.journalFolderLocalService.fetchFolder(folderId);
        int restrictionType = 1;
        JournalFolder parentFolder = this.journalFolderLocalService.fetchFolder(parentFolderId);
        if (parentFolder != null) {
            restrictionType = parentFolder.getRestrictionType();
        }
        List folderDDMStructures = this.ddmStructureLocalService.getJournalFolderStructures(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)folder.getGroupId()), parentFolderId, restrictionType);
        long[] ddmStructureIds = new long[folderDDMStructures.size()];
        for (int i = 0; i < folderDDMStructures.size(); ++i) {
            DDMStructure folderDDMStructure = (DDMStructure)folderDDMStructures.get(i);
            ddmStructureIds[i] = folderDDMStructure.getStructureId();
        }
        this.validateArticleDDMStructures(folderId, ddmStructureIds);
    }

    protected void deleteWorkflowDefinitionLink(JournalFolder folder) {
        ArrayList<Long> ddmStructureIds = new ArrayList<Long>();
        for (DDMStructure ddmStructure : this.ddmStructureLocalService.getJournalFolderDDMStructures(folder.getFolderId())) {
            ddmStructureIds.add(ddmStructure.getStructureId());
        }
        if (ddmStructureIds.isEmpty()) {
            ddmStructureIds.add(-1L);
        }
        Iterator i$ = ddmStructureIds.iterator();
        while (i$.hasNext()) {
            long ddmStructureId = (Long)i$.next();
            WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(folder.getCompanyId(), folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), ddmStructureId);
            if (workflowDefinitionLink == null) continue;
            this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    protected JournalFolder doUpdateFolder(long userId, long folderId, long parentFolderId, String name, String description, long[] ddmStructureIds, int restrictionType, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException {
        if (restrictionType != 1) {
            ddmStructureIds = new long[]{};
        }
        this.validateArticleDDMStructures(folderId, ddmStructureIds);
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validateFolder(folderId, folder.getGroupId(), parentFolderId, name);
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setTreePath(folder.buildTreePath());
        folder.setName(name);
        folder.setDescription(description);
        folder.setRestrictionType(restrictionType);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.journalFolderPersistence.update((BaseModel)folder);
        this.updateAsset(userId, folder, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (ddmStructureIds != null) {
            this.updateFolderDDMStructures(folder, ddmStructureIds);
        }
        return folder;
    }

    protected Set<Long> getDDMStructureIds(List<DDMStructure> ddmStructures) {
        HashSet<Long> ddmStructureIds = new HashSet<Long>();
        for (DDMStructure ddmStructure : ddmStructures) {
            ddmStructureIds.add(ddmStructure.getStructureId());
        }
        return ddmStructureIds;
    }

    protected long getParentFolderId(JournalFolder folder, long parentFolderId) {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        JournalFolder parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) {
        JournalFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.journalFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(JournalFolder fromFolder, long toFolderId) throws PortalException {
        List folders = this.journalFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List articles = this.journalArticlePersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (JournalArticle article : articles) {
            article.setFolderId(toFolderId);
            this.journalArticlePersistence.update((BaseModel)article);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
        }
        this.journalFolderLocalService.deleteFolder(fromFolder);
    }

    protected void moveDependentsToTrash(List<Object> foldersAndArticles, long trashEntryId) throws PortalException {
        for (Object object : foldersAndArticles) {
            JournalFolder folder;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                if (article.getStatus() == 8) continue;
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    int curArticleOldStatus = curArticle.getStatus();
                    curArticle.setStatus(8);
                    this.journalArticlePersistence.update((BaseModel)curArticle);
                    int status = curArticleOldStatus;
                    if (curArticleOldStatus == 1) {
                        status = 2;
                    }
                    if (curArticleOldStatus != 0) {
                        this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalArticle.class.getName(), curArticle.getId(), status, null);
                    }
                    if (curArticleOldStatus != 1) continue;
                    this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(curArticle.getCompanyId(), curArticle.getGroupId(), JournalArticle.class.getName(), curArticle.getId());
                }
                this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder) || (folder = (JournalFolder)object).isInTrashExplicitly()) continue;
            int oldStatus = folder.getStatus();
            folder.setStatus(8);
            this.journalFolderPersistence.update((BaseModel)folder);
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, JournalFolder.class.getName(), folder.getFolderId(), oldStatus, null);
            }
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId());
            this.moveDependentsToTrash(curFoldersAndArticles, trashEntryId);
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), false);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void restoreDependentsFromTrash(List<Object> foldersAndArticles) throws PortalException {
        for (Object object : foldersAndArticles) {
            JournalFolder folder;
            Indexer indexer;
            int oldStatus;
            TrashVersion trashVersion;
            if (object instanceof JournalArticle) {
                JournalArticle article = (JournalArticle)object;
                if (!article.isInTrashImplicitly()) continue;
                trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getId());
                oldStatus = 0;
                if (trashVersion != null) {
                    oldStatus = trashVersion.getStatus();
                }
                List articles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
                for (JournalArticle curArticle : articles) {
                    trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), curArticle.getId());
                    int curArticleOldStatus = 0;
                    if (trashVersion != null) {
                        curArticleOldStatus = trashVersion.getStatus();
                    }
                    curArticle.setStatus(curArticleOldStatus);
                    this.journalArticlePersistence.update((BaseModel)curArticle);
                    if (trashVersion == null) continue;
                    this.trashVersionLocalService.deleteTrashVersion(trashVersion);
                }
                if (oldStatus == 0) {
                    this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), true);
                }
                indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
                indexer.reindex((Object)article);
                continue;
            }
            if (!(object instanceof JournalFolder) || !(folder = (JournalFolder)object).isInTrashImplicitly()) continue;
            trashVersion = this.trashVersionLocalService.fetchVersion(JournalFolder.class.getName(), folder.getFolderId());
            oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            folder.setStatus(oldStatus);
            this.journalFolderPersistence.update((BaseModel)folder);
            List<Object> curFoldersAndArticles = this.getFoldersAndArticles(folder.getGroupId(), folder.getFolderId(), 8);
            this.restoreDependentsFromTrash(curFoldersAndArticles);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.assetEntryLocalService.updateVisible(JournalFolder.class.getName(), folder.getFolderId(), true);
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalFolder.class);
            indexer.reindex((Object)folder);
        }
    }

    protected void validateArticleDDMStructures(long folderId, long[] ddmStructureIds) throws PortalException {
        List folders;
        if (ArrayUtil.isEmpty((long[])ddmStructureIds)) {
            return;
        }
        JournalFolder folder = this.journalFolderPersistence.findByPrimaryKey(folderId);
        List articles = this.journalArticleLocalService.getArticles(folder.getGroupId(), folderId);
        if (!articles.isEmpty()) {
            long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
            for (JournalArticle article : articles) {
                DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(article.getGroupId(), classNameId, article.getStructureId(), true);
                if (ddmStructure == null) {
                    throw new InvalidDDMStructureException();
                }
                if (ArrayUtil.contains((long[])ddmStructureIds, (long)ddmStructure.getStructureId())) continue;
                throw new InvalidDDMStructureException();
            }
        }
        if ((folders = this.journalFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId())).isEmpty()) {
            return;
        }
        for (JournalFolder curFolder : folders) {
            this.validateArticleDDMStructures(curFolder.getFolderId(), ddmStructureIds);
        }
    }

    protected void validateFolder(long folderId, long groupId, long parentFolderId, String name) throws PortalException {
        this.validateFolderName(name);
        JournalFolder folder = this.journalFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (folder != null && folder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException(name);
        }
    }

    protected void validateFolderName(String name) throws PortalException {
        if (!AssetUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        if (name.contains("\\\\") || name.contains("//")) {
            throw new FolderNameException();
        }
    }
}

