/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.journal.DuplicateFeedIdException;
import com.liferay.portlet.journal.FeedContentFieldException;
import com.liferay.portlet.journal.FeedIdException;
import com.liferay.portlet.journal.FeedNameException;
import com.liferay.portlet.journal.FeedTargetLayoutFriendlyUrlException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFeed;
import com.liferay.portlet.journal.service.base.JournalFeedLocalServiceBaseImpl;
import com.liferay.util.RSSUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JournalFeedLocalServiceImpl
extends JournalFeedLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(JournalFeedLocalServiceImpl.class);

    public JournalFeed addFeed(long userId, long groupId, String feedId, boolean autoFeedId, String name, String description, String type, String structureId, String templateId, String rendererTemplateId, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedFormat, double feedVersion, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        feedId = StringUtil.toUpperCase((String)feedId.trim());
        Date now = new Date();
        this.validate(user.getCompanyId(), groupId, feedId, autoFeedId, name, structureId, targetLayoutFriendlyUrl, contentField);
        if (autoFeedId) {
            feedId = String.valueOf(this.counterLocalService.increment());
        }
        long id = this.counterLocalService.increment();
        JournalFeed feed = this.journalFeedPersistence.create(id);
        feed.setUuid(serviceContext.getUuid());
        feed.setGroupId(groupId);
        feed.setCompanyId(user.getCompanyId());
        feed.setUserId(user.getUserId());
        feed.setUserName(user.getFullName());
        feed.setCreateDate(serviceContext.getCreateDate(now));
        feed.setModifiedDate(serviceContext.getModifiedDate(now));
        feed.setFeedId(feedId);
        feed.setName(name);
        feed.setDescription(description);
        feed.setType(type);
        feed.setStructureId(structureId);
        feed.setTemplateId(templateId);
        feed.setRendererTemplateId(rendererTemplateId);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedFormat)) {
            feed.setFeedFormat(RSSUtil.FORMAT_DEFAULT);
            feed.setFeedVersion(RSSUtil.VERSION_DEFAULT);
        } else {
            feed.setFeedFormat(feedFormat);
            feed.setFeedVersion(feedVersion);
        }
        feed.setExpandoBridgeAttributes(serviceContext);
        this.journalFeedPersistence.update((BaseModel)feed);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addFeedResources(feed, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addFeedResources(feed, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return feed;
    }

    public void addFeedResources(JournalFeed feed, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(JournalFeed feed, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(feed.getCompanyId(), feed.getGroupId(), feed.getUserId(), JournalFeed.class.getName(), feed.getId(), groupPermissions, guestPermissions);
    }

    public void addFeedResources(long feedId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, addGroupPermissions, addGuestPermissions);
    }

    public void addFeedResources(long feedId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.addFeedResources(feed, groupPermissions, guestPermissions);
    }

    @SystemEvent(type=1)
    public void deleteFeed(JournalFeed feed) throws PortalException {
        this.journalFeedPersistence.remove((BaseModel)feed);
        this.resourceLocalService.deleteResource(feed.getCompanyId(), JournalFeed.class.getName(), 4, feed.getId());
        this.expandoValueLocalService.deleteValues(JournalFeed.class.getName(), feed.getId());
    }

    public void deleteFeed(long feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByPrimaryKey(feedId);
        this.journalFeedLocalService.deleteFeed(feed);
    }

    public void deleteFeed(long groupId, String feedId) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.journalFeedLocalService.deleteFeed(feed);
    }

    public JournalFeed fetchFeed(long groupId, String feedId) {
        return this.journalFeedPersistence.fetchByG_F(groupId, feedId);
    }

    public JournalFeed getFeed(long feedId) throws PortalException {
        return this.journalFeedPersistence.findByPrimaryKey(feedId);
    }

    public JournalFeed getFeed(long groupId, String feedId) throws PortalException {
        return this.journalFeedPersistence.findByG_F(groupId, feedId);
    }

    public List<JournalFeed> getFeeds() {
        return this.journalFeedPersistence.findAll();
    }

    public List<JournalFeed> getFeeds(long groupId) {
        return this.journalFeedPersistence.findByGroupId(groupId);
    }

    public List<JournalFeed> getFeeds(long groupId, int start, int end) {
        return this.journalFeedPersistence.findByGroupId(groupId, start, end);
    }

    public int getFeedsCount(long groupId) {
        return this.journalFeedPersistence.countByGroupId(groupId);
    }

    public List<JournalFeed> search(long companyId, long groupId, String keywords, int start, int end, OrderByComparator<JournalFeed> obc) {
        return this.journalFeedFinder.findByKeywords(companyId, groupId, keywords, start, end, obc);
    }

    public List<JournalFeed> search(long companyId, long groupId, String feedId, String name, String description, boolean andOperator, int start, int end, OrderByComparator<JournalFeed> obc) {
        return this.journalFeedFinder.findByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator, start, end, obc);
    }

    public int searchCount(long companyId, long groupId, String keywords) {
        return this.journalFeedFinder.countByKeywords(companyId, groupId, keywords);
    }

    public int searchCount(long companyId, long groupId, String feedId, String name, String description, boolean andOperator) {
        return this.journalFeedFinder.countByC_G_F_N_D(companyId, groupId, feedId, name, description, andOperator);
    }

    public JournalFeed updateFeed(long groupId, String feedId, String name, String description, String type, String structureId, String templateId, String rendererTemplateId, int delta, String orderByCol, String orderByType, String targetLayoutFriendlyUrl, String targetPortletId, String contentField, String feedFormat, double feedVersion, ServiceContext serviceContext) throws PortalException {
        JournalFeed feed = this.journalFeedPersistence.findByG_F(groupId, feedId);
        this.validate(feed.getCompanyId(), groupId, name, structureId, targetLayoutFriendlyUrl, contentField);
        feed.setModifiedDate(serviceContext.getModifiedDate(null));
        feed.setName(name);
        feed.setDescription(description);
        feed.setType(type);
        feed.setStructureId(structureId);
        feed.setTemplateId(templateId);
        feed.setRendererTemplateId(rendererTemplateId);
        feed.setDelta(delta);
        feed.setOrderByCol(orderByCol);
        feed.setOrderByType(orderByType);
        feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        feed.setTargetPortletId(targetPortletId);
        feed.setContentField(contentField);
        if (Validator.isNull((String)feedFormat)) {
            feed.setFeedFormat(RSSUtil.FORMAT_DEFAULT);
            feed.setFeedVersion(RSSUtil.VERSION_DEFAULT);
        } else {
            feed.setFeedFormat(feedFormat);
            feed.setFeedVersion(feedVersion);
        }
        feed.setExpandoBridgeAttributes(serviceContext);
        this.journalFeedPersistence.update((BaseModel)feed);
        return feed;
    }

    protected boolean isValidStructureField(long groupId, String structureId, String contentField) {
        if (contentField.equals("web-content-description") || contentField.equals("rendered-web-content")) {
            return true;
        }
        try {
            DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(groupId, this.classNameLocalService.getClassNameId(JournalArticle.class), structureId);
            DDMForm ddmForm = ddmStructure.getDDMForm();
            Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
            return ddmFormFieldsMap.containsKey(contentField);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    protected void validate(long companyId, long groupId, String feedId, boolean autoFeedId, String name, String structureId, String targetLayoutFriendlyUrl, String contentField) throws PortalException {
        if (!autoFeedId) {
            if (Validator.isNull((String)feedId) || Validator.isNumber((String)feedId) || feedId.indexOf(44) != -1 || feedId.indexOf(32) != -1) {
                throw new FeedIdException();
            }
            JournalFeed feed = this.journalFeedPersistence.fetchByG_F(groupId, feedId);
            if (feed != null) {
                StringBundler sb = new StringBundler(5);
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", feedId=");
                sb.append(feedId);
                sb.append("}");
                throw new DuplicateFeedIdException(sb.toString());
            }
        }
        this.validate(companyId, groupId, name, structureId, targetLayoutFriendlyUrl, contentField);
    }

    protected void validate(long companyId, long groupId, String name, String structureId, String targetLayoutFriendlyUrl, String contentField) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new FeedNameException();
        }
        long plid = PortalUtil.getPlidFromFriendlyURL((long)companyId, (String)targetLayoutFriendlyUrl);
        if (plid <= 0L) {
            throw new FeedTargetLayoutFriendlyUrlException();
        }
        if (!this.isValidStructureField(groupId, structureId, contentField)) {
            throw new FeedContentFieldException();
        }
    }
}

