/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.diff.DiffHtmlUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portal.webserver.WebServerServletTokenUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetLink;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldNameException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import com.liferay.portlet.dynamicdatamapping.StructureDefinitionException;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleReviewDateException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.InvalidDDMStructureException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleConstants;
import com.liferay.portlet.journal.model.JournalArticleDisplay;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.model.impl.JournalArticleDisplayImpl;
import com.liferay.portlet.journal.service.base.JournalArticleLocalServiceBaseImpl;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.ArticleIDComparator;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

public class JournalArticleLocalServiceImpl
extends JournalArticleLocalServiceBaseImpl {
    private static final long _JOURNAL_ARTICLE_CHECK_INTERVAL = (long)PropsValues.JOURNAL_ARTICLE_CHECK_INTERVAL * 60000L;
    private static Log _log = LogFactoryUtil.getLog(JournalArticleLocalServiceImpl.class);
    private Date _previousCheckDate;

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle addArticle(long userId, long groupId, long folderId, long classNameId, long classPK, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (classNameId == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), ArticleDisplayDateException.class);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Date now = new Date();
        this.validateDDMStructureId(groupId, folderId, ddmStructureKey);
        this.validate(user.getCompanyId(), groupId, classNameId, articleId, autoArticleId, version, titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        if (autoArticleId) {
            articleId = String.valueOf(this.counterLocalService.increment());
        }
        serviceContext.setAttribute("articleId", (Serializable)((Object)articleId));
        long id = this.counterLocalService.increment();
        String articleResourceUuid = GetterUtil.getString((Object)serviceContext.getAttribute("articleResourceUuid"));
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(articleResourceUuid, groupId, articleId);
        JournalArticle article = this.journalArticlePersistence.create(id);
        Locale locale = this.getArticleDefaultLocale(content, serviceContext);
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, version, false, content, ddmStructureKey, images);
        article.setUuid(serviceContext.getUuid());
        article.setResourcePrimKey(resourcePrimKey);
        article.setGroupId(groupId);
        article.setCompanyId(user.getCompanyId());
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setCreateDate(serviceContext.getCreateDate(now));
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setFolderId(folderId);
        article.setClassNameId(classNameId);
        article.setClassPK(classPK);
        article.setTreePath(article.buildTreePath());
        article.setArticleId(articleId);
        article.setVersion(version);
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(id, articleId, title, null, serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(ddmStructureKey);
        article.setTemplateId(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        article.setSmallImageId(this.counterLocalService.increment());
        article.setSmallImageURL(smallImageURL);
        if (expirationDate == null || expirationDate.after(now)) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setStatusByUserId(userId);
        article.setStatusDate(serviceContext.getModifiedDate(now));
        article.setExpandoBridgeAttributes(serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addArticleResources(article, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addArticleResources(article, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (this.classNameLocalService.getClassNameId(DDMStructure.class) == classNameId) {
            this.updateDDMStructurePredefinedValues(classPK, content, serviceContext);
        }
        if (PropsValues.JOURNAL_ARTICLE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, article.getUserName(), groupId, JournalArticle.class.getName(), resourcePrimKey, 1);
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
        serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
        this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
        if (classNameId == 0L) {
            this.startWorkflowInstance(userId, article, serviceContext);
        } else {
            this.updateStatus(userId, article, 0, null, serviceContext, new HashMap<String, Serializable>());
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
        int displayDateMonth = calendar.get(2);
        int displayDateDay = calendar.get(5);
        int displayDateYear = calendar.get(1);
        int displayDateHour = calendar.get(11);
        int displayDateMinute = calendar.get(12);
        return this.journalArticleLocalService.addArticle(userId, groupId, folderId, 0L, 0L, "", true, 1.0, titleMap, descriptionMap, content, "general", ddmStructureKey, ddmTemplateKey, null, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
    }

    public void addArticleResources(JournalArticle article, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(JournalArticle article, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(article.getCompanyId(), article.getGroupId(), article.getUserId(), JournalArticle.class.getName(), article.getResourcePrimKey(), groupPermissions, guestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, addGroupPermissions, addGuestPermissions);
    }

    public void addArticleResources(long groupId, String articleId, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        this.addArticleResources(article, groupPermissions, guestPermissions);
    }

    public JournalArticle checkArticleResourcePrimKey(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.getResourcePrimKey() > 0L) {
            return article;
        }
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, articleId);
        article.setResourcePrimKey(resourcePrimKey);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void checkArticles() throws PortalException {
        Date now = new Date();
        this.checkArticlesByExpirationDate(now);
        this.checkArticlesByReviewDate(now);
        this.checkArticlesByDisplayDate(now);
        this._previousCheckDate = now;
    }

    public void checkNewLine(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String content = GetterUtil.getString((String)article.getContent());
        if (content.contains("\\n")) {
            content = StringUtil.replace((String)content, (String[])new String[]{"\\n", "\\r"}, (String[])new String[]{"\n", "\r"});
            article.setContent(content);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    public void checkStructure(long groupId, String articleId, double version) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        this.checkStructure(article);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle copyArticle(long userId, long groupId, String oldArticleId, String newArticleId, boolean autoArticleId, double version) throws PortalException {
        Image image;
        User user = this.userPersistence.findByPrimaryKey(userId);
        oldArticleId = StringUtil.toUpperCase((String)oldArticleId.trim());
        newArticleId = StringUtil.toUpperCase((String)newArticleId.trim());
        Date now = new Date();
        JournalArticle oldArticle = this.journalArticlePersistence.findByG_A_V(groupId, oldArticleId, version);
        if (autoArticleId) {
            newArticleId = String.valueOf(this.counterLocalService.increment());
        } else {
            this.validate(newArticleId);
            if (this.journalArticlePersistence.countByG_A(groupId, newArticleId) > 0) {
                StringBundler sb = new StringBundler(5);
                sb.append("{groupId=");
                sb.append(groupId);
                sb.append(", articleId=");
                sb.append(newArticleId);
                sb.append("}");
                throw new DuplicateArticleIdException(sb.toString());
            }
        }
        long id = this.counterLocalService.increment();
        long resourcePrimKey = this.journalArticleResourceLocalService.getArticleResourcePrimKey(groupId, newArticleId);
        JournalArticle newArticle = this.journalArticlePersistence.create(id);
        newArticle.setResourcePrimKey(resourcePrimKey);
        newArticle.setGroupId(groupId);
        newArticle.setCompanyId(user.getCompanyId());
        newArticle.setUserId(user.getUserId());
        newArticle.setUserName(user.getFullName());
        newArticle.setCreateDate(now);
        newArticle.setModifiedDate(now);
        newArticle.setFolderId(oldArticle.getFolderId());
        newArticle.setTreePath(oldArticle.getTreePath());
        newArticle.setArticleId(newArticleId);
        newArticle.setVersion(1.0);
        newArticle.setTitle(oldArticle.getTitle());
        newArticle.setUrlTitle(this.getUniqueUrlTitle(id, groupId, newArticleId, oldArticle.getTitleCurrentValue()));
        newArticle.setDescription(oldArticle.getDescription());
        try {
            this.copyArticleImages(oldArticle, newArticle);
        }
        catch (Exception e) {
            newArticle.setContent(oldArticle.getContent());
        }
        newArticle.setType(oldArticle.getType());
        newArticle.setStructureId(oldArticle.getStructureId());
        newArticle.setTemplateId(oldArticle.getTemplateId());
        newArticle.setLayoutUuid(oldArticle.getLayoutUuid());
        newArticle.setDisplayDate(oldArticle.getDisplayDate());
        newArticle.setExpirationDate(oldArticle.getExpirationDate());
        newArticle.setReviewDate(oldArticle.getReviewDate());
        newArticle.setIndexable(oldArticle.isIndexable());
        newArticle.setSmallImage(oldArticle.isSmallImage());
        newArticle.setSmallImageId(this.counterLocalService.increment());
        newArticle.setSmallImageURL(oldArticle.getSmallImageURL());
        if (oldArticle.isPending() || this.workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(user.getCompanyId(), groupId, JournalArticle.class.getName())) {
            newArticle.setStatus(2);
        } else {
            newArticle.setStatus(oldArticle.getStatus());
        }
        newArticle.setExpandoBridgeAttributes((BaseModel)oldArticle);
        this.journalArticlePersistence.update((BaseModel)newArticle);
        this.addArticleResources(newArticle, true, true);
        if (oldArticle.isSmallImage() && (image = this.imageLocalService.fetchImage(oldArticle.getSmallImageId())) != null) {
            byte[] smallImageBytes = image.getTextObj();
            this.imageLocalService.updateImage(newArticle.getSmallImageId(), smallImageBytes);
        }
        long[] assetCategoryIds = this.assetCategoryLocalService.getCategoryIds(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        String[] assetTagNames = this.assetTagLocalService.getTagNames(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        AssetEntry oldAssetEntry = this.assetEntryLocalService.getEntry(JournalArticle.class.getName(), oldArticle.getResourcePrimKey());
        List assetLinks = this.assetLinkLocalService.getDirectLinks(oldAssetEntry.getEntryId());
        long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
        this.updateAsset(userId, newArticle, assetCategoryIds, assetTagNames, assetLinkEntryIds);
        return newArticle;
    }

    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article) throws PortalException {
        return this.journalArticleLocalService.deleteArticle(article, "", null);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(action=1, send=false, type=1)
    public JournalArticle deleteArticle(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException {
        int articlesCount;
        TrashEntry trashEntry;
        PortletPreferences preferences;
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(article.getGroupId(), article.getArticleId());
        if (article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion(), 0)) {
            this.updatePreviousApprovedArticle(article);
        }
        if (serviceContext != null && Validator.isNotNull((String)articleURL) && (preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext)) != null && !article.isApproved() && this.isLatestVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
            this.sendEmail(article, articleURL, preferences, "denied", serviceContext);
        }
        String articleId = article.getArticleId();
        if (article.isInTrash()) {
            articleId = TrashUtil.getOriginalTitle((String)article.getArticleId());
        }
        this.journalArticleImageLocalService.deleteImages(article.getGroupId(), articleId, article.getVersion());
        this.expandoRowLocalService.deleteRows(article.getId());
        if (article.isInTrash() && (trashEntry = article.getTrashEntry()) != null) {
            this.trashVersionLocalService.deleteTrashVersion(JournalArticle.class.getName(), article.getId());
        }
        if (!article.isDraft()) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        if ((articlesCount = this.journalArticlePersistence.countByG_A(article.getGroupId(), article.getArticleId())) == 1) {
            this.ratingsStatsLocalService.deleteStats(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.mbMessageLocalService.deleteDiscussionMessages(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.journalContentSearchLocalService.deleteArticleContentSearches(article.getGroupId(), article.getArticleId());
            this.imageLocalService.deleteImage(article.getSmallImageId());
            this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            this.resourceLocalService.deleteResource(article.getCompanyId(), JournalArticle.class.getName(), 4, article.getResourcePrimKey());
            if (articleResource != null) {
                this.journalArticleResourceLocalService.deleteJournalArticleResource(articleResource);
            }
        }
        this.journalArticlePersistence.remove((BaseModel)article);
        if (articleResource != null) {
            JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
            extraDataJSONObject.put("uuid", article.getUuid());
            extraDataJSONObject.put("version", article.getVersion());
            this.systemEventLocalService.addSystemEvent(0L, article.getGroupId(), article.getModelClassName(), article.getPrimaryKey(), articleResource.getUuid(), null, 1, extraDataJSONObject.toString());
        }
        return article;
    }

    public JournalArticle deleteArticle(long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.deleteArticle(article, articleURL, serviceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticle(long groupId, String articleId, ServiceContext serviceContext) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.fetchArticleResource(groupId, articleId);
        try {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.deleteArticle(article, null, serviceContext);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        if (articleResource != null) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByGroupId(groupId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                this.journalArticleLocalService.deleteArticle(article, null, null);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteArticles(long groupId, long folderId) throws PortalException {
        this.deleteArticles(groupId, folderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArticles(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(JournalArticle.class);
        ArrayList<JournalArticleResource> articleResources = new ArrayList<JournalArticleResource>();
        try {
            JournalArticleResource articleResource = null;
            for (JournalArticle article : this.journalArticlePersistence.findByG_F(groupId, folderId)) {
                if (articleResource == null || articleResource.getPrimaryKey() != article.getResourcePrimKey()) {
                    articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
                    articleResources.add(articleResource);
                }
                if (includeTrashedEntries || !article.isInTrashExplicitly()) {
                    this.journalArticleLocalService.deleteArticle(article, null, null);
                    continue;
                }
                articleResources.remove(articleResource);
            }
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(JournalArticle.class);
        }
        for (JournalArticleResource articleResource : articleResources) {
            this.systemEventLocalService.addSystemEvent(0L, groupId, JournalArticle.class.getName(), articleResource.getResourcePrimKey(), articleResource.getUuid(), null, 1, "");
        }
    }

    public void deleteLayoutArticleReferences(long groupId, String layoutUuid) {
        List articles = this.journalArticlePersistence.findByG_L(groupId, layoutUuid);
        for (JournalArticle article : articles) {
            article.setLayoutUuid("");
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle expireArticle(long userId, long groupId, String articleId, double version, String articleURL, ServiceContext serviceContext) throws PortalException {
        return this.updateStatus(userId, groupId, articleId, version, 3, articleURL, new HashMap<String, Serializable>(), serviceContext);
    }

    public void expireArticle(long userId, long groupId, String articleId, String articleURL, ServiceContext serviceContext) throws PortalException {
        if (PropsValues.JOURNAL_ARTICLE_EXPIRE_ALL_VERSIONS) {
            List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
            for (JournalArticle article : articles) {
                this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
            }
        } else {
            JournalArticle article = this.getLatestArticle(groupId, articleId, 0);
            this.journalArticleLocalService.expireArticle(userId, groupId, article.getArticleId(), article.getVersion(), articleURL, serviceContext);
        }
    }

    public JournalArticle fetchArticle(long groupId, String articleId, double version) {
        return this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version);
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int status, boolean preferApproved) {
        JournalArticle article = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, 0, (OrderByComparator)orderByComparator);
            }
            if (article == null) {
                article = this.journalArticlePersistence.fetchByResourcePrimKey_First(resourcePrimKey, (OrderByComparator)orderByComparator);
            }
        } else {
            article = this.journalArticlePersistence.fetchByR_ST_First(resourcePrimKey, status, (OrderByComparator)orderByComparator);
        }
        return article;
    }

    public JournalArticle fetchLatestArticle(long resourcePrimKey, int[] statuses) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        List articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (!articles.isEmpty()) {
            return (JournalArticle)articles.get(0);
        }
        return null;
    }

    public JournalArticle fetchLatestArticle(long groupId, String articleId, int status) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            return this.journalArticlePersistence.fetchByG_A_NotST_First(groupId, articleId, 8, (OrderByComparator)orderByComparator);
        }
        return this.journalArticlePersistence.fetchByG_A_ST_First(groupId, articleId, status, (OrderByComparator)orderByComparator);
    }

    public JournalArticle fetchLatestIndexableArticle(long resourcePrimKey) {
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        int[] statuses = new int[]{0, 8};
        List articles = this.journalArticlePersistence.findByR_I_S(resourcePrimKey, true, statuses, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticle(long id) throws PortalException {
        return this.journalArticlePersistence.findByPrimaryKey(id);
    }

    public JournalArticle getArticle(long groupId, String articleId) throws PortalException {
        try {
            return this.getLatestArticle(groupId, articleId, 0);
        }
        catch (NoSuchArticleException nsae) {
            return this.getLatestArticle(groupId, articleId, -1);
        }
    }

    public JournalArticle getArticle(long groupId, String articleId, double version) throws PortalException {
        return this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
    }

    public JournalArticle getArticle(long groupId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK=" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        try {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 0);
        }
        catch (NoSuchArticleException nsae) {
            return this.getLatestArticleByUrlTitle(groupId, urlTitle, 1);
        }
    }

    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(article, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay == null) {
            return "";
        }
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, double version, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, version, viewMode, null, languageId, null, themeDisplay);
    }

    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticleDisplay articleDisplay = this.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        return articleDisplay.getContent();
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String ddmTemplateKey, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, viewMode, ddmTemplateKey, languageId, null, themeDisplay);
    }

    @Deprecated
    public String getArticleContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleContent(groupId, articleId, viewMode, null, languageId, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay, false);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        Date expirationDate;
        Date now = new Date();
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        if (article.isExpired() && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            return null;
        }
        Date displayDate = article.getDisplayDate();
        if (displayDate.after(now)) {
            return null;
        }
        return this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, version, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        JournalArticle article = this.getDisplayArticle(groupId, articleId);
        return this.getArticleDisplay(groupId, articleId, article.getVersion(), ddmTemplateKey, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) throws PortalException {
        return this.getArticleDisplay(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public List<JournalArticle> getArticles() {
        return this.journalArticlePersistence.findAll();
    }

    public List<JournalArticle> getArticles(long groupId) {
        return this.journalArticlePersistence.findByGroupId(groupId);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByGroupId(groupId, start, end, obc);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int status, int start, int end) {
        return this.journalArticlePersistence.findByG_F_ST(groupId, folderId, status, start, end);
    }

    public List<JournalArticle> getArticles(long groupId, long folderId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_F(groupId, folderId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId);
    }

    public List<JournalArticle> getArticles(long groupId, String articleId, int start, int end, OrderByComparator<JournalArticle> orderByComparator) {
        return this.journalArticlePersistence.findByG_A(groupId, articleId, start, end, orderByComparator);
    }

    public List<JournalArticle> getArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<JournalArticle> getArticlesBySmallImageId(long smallImageId) {
        return this.journalArticlePersistence.findBySmallImageId(smallImageId);
    }

    public int getArticlesCount(long groupId) {
        return this.journalArticlePersistence.countByGroupId(groupId);
    }

    public int getArticlesCount(long groupId, long folderId) {
        return this.journalArticlePersistence.countByG_F(groupId, folderId);
    }

    public int getArticlesCount(long groupId, long folderId, int status) {
        return this.journalArticlePersistence.countByG_F_ST(groupId, folderId, status);
    }

    public int getArticlesCount(long groupId, String articleId) {
        return this.journalArticlePersistence.countByG_A(groupId, articleId);
    }

    public List<JournalArticle> getCompanyArticles(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByC_V(companyId, version, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_V_ST(companyId, version, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public List<JournalArticle> getCompanyArticles(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.findByCompanyId(companyId, start, end, (OrderByComparator)new ArticleIDComparator(true));
        }
        return this.journalArticlePersistence.findByC_ST(companyId, status, start, end, (OrderByComparator)new ArticleIDComparator(true));
    }

    public int getCompanyArticlesCount(long companyId, double version, int status, int start, int end) {
        if (status == -1) {
            return this.journalArticlePersistence.countByC_V(companyId, version);
        }
        return this.journalArticlePersistence.countByC_V_ST(companyId, version, status);
    }

    public int getCompanyArticlesCount(long companyId, int status) {
        if (status == -1) {
            return this.journalArticlePersistence.countByCompanyId(companyId);
        }
        return this.journalArticlePersistence.countByC_ST(companyId, status);
    }

    public JournalArticle getDisplayArticle(long groupId, String articleId) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_A_ST(groupId, articleId, 0);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No approved JournalArticle exists with the key {groupId=" + groupId + ", " + "articleId=" + articleId + "}");
        }
        Date now = new Date();
        for (int i = 0; i < articles.size(); ++i) {
            JournalArticle article = (JournalArticle)articles.get(i);
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate != null && !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getDisplayArticleByUrlTitle(long groupId, String urlTitle) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, 0, -1, -1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + "}");
        }
        Date now = new Date();
        for (JournalArticle article : articles) {
            Date displayDate = article.getDisplayDate();
            Date expirationDate = article.getExpirationDate();
            if (displayDate == null || !displayDate.before(now) || expirationDate != null && !expirationDate.after(now)) continue;
            return article;
        }
        return (JournalArticle)articles.get(0);
    }

    public List<JournalArticle> getIndexableArticlesByResourcePrimKey(long resourcePrimKey) {
        return this.journalArticlePersistence.findByR_I(resourcePrimKey, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, -1);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status) throws PortalException {
        return this.getLatestArticle(resourcePrimKey, status, true);
    }

    public JournalArticle getLatestArticle(long resourcePrimKey, int status, boolean preferApproved) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        if (status == -1) {
            if (preferApproved) {
                articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, 0, 0, 1, (OrderByComparator)orderByComparator);
            }
            if (ListUtil.isEmpty(articles)) {
                articles = this.journalArticlePersistence.findByResourcePrimKey(resourcePrimKey, 0, 1, (OrderByComparator)orderByComparator);
            }
        } else {
            articles = this.journalArticlePersistence.findByR_ST(resourcePrimKey, status, 0, 1, (OrderByComparator)orderByComparator);
        }
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + resourcePrimKey + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId) throws PortalException {
        return this.getLatestArticle(groupId, articleId, -1);
    }

    public JournalArticle getLatestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator());
    }

    public JournalArticle getLatestArticle(long groupId, String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List articles = this.journalArticlePersistence.findByG_C_C(groupId, classNameId, classPK, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", className=" + className + ", classPK =" + classPK + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle getLatestArticleByUrlTitle(long groupId, String urlTitle, int status) throws PortalException {
        List articles = null;
        ArticleVersionComparator orderByComparator = new ArticleVersionComparator();
        articles = status == -1 ? this.journalArticlePersistence.findByG_UT(groupId, urlTitle, 0, 1, (OrderByComparator)orderByComparator) : this.journalArticlePersistence.findByG_UT_ST(groupId, urlTitle, status, 0, 1, (OrderByComparator)orderByComparator);
        if (articles.isEmpty()) {
            throw new NoSuchArticleException("No JournalArticle exists with the key {groupId=" + groupId + ", urlTitle=" + urlTitle + ", status=" + status + "}");
        }
        return (JournalArticle)articles.get(0);
    }

    public double getLatestVersion(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId);
        return article.getVersion();
    }

    public double getLatestVersion(long groupId, String articleId, int status) throws PortalException {
        JournalArticle article = this.getLatestArticle(groupId, articleId, status);
        return article.getVersion();
    }

    public int getNotInTrashArticlesCount(long groupId, long folderId) {
        QueryDefinition queryDefinition = new QueryDefinition(-1);
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId) throws PortalException {
        return this.getOldestArticle(groupId, articleId, -1);
    }

    public JournalArticle getOldestArticle(long groupId, String articleId, int status) throws PortalException {
        return this.getFirstArticle(groupId, articleId, status, (OrderByComparator<JournalArticle>)new ArticleVersionComparator(false));
    }

    public JournalArticle getPreviousApprovedArticle(JournalArticle article) {
        List approvedArticles = this.journalArticlePersistence.findByG_A_ST(article.getGroupId(), article.getArticleId(), 0, 0, 2);
        if (approvedArticles.isEmpty() || approvedArticles.size() == 1 && article.getStatus() == 0) {
            return article;
        }
        JournalArticle previousApprovedArticle = (JournalArticle)approvedArticles.get(0);
        if (article.getStatus() == 0) {
            previousApprovedArticle = (JournalArticle)approvedArticles.get(1);
        }
        return previousApprovedArticle;
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.findByG_S(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getStructureArticles(long groupId, String ddmStructureKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_S(groupId, ddmStructureKey, start, end, obc);
    }

    public List<JournalArticle> getStructureArticles(String[] ddmStructureKeys) {
        return this.journalArticlePersistence.findByStructureId(ddmStructureKeys);
    }

    public int getStructureArticlesCount(long groupId, String ddmStructureKey) {
        return this.journalArticlePersistence.countByG_S(groupId, ddmStructureKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.findByG_T(groupId, ddmTemplateKey);
    }

    public List<JournalArticle> getTemplateArticles(long groupId, String ddmTemplateKey, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticlePersistence.findByG_T(groupId, ddmTemplateKey, start, end, obc);
    }

    public int getTemplateArticlesCount(long groupId, String ddmTemplateKey) {
        return this.journalArticlePersistence.countByG_T(groupId, ddmTemplateKey);
    }

    public String getUniqueUrlTitle(long groupId, String articleId, String urlTitle) throws PortalException {
        int i = 1;
        while (true) {
            JournalArticle article = null;
            try {
                article = this.getArticleByUrlTitle(groupId, urlTitle);
            }
            catch (NoSuchArticleException nsae) {
                // empty catch block
            }
            if (article == null || articleId.equals(article.getArticleId())) break;
            String suffix = "-" + i;
            String prefix = urlTitle;
            if (urlTitle.length() > suffix.length()) {
                prefix = urlTitle.substring(0, urlTitle.length() - suffix.length());
            }
            urlTitle = prefix + suffix;
            ++i;
        }
        return urlTitle;
    }

    public boolean hasArticle(long groupId, String articleId) {
        try {
            this.getArticle(groupId, articleId);
            return true;
        }
        catch (PortalException pe) {
            return false;
        }
    }

    public boolean isLatestVersion(long groupId, String articleId, double version) throws PortalException {
        return this.getLatestVersion(groupId, articleId) == version;
    }

    public boolean isLatestVersion(long groupId, String articleId, double version, int status) throws PortalException {
        return this.getLatestVersion(groupId, articleId, status) == version;
    }

    public boolean isRenderable(JournalArticle article, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            this.getArticleDisplay(article, null, "view", article.getDefaultLanguageId(), 0, portletRequestModel, themeDisplay, true);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticle(long groupId, String articleId, long newFolderId) throws PortalException {
        JournalArticle latestArticle = this.getLatestArticle(groupId, articleId);
        this.validateDDMStructureId(groupId, newFolderId, latestArticle.getStructureId());
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            article.setFolderId(newFolderId);
            article.setTreePath(article.buildTreePath());
            this.journalArticlePersistence.update((BaseModel)article);
        }
        return this.getArticle(groupId, articleId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleFromTrash(long userId, long groupId, JournalArticle article, long newFolderId, ServiceContext serviceContext) throws PortalException {
        if (article.isInTrashExplicitly()) {
            this.restoreArticleFromTrash(userId, article);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(JournalArticle.class.getName(), article.getResourcePrimKey());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, article, status, null, serviceContext, new HashMap<String, Serializable>());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.moveArticle(groupId, article.getArticleId(), newFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle moveArticleToTrash(long userId, JournalArticle article) throws PortalException {
        int oldStatus = article.getStatus();
        if (oldStatus == 1) {
            article.setStatus(2);
            this.journalArticlePersistence.update((BaseModel)article);
        }
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        articleVersions = ListUtil.sort((List)articleVersions, (Comparator)new ArticleVersionComparator());
        List<Object> articleVersionStatusOVPs = new ArrayList();
        if (articleVersions != null && !articleVersions.isEmpty()) {
            articleVersionStatusOVPs = this.getArticleVersionStatuses(articleVersions);
        }
        article = this.updateStatus(userId, article.getId(), 8, new HashMap<String, Serializable>(), new ServiceContext());
        JournalArticleResource articleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
        UnicodeProperties typeSettingsProperties = new UnicodeProperties();
        typeSettingsProperties.put("title", article.getArticleId());
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), articleResource.getUuid(), null, oldStatus, articleVersionStatusOVPs, typeSettingsProperties);
        String trashArticleId = TrashUtil.getTrashTitle((long)trashEntry.getEntryId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            articleVersion.setStatus(8);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        article.setArticleId(trashArticleId);
        article = (JournalArticle)this.journalArticlePersistence.update((BaseModel)article);
        this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        this.socialActivityLocalService.addActivity(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 10007, extraDataJSONObject.toString(), 0L);
        if (oldStatus == 1) {
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(article.getCompanyId(), article.getGroupId(), JournalArticle.class.getName(), article.getId());
        }
        return article;
    }

    public JournalArticle moveArticleToTrash(long userId, long groupId, String articleId) throws PortalException {
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId, 0, 1, (OrderByComparator)new ArticleVersionComparator());
        if (!articles.isEmpty()) {
            return this.journalArticleLocalService.moveArticleToTrash(userId, (JournalArticle)articles.get(0));
        }
        return null;
    }

    public void rebuildTree(long companyId) throws PortalException {
        this.journalFolderLocalService.rebuildTree(companyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle removeArticleLocale(long groupId, String articleId, double version, String languageId) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        String title = article.getTitle();
        title = LocalizationUtil.removeLocalization((String)title, (String)"static-content", (String)languageId, (boolean)true);
        article.setTitle(title);
        String description = article.getDescription();
        description = LocalizationUtil.removeLocalization((String)description, (String)"static-content", (String)languageId, (boolean)true);
        article.setDescription(description);
        String content = article.getContent();
        Document document = article.getDocument();
        if (document != null) {
            content = JournalUtil.removeArticleLocale(document, content, languageId);
            article.setContent(content);
        }
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle restoreArticleFromTrash(long userId, JournalArticle article) throws PortalException {
        String trashArticleId = TrashUtil.getOriginalTitle((String)article.getArticleId());
        List articleVersions = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId());
        for (JournalArticle articleVersion : articleVersions) {
            articleVersion.setArticleId(trashArticleId);
            this.journalArticlePersistence.update((BaseModel)articleVersion);
        }
        article.setArticleId(trashArticleId);
        this.journalArticlePersistence.update((BaseModel)article);
        JournalArticleResource articleResource = this.journalArticleResourcePersistence.fetchByPrimaryKey(article.getResourcePrimKey());
        articleResource.setArticleId(trashArticleId);
        this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(article.getGroupId());
        this.updateStatus(userId, article, trashEntry.getStatus(), null, serviceContext, new HashMap<String, Serializable>());
        List trashVersions = this.trashVersionLocalService.getVersions(trashEntry.getEntryId());
        for (TrashVersion trashVersion : trashVersions) {
            JournalArticle trashArticleVersion = this.journalArticlePersistence.findByPrimaryKey(trashVersion.getClassPK());
            trashArticleVersion.setStatus(trashVersion.getStatus());
            this.journalArticlePersistence.update((BaseModel)trashArticleVersion);
        }
        this.trashEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", article.getTitle());
        this.socialActivityLocalService.addActivity(userId, article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 10008, extraDataJSONObject.toString(), 0L);
        return article;
    }

    public List<JournalArticle> search(long groupId, List<Long> folderIds, int status, int start, int end) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, null);
        return this.journalArticleFinder.findByG_F(groupId, folderIds, queryDefinition);
    }

    public List<JournalArticle> search(long groupId, long folderId, int status, int start, int end) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.search(groupId, folderIds, status, start, end);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, int start, int end, OrderByComparator<JournalArticle> obc) {
        return this.journalArticleFinder.findByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, start, end, obc);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public List<JournalArticle> search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator, int start, int end, OrderByComparator<JournalArticle> obc) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, obc);
        return this.journalArticleFinder.findByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, queryDefinition);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, null, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, type, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
            return indexer.search(searchContext);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    @Deprecated
    public Hits search(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, String statusString, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        int status = GetterUtil.getInteger((String)statusString);
        return this.search(companyId, groupId, folderIds, classNameId, articleId, title, description, content, type, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return indexer.search(searchContext);
    }

    public int searchCount(long groupId, List<Long> folderIds, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.journalArticleFinder.countByG_F(groupId, folderIds, queryDefinition);
    }

    public int searchCount(long groupId, long folderId, int status) {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        folderIds.add(folderId);
        return this.searchCount(groupId, folderIds, status);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String keywords, Double version, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate) {
        return this.journalArticleFinder.countByKeywords(companyId, groupId, folderIds, classNameId, keywords, version, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public int searchCount(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, Double version, String title, String description, String content, String type, String[] ddmStructureKeys, String[] ddmTemplateKeys, Date displayDateGT, Date displayDateLT, int status, Date reviewDate, boolean andOperator) {
        return this.journalArticleFinder.countByC_G_F_C_A_V_T_D_C_T_S_T_D_R(companyId, groupId, folderIds, classNameId, articleId, version, title, description, content, type, ddmStructureKeys, ddmTemplateKeys, displayDateGT, displayDateLT, reviewDate, andOperator, new QueryDefinition(status));
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.searchJournalArticles(companyId, groupId, folderIds, classNameId, articleId, title, description, content, null, -1, ddmStructureKey, ddmTemplateKey, params, andOperator, start, end, sort);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, folderIds, classNameId, articleId, title, description, content, type, status, ddmStructureKey, ddmTemplateKey, params, andSearch, start, end, sort);
        return this.searchJournalArticles(searchContext);
    }

    public BaseModelSearchResult<JournalArticle> searchJournalArticles(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(groupId, userId, creatorUserId, status, start, end);
        return this.searchJournalArticles(searchContext);
    }

    public void setTreePaths(final long folderId, final String treePath, final boolean reindex) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
                dynamicQuery.add(treePathProperty.ne((Object)treePath));
            }
        });
        final Indexer indexer = IndexerRegistryUtil.getIndexer((String)JournalArticle.class.getName());
        actionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod(){

            public void performAction(Object object) throws PortalException {
                JournalArticle article = (JournalArticle)object;
                article.setTreePath(treePath);
                JournalArticleLocalServiceImpl.this.updateJournalArticle(article);
                if (!reindex) {
                    return;
                }
                indexer.reindex((Object)article);
            }
        });
        actionableDynamicQuery.performActions();
    }

    public void subscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this.subscriptionLocalService.addSubscription(userId, groupId, DDMStructure.class.getName(), ddmStructureId);
    }

    public void unsubscribeStructure(long groupId, long userId, long ddmStructureId) throws PortalException {
        this.subscriptionLocalService.deleteSubscription(userId, DDMStructure.class.getName(), ddmStructureId);
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, titleMap, descriptionMap, content, article.getType(), article.getStructureId(), article.getTemplateId(), layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.getIndexable(), article.isSmallImage(), article.getSmallImageURL(), null, null, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, String layoutUuid, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, int reviewDateMonth, int reviewDateDay, int reviewDateYear, int reviewDateHour, int reviewDateMinute, boolean neverReview, boolean indexable, boolean smallImage, String smallImageURL, File smallImageFile, Map<String, byte[]> images, String articleURL, ServiceContext serviceContext) throws PortalException {
        JournalArticle latestArticle;
        User user = this.userPersistence.findByPrimaryKey(userId);
        articleId = StringUtil.toUpperCase((String)articleId.trim());
        byte[] smallImageBytes = null;
        try {
            smallImageBytes = FileUtil.getBytes((File)smallImageFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        JournalArticle article = latestArticle = this.getLatestArticle(groupId, articleId, -1);
        boolean imported = ExportImportThreadLocal.isImportInProcess();
        double latestVersion = latestArticle.getVersion();
        boolean addNewVersion = false;
        if (imported) {
            article = this.getArticle(groupId, articleId, version);
        } else {
            if (version > 0.0 && version != latestVersion) {
                throw new ArticleVersionException();
            }
            serviceContext.validateModifiedDate((AuditedModel)latestArticle, ArticleVersionException.class);
            if (latestArticle.isApproved() || latestArticle.isExpired() || latestArticle.isScheduled()) {
                addNewVersion = true;
                version = MathUtil.format((double)(latestVersion + 0.1), (int)1, (int)1);
            }
        }
        Date displayDate = null;
        Date expirationDate = null;
        Date reviewDate = null;
        if (article.getClassNameId() == 0L) {
            displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), ArticleDisplayDateException.class);
            if (!neverExpire) {
                expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), ArticleExpirationDateException.class);
            }
            if (!neverReview) {
                reviewDate = PortalUtil.getDate((int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (TimeZone)user.getTimeZone(), ArticleReviewDateException.class);
            }
        }
        Date now = new Date();
        boolean expired = false;
        if (expirationDate != null && expirationDate.before(now)) {
            expired = true;
        }
        this.validate(user.getCompanyId(), groupId, latestArticle.getClassNameId(), titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
        if (addNewVersion) {
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(latestArticle.getResourcePrimKey());
            article.setGroupId(latestArticle.getGroupId());
            article.setCompanyId(latestArticle.getCompanyId());
            article.setCreateDate(latestArticle.getCreateDate());
            article.setClassNameId(latestArticle.getClassNameId());
            article.setClassPK(latestArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(version);
            article.setSmallImageId(latestArticle.getSmallImageId());
        }
        Locale locale = this.getArticleDefaultLocale(content, serviceContext);
        String title = titleMap.get(locale);
        content = this.format(user, groupId, articleId, article.getVersion(), addNewVersion, content, ddmStructureKey, images);
        article.setUserId(user.getUserId());
        article.setUserName(user.getFullName());
        article.setModifiedDate(serviceContext.getModifiedDate(now));
        article.setFolderId(folderId);
        article.setTreePath(article.buildTreePath());
        article.setTitleMap(titleMap, locale);
        article.setUrlTitle(this.getUniqueUrlTitle(article.getId(), article.getArticleId(), title, latestArticle.getUrlTitle(), serviceContext));
        article.setDescriptionMap(descriptionMap, locale);
        article.setContent(content);
        article.setType(type);
        article.setStructureId(ddmStructureKey);
        article.setTemplateId(ddmTemplateKey);
        article.setLayoutUuid(layoutUuid);
        article.setDisplayDate(displayDate);
        article.setExpirationDate(expirationDate);
        article.setReviewDate(reviewDate);
        article.setIndexable(indexable);
        article.setSmallImage(smallImage);
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
        } else {
            article.setSmallImageId(0L);
        }
        article.setSmallImageURL(smallImageURL);
        if (latestArticle.isPending()) {
            article.setStatus(latestArticle.getStatus());
        } else if (!expired) {
            article.setStatus(2);
        } else {
            article.setStatus(3);
        }
        article.setExpandoBridgeAttributes(serviceContext);
        this.journalArticlePersistence.update((BaseModel)article);
        this.updateAsset(userId, article, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        if (this.classNameLocalService.getClassNameId(DDMStructure.class) == article.getClassNameId()) {
            this.updateDDMStructurePredefinedValues(article.getClassPK(), content, serviceContext);
        }
        this.saveImages(smallImage, article.getSmallImageId(), smallImageFile, smallImageBytes);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (expired && imported) {
            this.updateStatus(userId, article, article.getStatus(), articleURL, serviceContext, new HashMap<String, Serializable>());
        }
        if (serviceContext.getWorkflowAction() == 1) {
            articleURL = this.buildArticleURL(articleURL, groupId, folderId, articleId);
            serviceContext.setAttribute("articleURL", (Serializable)((Object)articleURL));
            this.sendEmail(article, articleURL, preferences, "requested", serviceContext);
            this.startWorkflowInstance(userId, article, serviceContext);
        }
        return this.journalArticlePersistence.findByPrimaryKey(article.getId());
    }

    public JournalArticle updateArticle(long userId, long groupId, long folderId, String articleId, double version, String content, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateArticle(userId, groupId, folderId, articleId, version, article.getTitleMap(), article.getDescriptionMap(), content, article.getLayoutUuid(), serviceContext);
    }

    @Deprecated
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images) throws PortalException {
        return this.journalArticleLocalService.updateArticleTranslation(groupId, articleId, version, locale, title, description, content, images, null);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateArticleTranslation(long groupId, String articleId, double version, Locale locale, String title, String description, String content, Map<String, byte[]> images, ServiceContext serviceContext) throws PortalException {
        this.validateContent(content);
        JournalArticle oldArticle = this.getLatestArticle(groupId, articleId, -1);
        double oldVersion = oldArticle.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new ArticleVersionException();
        }
        boolean incrementVersion = false;
        if (oldArticle.isApproved() || oldArticle.isExpired()) {
            incrementVersion = true;
        }
        if (serviceContext != null) {
            serviceContext.validateModifiedDate((AuditedModel)oldArticle, ArticleVersionException.class);
        }
        JournalArticle article = null;
        User user = this.userPersistence.findByPrimaryKey(oldArticle.getUserId());
        Locale defaultLocale = this.getArticleDefaultLocale(content, serviceContext);
        if (incrementVersion) {
            double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
            long id = this.counterLocalService.increment();
            article = this.journalArticlePersistence.create(id);
            article.setResourcePrimKey(oldArticle.getResourcePrimKey());
            article.setGroupId(oldArticle.getGroupId());
            article.setCompanyId(oldArticle.getCompanyId());
            article.setUserId(oldArticle.getUserId());
            article.setUserName(user.getFullName());
            article.setCreateDate(oldArticle.getCreateDate());
            article.setModifiedDate(new Date());
            article.setClassNameId(oldArticle.getClassNameId());
            article.setClassPK(oldArticle.getClassPK());
            article.setArticleId(articleId);
            article.setVersion(newVersion);
            article.setTitleMap(oldArticle.getTitleMap(), defaultLocale);
            article.setUrlTitle(this.getUniqueUrlTitle(id, articleId, title, oldArticle.getUrlTitle(), serviceContext));
            article.setDescriptionMap(oldArticle.getDescriptionMap());
            article.setType(oldArticle.getType());
            article.setStructureId(oldArticle.getStructureId());
            article.setTemplateId(oldArticle.getTemplateId());
            article.setLayoutUuid(oldArticle.getLayoutUuid());
            article.setDisplayDate(oldArticle.getDisplayDate());
            article.setExpirationDate(oldArticle.getExpirationDate());
            article.setReviewDate(oldArticle.getReviewDate());
            article.setIndexable(oldArticle.getIndexable());
            article.setSmallImage(oldArticle.getSmallImage());
            article.setSmallImageId(oldArticle.getSmallImageId());
            if (article.getSmallImageId() == 0L) {
                article.setSmallImageId(this.counterLocalService.increment());
            }
            article.setSmallImageURL(oldArticle.getSmallImageURL());
            article.setStatus(2);
            article.setStatusDate(new Date());
            article.setExpandoBridgeAttributes((BaseModel)oldArticle);
        } else {
            article = oldArticle;
        }
        Map titleMap = article.getTitleMap();
        titleMap.put(locale, title);
        article.setTitleMap(titleMap, defaultLocale);
        Map descriptionMap = article.getDescriptionMap();
        descriptionMap.put(locale, description);
        article.setDescriptionMap(descriptionMap);
        content = this.format(user, groupId, articleId, article.getVersion(), !oldArticle.isDraft(), content, oldArticle.getStructureId(), images);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    public void updateAsset(long userId, JournalArticle article, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        int approvedArticlesCount;
        boolean visible = article.isApproved();
        if (article.getClassNameId() != 0L) {
            visible = false;
        }
        boolean addDraftAssetEntry = false;
        if (!article.isApproved() && article.getVersion() != 1.0 && (approvedArticlesCount = this.journalArticlePersistence.countByG_A_ST(article.getGroupId(), article.getArticleId(), JournalArticleConstants.ASSET_ENTRY_CREATION_STATUSES)) > 0) {
            addDraftAssetEntry = true;
        }
        AssetEntry assetEntry = null;
        if (addDraftAssetEntry) {
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getPrimaryKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, false, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        } else {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(article.getResourcePrimKey());
            assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), journalArticleResource.getResourcePrimKey(), journalArticleResource.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, visible, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
        }
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateContent(long groupId, String articleId, double version, String content) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        article.setContent(content);
        this.journalArticlePersistence.update((BaseModel)article);
        return article;
    }

    @Indexable(type=IndexableType.REINDEX)
    public JournalArticle updateStatus(long userId, JournalArticle article, int status, String articleURL, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        if (status == 0 && article.getClassNameId() == 0L && article.getDisplayDate() != null && now.before(article.getDisplayDate())) {
            status = 7;
        }
        int oldStatus = article.getStatus();
        if (status == 0 && (expirationDate = article.getExpirationDate()) != null && expirationDate.before(now)) {
            article.setExpirationDate(null);
        }
        if (status == 3) {
            article.setExpirationDate(now);
        }
        article.setStatus(status);
        article.setStatusByUserId(user.getUserId());
        article.setStatusByUserName(user.getFullName());
        article.setStatusDate(serviceContext.getModifiedDate(now));
        this.journalArticlePersistence.update((BaseModel)article);
        if (this.hasModifiedLatestApprovedVersion(article.getGroupId(), article.getArticleId(), article.getVersion())) {
            if (status == 0) {
                AssetEntry draftAssetEntry;
                this.updateUrlTitles(article.getGroupId(), article.getArticleId(), article.getUrlTitle());
                if (oldStatus != 0 && article.getVersion() != 1.0 && (draftAssetEntry = this.assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getPrimaryKey())) != null) {
                    long[] assetCategoryIds = draftAssetEntry.getCategoryIds();
                    String[] assetTagNames = draftAssetEntry.getTagNames();
                    List assetLinks = this.assetLinkLocalService.getDirectLinks(draftAssetEntry.getEntryId(), 0);
                    long[] assetLinkEntryIds = ListUtil.toLongArray((List)assetLinks, (Accessor)AssetLink.ENTRY_ID2_ACCESSOR);
                    AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, article.getGroupId(), article.getCreateDate(), article.getModifiedDate(), JournalArticle.class.getName(), article.getResourcePrimKey(), article.getUuid(), this.getClassTypeId(article), assetCategoryIds, assetTagNames, false, null, null, null, "text/html", article.getTitle(), article.getDescription(), article.getDescription(), null, article.getLayoutUuid(), 0, 0, null, false);
                    this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
                    this.assetEntryLocalService.deleteEntry(JournalArticle.class.getName(), article.getPrimaryKey());
                }
                if (article.getClassNameId() == 0L) {
                    this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), article.getDisplayDate(), article.getExpirationDate(), true);
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("title", article.getTitle());
                if (serviceContext.isCommandUpdate()) {
                    this.socialActivityLocalService.addActivity(user.getUserId(), article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 2, extraDataJSONObject.toString(), 0L);
                } else {
                    this.socialActivityLocalService.addUniqueActivity(user.getUserId(), article.getGroupId(), JournalArticle.class.getName(), article.getResourcePrimKey(), 1, extraDataJSONObject.toString(), 0L);
                }
            } else if (oldStatus == 0) {
                this.updatePreviousApprovedArticle(article);
            }
        }
        if (article.getClassNameId() == 0L && oldStatus != 8 && status != 8) {
            if (oldStatus == 1 && (status == 0 || status == 4)) {
                String msg = "granted";
                if (status == 4) {
                    msg = "denied";
                }
                try {
                    PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
                    articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
                    this.sendEmail(article, articleURL, preferences, msg, serviceContext);
                }
                catch (Exception e) {
                    _log.error((Object)("Unable to send email to notify the change of status  to " + msg + " for article " + article.getId() + ": " + e.getMessage()));
                }
            }
            this.notifySubscribers(article, (String)((Object)workflowContext.get("url")), serviceContext);
        }
        return article;
    }

    public JournalArticle updateStatus(long userId, long classPK, int status, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.getArticle(classPK);
        return this.journalArticleLocalService.updateStatus(userId, article, status, null, serviceContext, workflowContext);
    }

    public JournalArticle updateStatus(long userId, long groupId, String articleId, double version, int status, String articleURL, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        JournalArticle article = this.journalArticlePersistence.findByG_A_V(groupId, articleId, version);
        return this.journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }

    public void updateTemplateId(long groupId, long classNameId, String oldDDMTemplateKey, String newDDMTemplateKey) {
        List articles = this.journalArticlePersistence.findByG_C_T(groupId, classNameId, oldDDMTemplateKey);
        for (JournalArticle article : articles) {
            article.setTemplateId(newDDMTemplateKey);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected String buildArticleURL(String articleURL, long groupId, long folderId, String articleId) {
        StringBundler sb = new StringBundler(13);
        sb.append(articleURL);
        sb.append("&");
        sb.append(PortalUtil.getPortletNamespace((String)"15"));
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("&");
        sb.append(PortalUtil.getPortletNamespace((String)"15"));
        sb.append("folderId=");
        sb.append(folderId);
        sb.append("&");
        sb.append(PortalUtil.getPortletNamespace((String)"15"));
        sb.append("articleId=");
        sb.append(articleId);
        return sb.toString();
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, List<Long> folderIds, long classNameId, String articleId, String title, String description, String content, String type, int status, String ddmStructureKey, String ddmTemplateKey, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("articleId", articleId);
        attributes.put("classNameId", classNameId);
        attributes.put("content", content);
        attributes.put("description", description);
        attributes.put("status", status);
        attributes.put("title", title);
        attributes.put("type", type);
        attributes.put("ddmStructureKey", ddmStructureKey);
        attributes.put("ddmTemplateKey", ddmTemplateKey);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions")));
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = new QueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setQueryConfig(queryConfig);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return searchContext;
    }

    protected void checkArticlesByDisplayDate(Date displayDate) throws PortalException {
        List articles = this.journalArticlePersistence.findByLtD_S(displayDate, 7);
        for (JournalArticle article : articles) {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            String layoutFullURL = PortalUtil.getLayoutFullURL((long)article.getGroupId(), (String)"15");
            serviceContext.setLayoutFullURL(layoutFullURL);
            serviceContext.setScopeGroupId(article.getGroupId());
            this.journalArticleLocalService.updateStatus(article.getUserId(), article, 0, null, serviceContext, new HashMap());
        }
    }

    protected void checkArticlesByExpirationDate(Date expirationDate) throws PortalException {
        List articles = this.journalArticleFinder.findByExpirationDate(0L, new Date(expirationDate.getTime() + _JOURNAL_ARTICLE_CHECK_INTERVAL), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + articles.size() + " articles"));
        }
        HashSet<Long> companyIds = new HashSet<Long>();
        for (JournalArticle article : articles) {
            if (PropsValues.JOURNAL_ARTICLE_EXPIRE_ALL_VERSIONS) {
                List currentArticles = this.journalArticlePersistence.findByG_A(article.getGroupId(), article.getArticleId(), -1, -1, (OrderByComparator)new ArticleVersionComparator(true));
                for (JournalArticle currentArticle : currentArticles) {
                    currentArticle.setExpirationDate(article.getExpirationDate());
                    currentArticle.setStatus(3);
                    this.journalArticlePersistence.update((BaseModel)currentArticle);
                }
            } else {
                article.setStatus(3);
                this.journalArticlePersistence.update((BaseModel)article);
            }
            this.updatePreviousApprovedArticle(article);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
            indexer.reindex((Object)article);
            JournalContentUtil.clearCache((long)article.getGroupId(), (String)article.getArticleId(), (String)article.getTemplateId());
            companyIds.add(article.getCompanyId());
        }
        Iterator i$ = companyIds.iterator();
        while (i$.hasNext()) {
            long companyId = (Long)i$.next();
            CacheUtil.clearCache(companyId);
        }
        if (this._previousCheckDate == null) {
            this._previousCheckDate = new Date(expirationDate.getTime() - _JOURNAL_ARTICLE_CHECK_INTERVAL);
        }
    }

    protected void checkArticlesByReviewDate(Date reviewDate) throws PortalException {
        List articles = this.journalArticleFinder.findByReviewDate(0L, reviewDate, this._previousCheckDate);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending review notifications for " + articles.size() + " articles"));
        }
        for (JournalArticle article : articles) {
            String articleURL = "";
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            PortletPreferences preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId);
            this.sendEmail(article, articleURL, preferences, "review", new ServiceContext());
        }
    }

    protected void checkStructure(Document contentDocument, DDMForm ddmForm) throws PortalException {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            if (this.isPrivateDDMFormField(ddmFormField)) continue;
            this.checkStructureField(ddmFormField, contentDocument.getRootElement());
        }
    }

    protected void checkStructure(JournalArticle article) throws PortalException {
        block2: {
            DDMStructure ddmStructure = article.getDDMStructure();
            try {
                this.checkStructure(article, ddmStructure);
            }
            catch (StructureDefinitionException sde) {
                if (!_log.isWarnEnabled()) break block2;
                StringBundler sb = new StringBundler(8);
                sb.append("Article {groupId=");
                sb.append(article.getGroupId());
                sb.append(", articleId=");
                sb.append(article.getArticleId());
                sb.append(", version=");
                sb.append(article.getVersion());
                sb.append("} has content that does not match its structure: ");
                sb.append(sde.getMessage());
                _log.warn((Object)sb.toString());
            }
        }
    }

    protected void checkStructure(JournalArticle article, DDMStructure ddmStructure) throws PortalException {
        this.checkStructure(article.getDocument(), ddmStructure.getDDMForm());
    }

    protected void checkStructureField(DDMFormField ddmFormField, Element contentElement) throws PortalException {
        String contentElementType;
        String fieldName = ddmFormField.getName();
        boolean hasField = false;
        for (Element childElement : contentElement.elements()) {
            if (!fieldName.equals(childElement.attributeValue("name", ""))) continue;
            hasField = true;
            for (DDMFormField childDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                this.checkStructureField(childDDMFormField, childElement);
            }
        }
        if (!(hasField || (contentElementType = contentElement.attributeValue("type", "")).equals("list") || contentElementType.equals("multi-list"))) {
            throw new StructureDefinitionException(fieldName);
        }
    }

    protected void copyArticleImages(JournalArticle oldArticle, JournalArticle newArticle) throws Exception {
        Document contentDocument = oldArticle.getDocument();
        contentDocument = contentDocument.clone();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPathSelector.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            String instanceId = imageEl.attributeValue("instance-id");
            String name = imageEl.attributeValue("name");
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                long imageId = GetterUtil.getLong((String)dynamicContentEl.attributeValue("id"));
                String languageId = dynamicContentEl.attributeValue("language-id");
                Image oldImage = null;
                try {
                    oldImage = this.imageLocalService.getImage(imageId);
                }
                catch (NoSuchImageException nsie) {
                    continue;
                }
                imageId = this.journalArticleImageLocalService.getArticleImageId(newArticle.getGroupId(), newArticle.getArticleId(), newArticle.getVersion(), instanceId, name, languageId);
                this.imageLocalService.updateImage(imageId, oldImage.getTextObj());
                String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
                dynamicContentEl.setText(elContent);
                dynamicContentEl.addAttribute("id", String.valueOf(imageId));
            }
        }
        newArticle.setContent(contentDocument.formattedString());
    }

    protected Map<String, String> createFieldsValuesMap(Element parentElement) {
        HashMap<String, String> fieldsValuesMap = new HashMap<String, String>();
        List dynamicElementElements = parentElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String fieldName = dynamicElementElement.attributeValue("name", "");
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String value = dynamicContentElement.getText();
                fieldsValuesMap.put(fieldName, value);
            }
            fieldsValuesMap.putAll(this.createFieldsValuesMap(dynamicElementElement));
        }
        return fieldsValuesMap;
    }

    protected Map<String, String> createFieldsValuesMap(String content) {
        try {
            Document document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            return this.createFieldsValuesMap(rootElement);
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    protected void format(User user, long groupId, String articleId, double version, boolean incrementVersion, Element root, Map<String, byte[]> images) throws PortalException {
        for (Element element : root.elements()) {
            String elInstanceId = element.attributeValue("instance-id", "");
            String elType = element.attributeValue("type", "");
            if (elType.equals("image")) {
                String elName = element.attributeValue("name", "");
                String elIndex = element.attributeValue("index", "");
                String name = elName + "_" + elIndex;
                this.formatImage(groupId, articleId, version, incrementVersion, element, elInstanceId, name, images);
            } else if (elType.equals("text_area") || elType.equals("text") || elType.equals("text_box")) {
                List dynamicContentElements = element.elements("dynamic-content");
                for (Element dynamicContentElement : dynamicContentElements) {
                    String dynamicContent = dynamicContentElement.getText();
                    if (!Validator.isNotNull((String)dynamicContent)) continue;
                    String contentType = "text/plain";
                    if (elType.equals("text_area")) {
                        contentType = "text/html";
                    }
                    dynamicContent = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)user.getUserId(), (String)JournalArticle.class.getName(), (long)0L, (String)contentType, (String)dynamicContent);
                    dynamicContentElement.clearContent();
                    dynamicContentElement.addCDATA(dynamicContent);
                }
            }
            this.format(user, groupId, articleId, version, incrementVersion, element, images);
        }
    }

    protected String format(User user, long groupId, String articleId, double version, boolean incrementVersion, String content, String ddmStructureKey, Map<String, byte[]> images) throws PortalException {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)content);
            Element rootElement = document.getRootElement();
            this.format(user, groupId, articleId, version, incrementVersion, rootElement, images);
            content = DDMXMLUtil.formatXML((Document)document);
        }
        catch (DocumentException de) {
            _log.error((Object)de, (Throwable)de);
        }
        return content;
    }

    protected void formatImage(long groupId, String articleId, double version, boolean incrementVersion, Element el, String elInstanceId, String elName, Map<String, byte[]> images) throws PortalException {
        List imageContents = el.elements("dynamic-content");
        for (Element dynamicContent : imageContents) {
            long defaultImageId;
            Image defaultImage;
            String elLanguage = dynamicContent.attributeValue("language-id", "");
            if (!elLanguage.equals("")) {
                elLanguage = "_" + elLanguage;
            }
            long imageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, elLanguage);
            if (dynamicContent.getText().equals("delete") || Validator.isNull((String)dynamicContent.getText())) {
                dynamicContent.setText("");
                this.imageLocalService.deleteImage(imageId);
                String defaultElLanguage = "";
                if (Validator.isNull((String)elLanguage)) {
                    defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
                }
                long defaultImageId2 = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage);
                this.imageLocalService.deleteImage(defaultImageId2);
                continue;
            }
            String elContent = "/image/journal/article?img_id=" + imageId + "&t=" + WebServerServletTokenUtil.getToken((long)imageId);
            byte[] bytes = null;
            if (images != null) {
                bytes = images.get(elInstanceId + "_" + elName + elLanguage);
            }
            if (ArrayUtil.isNotEmpty(bytes)) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                this.imageLocalService.updateImage(imageId, bytes);
                continue;
            }
            if (version > 1.0 && incrementVersion) {
                double oldVersion = MathUtil.format((double)(version - 0.1), (int)1, (int)1);
                long oldImageId = 0L;
                if (oldVersion >= 1.0 && incrementVersion) {
                    oldImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, oldVersion, elInstanceId, elName, elLanguage);
                }
                Image oldImage = null;
                if (oldImageId > 0L) {
                    oldImage = this.imageLocalService.getImage(oldImageId);
                }
                if (oldImage != null) {
                    dynamicContent.setText(elContent);
                    dynamicContent.addAttribute("id", String.valueOf(imageId));
                    bytes = oldImage.getTextObj();
                    this.imageLocalService.updateImage(imageId, bytes);
                    continue;
                }
                if (!dynamicContent.getText().equals("update")) continue;
                dynamicContent.setText("");
                continue;
            }
            Image image = this.imageLocalService.getImage(imageId);
            if (image != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(imageId));
                continue;
            }
            if (dynamicContent.getText().equals("update")) {
                dynamicContent.setText("");
                continue;
            }
            long contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id"));
            if (contentImageId <= 0L) {
                contentImageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)dynamicContent.getText(), (String)"img_id", (boolean)false));
            }
            if (contentImageId > 0L && (image = this.imageLocalService.getImage(contentImageId)) != null) {
                dynamicContent.addAttribute("id", String.valueOf(contentImageId));
                continue;
            }
            String defaultElLanguage = "";
            if (Validator.isNull((String)elLanguage)) {
                defaultElLanguage = "_" + LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault());
            }
            if ((defaultImage = this.imageLocalService.getImage(defaultImageId = this.journalArticleImageLocalService.getArticleImageId(groupId, articleId, version, elInstanceId, elName, defaultElLanguage))) != null) {
                dynamicContent.setText(elContent);
                dynamicContent.addAttribute("id", String.valueOf(defaultImageId));
                bytes = defaultImage.getTextObj();
                this.imageLocalService.updateImage(defaultImageId, bytes);
                continue;
            }
            if (!Validator.isNotNull((String)elLanguage)) continue;
            dynamicContent.setText("");
        }
    }

    protected Locale getArticleDefaultLocale(String content, ServiceContext serviceContext) {
        String defaultLanguageId = ParamUtil.getString((ServiceContext)serviceContext, (String)"defaultLanguageId");
        if (Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)content);
        }
        if (Validator.isNotNull((String)defaultLanguageId)) {
            return LocaleUtil.fromLanguageId((String)defaultLanguageId);
        }
        return LocaleUtil.getSiteDefault();
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay, boolean propagateException) throws PortalException {
        String content = null;
        if (page < 1) {
            page = 1;
        }
        int numberOfPages = 1;
        boolean paginate = false;
        boolean pageFlow = false;
        boolean cacheable = true;
        Map<String, String> tokens = JournalUtil.getTokens(article.getGroupId(), portletRequestModel, themeDisplay);
        if (themeDisplay == null && portletRequestModel == null) {
            tokens.put("company_id", String.valueOf(article.getCompanyId()));
            Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
            tokens.put("article_group_id", String.valueOf(article.getGroupId()));
            tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
            tokens.put("group_id", String.valueOf(article.getGroupId()));
        }
        tokens.put("article_resource_pk", String.valueOf(article.getResourcePrimKey()));
        String defaultDDMTemplateKey = article.getTemplateId();
        if (Validator.isNull((String)ddmTemplateKey)) {
            ddmTemplateKey = defaultDDMTemplateKey;
        }
        tokens.put("structure_id", article.getStructureId());
        tokens.put("template_id", ddmTemplateKey);
        Document document = article.getDocument();
        document = document.clone();
        Element rootElement = document.getRootElement();
        List pages = rootElement.elements("page");
        if (!pages.isEmpty()) {
            String[] values;
            pageFlow = true;
            String targetPage = null;
            Map parameters = portletRequestModel.getParameters();
            if (parameters != null && (values = (String[])parameters.get("targetPage")) != null && values.length > 0) {
                targetPage = values[0];
            }
            Element pageElement = null;
            if (Validator.isNotNull(targetPage)) {
                targetPage = HtmlUtil.escapeXPathAttribute(targetPage);
                XPath xPathSelector = SAXReaderUtil.createXPath((String)("/root/page[@id = " + targetPage + "]"));
                pageElement = (Element)xPathSelector.selectSingleNode((Object)document);
            }
            if (pageElement != null) {
                document = SAXReaderUtil.createDocument(pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
            } else {
                if (page > pages.size()) {
                    page = 1;
                }
                pageElement = (Element)pages.get(page - 1);
                document = SAXReaderUtil.createDocument((Element)pageElement);
                rootElement = document.getRootElement();
                numberOfPages = pages.size();
                paginate = true;
            }
        }
        JournalUtil.addAllReservedEls(rootElement, tokens, article, languageId, themeDisplay);
        try {
            String[] pieces;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Transforming " + article.getArticleId() + " " + article.getVersion() + " " + languageId));
            }
            DDMTemplate ddmTemplate = null;
            try {
                ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
                Group companyGroup = this.groupLocalService.getCompanyGroup(article.getCompanyId());
                if (companyGroup.getGroupId() == ddmTemplate.getGroupId()) {
                    tokens.put("company_group_id", String.valueOf(companyGroup.getGroupId()));
                }
            }
            catch (NoSuchTemplateException nste) {
                if (!defaultDDMTemplateKey.equals(ddmTemplateKey)) {
                    ddmTemplate = this.ddmTemplatePersistence.findByG_C_T(PortalUtil.getSiteGroupId((long)article.getGroupId()), this.classNameLocalService.getClassNameId(DDMStructure.class), defaultDDMTemplateKey);
                }
                throw nste;
            }
            String script = ddmTemplate.getScript();
            String langType = ddmTemplate.getLanguage();
            cacheable = ddmTemplate.isCacheable();
            content = propagateException ? JournalUtil.doTransform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType) : JournalUtil.transform(themeDisplay, tokens, viewMode, languageId, document, portletRequestModel, script, langType);
            if (!pageFlow && (pieces = StringUtil.split((String)content, (String)PropsValues.JOURNAL_ARTICLE_TOKEN_PAGE_BREAK)).length > 1) {
                if (page > pieces.length) {
                    page = 1;
                }
                content = pieces[page - 1];
                numberOfPages = pieces.length;
                paginate = true;
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        return new JournalArticleDisplayImpl(article.getCompanyId(), article.getId(), article.getResourcePrimKey(), article.getGroupId(), article.getUserId(), article.getArticleId(), article.getVersion(), article.getTitle(languageId), article.getUrlTitle(), article.getDescription(languageId), article.getAvailableLanguageIds(), content, article.getType(), article.getStructureId(), ddmTemplateKey, article.isSmallImage(), article.getSmallImageId(), article.getSmallImageURL(), numberOfPages, page, paginate, cacheable);
    }

    protected List<ObjectValuePair<Long, Integer>> getArticleVersionStatuses(List<JournalArticle> articles) {
        ArrayList<ObjectValuePair<Long, Integer>> articleVersionStatusOVPs = new ArrayList<ObjectValuePair<Long, Integer>>(articles.size());
        for (JournalArticle article : articles) {
            int status = article.getStatus();
            if (status == 1) {
                status = 2;
            }
            ObjectValuePair articleVersionStatusOVP = new ObjectValuePair((Object)article.getId(), (Object)status);
            articleVersionStatusOVPs.add((ObjectValuePair<Long, Integer>)articleVersionStatusOVP);
        }
        return articleVersionStatusOVPs;
    }

    protected long getClassTypeId(JournalArticle article) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchStructure(article.getGroupId(), classNameId, article.getStructureId(), true);
        return ddmStructure.getStructureId();
    }

    protected JournalArticle getFirstArticle(long groupId, String articleId, int status, OrderByComparator<JournalArticle> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.journalArticlePersistence.findByG_A_NotST_First(groupId, articleId, 8, orderByComparator);
        }
        return this.journalArticlePersistence.findByG_A_ST_First(groupId, articleId, status, orderByComparator);
    }

    protected String getUniqueUrlTitle(long id, long groupId, String articleId, String title) throws PortalException {
        String urlTitle = JournalUtil.getUrlTitle(id, title);
        return this.getUniqueUrlTitle(groupId, articleId, urlTitle);
    }

    protected String getUniqueUrlTitle(long id, String articleId, String title, String oldUrlTitle, ServiceContext serviceContext) throws PortalException {
        String serviceContextUrlTitle = ParamUtil.getString((ServiceContext)serviceContext, (String)"urlTitle");
        String urlTitle = null;
        if (Validator.isNotNull((String)serviceContextUrlTitle)) {
            urlTitle = JournalUtil.getUrlTitle(id, serviceContextUrlTitle);
        } else {
            if (Validator.isNotNull((String)oldUrlTitle)) {
                return oldUrlTitle;
            }
            urlTitle = this.getUniqueUrlTitle(id, serviceContext.getScopeGroupId(), articleId, title);
        }
        JournalArticle urlTitleArticle = null;
        try {
            urlTitleArticle = this.getArticleByUrlTitle(serviceContext.getScopeGroupId(), urlTitle);
        }
        catch (NoSuchArticleException nsae) {
            // empty catch block
        }
        if (urlTitleArticle != null && !Validator.equals((Object)urlTitleArticle.getArticleId(), (Object)articleId)) {
            urlTitle = this.getUniqueUrlTitle(id, serviceContext.getScopeGroupId(), articleId, urlTitle);
        }
        return urlTitle;
    }

    protected boolean hasModifiedLatestApprovedVersion(long groupId, String articleId, double version) throws PortalException {
        try {
            double latestApprovedVersion = this.getLatestVersion(groupId, articleId, 0);
            return version >= latestApprovedVersion;
        }
        catch (NoSuchArticleException nsae) {
            return true;
        }
    }

    protected boolean isPrivateDDMFormField(DDMFormField ddmFormField) {
        String name = ddmFormField.getName();
        return name.startsWith("_");
    }

    protected void notifySubscribers(JournalArticle article, String articleURL, ServiceContext serviceContext) throws PortalException {
        if (!article.isApproved() || Validator.isNull((String)articleURL)) {
            return;
        }
        String articleTitle = article.getTitle(serviceContext.getLanguageId());
        articleURL = this.buildArticleURL(articleURL, article.getGroupId(), article.getFolderId(), article.getArticleId());
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = article.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "15";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(article.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(article.getVersion() == 1.0 && JournalUtil.getEmailArticleAddedEnabled(preferences) || article.getVersion() != 1.0 && JournalUtil.getEmailArticleUpdatedEnabled(preferences))) {
            return;
        }
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        Map<Locale, String> localizedSubjectMap = null;
        Map<Locale, String> localizedBodyMap = null;
        if (article.getVersion() == 1.0) {
            localizedSubjectMap = JournalUtil.getEmailArticleAddedSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleAddedBodyMap(preferences);
        } else {
            localizedSubjectMap = JournalUtil.getEmailArticleUpdatedSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleUpdatedBodyMap(preferences);
        }
        String articleContent = "";
        String articleDiffs = "";
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        try {
            PortletRequestModel portletRequestModel = new PortletRequestModel((PortletRequest)serviceContext.getLiferayPortletRequest(), (PortletResponse)serviceContext.getLiferayPortletResponse());
            JournalArticleDisplay articleDisplay = this.getArticleDisplay(article, null, "view", LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), 1, portletRequestModel, serviceContext.getThemeDisplay());
            articleContent = articleDisplay.getContent();
            articleDiffs = JournalUtil.diffHtml(article.getGroupId(), article.getArticleId(), previousApprovedArticle.getVersion(), article.getVersion(), LocaleUtil.toLanguageId((Locale)LocaleUtil.getSiteDefault()), portletRequestModel, serviceContext.getThemeDisplay());
        }
        catch (Exception e) {
            // empty catch block
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setClassName(article.getModelClassName());
        subscriptionSender.setClassPK(article.getId());
        subscriptionSender.setCompanyId(article.getCompanyId());
        subscriptionSender.setContextAttribute("[$ARTICLE_CONTENT$]", (Object)articleContent, false);
        subscriptionSender.setContextAttribute("[$ARTICLE_DIFFS$]", (Object)DiffHtmlUtil.replaceStyles((String)articleDiffs), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", articleTitle, "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setEntryTitle(articleTitle);
        subscriptionSender.setEntryURL(articleURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        subscriptionSender.setPortletId("15");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(article.getUserId());
        JournalFolder folder = article.getFolder();
        subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), article.getGroupId());
        if (folder != null) {
            subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), folder.getFolderId());
            for (Long ancestorFolderId : folder.getAncestorFolderIds()) {
                subscriptionSender.addPersistedSubscribers(JournalFolder.class.getName(), ancestorFolderId.longValue());
            }
        }
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(article.getGroupId(), this.classNameLocalService.getClassNameId(JournalArticle.class), article.getStructureId(), true);
        subscriptionSender.addPersistedSubscribers(DDMStructure.class.getName(), ddmStructure.getStructureId());
        subscriptionSender.addPersistedSubscribers(JournalArticle.class.getName(), article.getResourcePrimKey());
        subscriptionSender.flushNotificationsAsync();
    }

    protected void saveImages(boolean smallImage, long smallImageId, File smallImageFile, byte[] smallImageBytes) throws PortalException {
        if (smallImage) {
            if (smallImageFile != null && smallImageBytes != null) {
                this.imageLocalService.updateImage(smallImageId, smallImageBytes);
            }
        } else {
            this.imageLocalService.deleteImage(smallImageId);
        }
    }

    protected BaseModelSearchResult<JournalArticle> searchJournalArticles(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(JournalArticle.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, JournalUtil.SELECTED_FIELD_NAMES);
            List<JournalArticle> articles = JournalUtil.getArticles(hits);
            if (articles == null) continue;
            return new BaseModelSearchResult(articles, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void sendEmail(JournalArticle article, String articleURL, PortletPreferences preferences, String emailType, ServiceContext serviceContext) throws PortalException {
        if (preferences == null) {
            return;
        }
        if (!(emailType.equals("denied") && JournalUtil.getEmailArticleApprovalDeniedEnabled(preferences) || emailType.equals("granted") && JournalUtil.getEmailArticleApprovalGrantedEnabled(preferences) || emailType.equals("requested") && JournalUtil.getEmailArticleApprovalRequestedEnabled(preferences) || emailType.equals("review") && JournalUtil.getEmailArticleReviewEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(article.getCompanyId());
        User user = this.userPersistence.findByPrimaryKey(article.getUserId());
        String fromName = JournalUtil.getEmailFromName(preferences, article.getCompanyId());
        String fromAddress = JournalUtil.getEmailFromAddress(preferences, article.getCompanyId());
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (emailType.equals("requested")) {
            String tempToName = fromName;
            String tempToAddress = fromAddress;
            fromName = toName;
            fromAddress = toAddress;
            toName = tempToName;
            toAddress = tempToAddress;
        }
        Map<Locale, String> localizedSubjectMap = null;
        Map<Locale, String> localizedBodyMap = null;
        if (emailType.equals("denied")) {
            localizedSubjectMap = JournalUtil.getEmailArticleApprovalDeniedSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleApprovalDeniedBodyMap(preferences);
        } else if (emailType.equals("granted")) {
            localizedSubjectMap = JournalUtil.getEmailArticleApprovalGrantedSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleApprovalGrantedBodyMap(preferences);
        } else if (emailType.equals("requested")) {
            localizedSubjectMap = JournalUtil.getEmailArticleApprovalRequestedSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleApprovalRequestedBodyMap(preferences);
        } else if (emailType.equals("review")) {
            localizedSubjectMap = JournalUtil.getEmailArticleReviewSubjectMap(preferences);
            localizedBodyMap = JournalUtil.getEmailArticleReviewBodyMap(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(company.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$ARTICLE_ID$]", article.getArticleId(), "[$ARTICLE_TITLE$]", article.getTitle(serviceContext.getLanguageId()), "[$ARTICLE_URL$]", articleURL, "[$ARTICLE_USER_NAME$]", article.getUserName(), "[$ARTICLE_VERSION$]", article.getVersion()});
        subscriptionSender.setContextUserPrefix("ARTICLE");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("journal_article", new Object[]{article.getId()});
        subscriptionSender.setPortletId("15");
        subscriptionSender.setScopeGroupId(article.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(article.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void startWorkflowInstance(long userId, JournalArticle article, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", PortalUtil.getControlPanelFullURL((long)serviceContext.getScopeGroupId(), (String)"15", null));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)article.getCompanyId(), (long)article.getGroupId(), (long)userId, (String)JournalArticle.class.getName(), (long)article.getId(), (Object)article, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateDDMFormFieldPredefinedValue(DDMFormField ddmFormField, String ddmFormFieldValue) {
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        for (Locale locale : predefinedValue.getAvailableLocales()) {
            predefinedValue.addString(locale, ddmFormFieldValue);
        }
    }

    protected void updateDDMStructurePredefinedValues(long ddmStructureId, String content, ServiceContext serviceContext) {
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchDDMStructure(ddmStructureId);
        if (ddmStructure == null) {
            return;
        }
        DDMForm ddmForm = ddmStructure.getDDMForm();
        Map ddmFormFieldsMap = ddmStructure.getFullHierarchyDDMFormFieldsMap(true);
        Map<String, String> fieldsValuesMap = this.createFieldsValuesMap(content);
        for (Map.Entry<String, String> fieldValue : fieldsValuesMap.entrySet()) {
            String ddmFormFieldName = fieldValue.getKey();
            String ddmFormFieldValue = fieldValue.getValue();
            this.updateDDMFormFieldPredefinedValue((DDMFormField)ddmFormFieldsMap.get(ddmFormFieldName), ddmFormFieldValue);
        }
        ddmStructure.updateDDMForm(ddmForm);
        this.ddmStructureLocalService.updateDDMStructure(ddmStructure);
    }

    protected void updatePreviousApprovedArticle(JournalArticle article) throws PortalException {
        JournalArticle previousApprovedArticle = this.getPreviousApprovedArticle(article);
        if (previousApprovedArticle.getVersion() == article.getVersion()) {
            this.assetEntryLocalService.updateVisible(JournalArticle.class.getName(), article.getResourcePrimKey(), false);
        } else {
            AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(JournalArticle.class.getName(), article.getResourcePrimKey(), previousApprovedArticle.getDisplayDate(), previousApprovedArticle.getExpirationDate(), true);
            assetEntry.setModifiedDate(previousApprovedArticle.getModifiedDate());
            assetEntry.setTitle(previousApprovedArticle.getTitle());
            this.assetEntryPersistence.update((BaseModel)assetEntry);
        }
    }

    protected void updateUrlTitles(long groupId, String articleId, String urlTitle) throws PortalException {
        JournalArticle firstArticle = this.journalArticlePersistence.findByG_A_First(groupId, articleId, (OrderByComparator)new ArticleVersionComparator(false));
        if (firstArticle.getUrlTitle().equals(urlTitle)) {
            return;
        }
        List articles = this.journalArticlePersistence.findByG_A(groupId, articleId);
        for (JournalArticle article : articles) {
            if (article.getUrlTitle().equals(urlTitle)) continue;
            article.setUrlTitle(urlTitle);
            this.journalArticlePersistence.update((BaseModel)article);
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, Map<Locale, String> titleMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        long smallImageMaxSize;
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        Object[] availableLocales = LanguageUtil.getAvailableLocales((long)groupId);
        if (!ArrayUtil.contains((Object[])availableLocales, (Object)articleDefaultLocale)) {
            LocaleException le = new LocaleException(3, "The locale " + articleDefaultLocale + " is not available in site with groupId" + groupId);
            Locale[] sourceAvailableLocales = new Locale[]{articleDefaultLocale};
            le.setSourceAvailableLocales(sourceAvailableLocales);
            le.setTargetAvailableLocales((Locale[])availableLocales);
            throw le;
        }
        if (classNameId == 0L && (titleMap.isEmpty() || Validator.isNull((String)titleMap.get(articleDefaultLocale)))) {
            throw new ArticleTitleException();
        }
        if (Validator.isNull((String)type)) {
            throw new ArticleTypeException();
        }
        this.validateContent(content);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        this.validateDDMStructureFields(ddmStructure, classNameId, serviceContext);
        if (Validator.isNotNull((String)ddmTemplateKey)) {
            DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(DDMStructure.class), ddmTemplateKey, true);
            if (ddmTemplate.getClassPK() != ddmStructure.getStructureId()) {
                throw new NoSuchTemplateException("{templateKey=" + ddmTemplateKey + "}");
            }
        } else if (classNameId == 0L) {
            throw new NoSuchTemplateException();
        }
        if (expirationDate != null && expirationDate.before(new Date()) && !ExportImportThreadLocal.isImportInProcess()) {
            throw new ArticleExpirationDateException();
        }
        String[] imageExtensions = PrefsPropsUtil.getStringArray("journal.image.extensions", ",");
        if (!smallImage || Validator.isNotNull((String)smallImageURL) || smallImageFile == null || smallImageBytes == null) {
            return;
        }
        String smallImageName = smallImageFile.getName();
        if (smallImageName != null) {
            boolean validSmallImageExtension = false;
            for (String _imageExtension : imageExtensions) {
                if (!"*".equals(_imageExtension) && !StringUtil.endsWith((String)smallImageName, (String)_imageExtension)) continue;
                validSmallImageExtension = true;
                break;
            }
            if (!validSmallImageExtension) {
                throw new ArticleSmallImageNameException(smallImageName);
            }
        }
        if ((smallImageMaxSize = PrefsPropsUtil.getLong("journal.image.small.max.size")) > 0L && (smallImageBytes == null || (long)smallImageBytes.length > smallImageMaxSize)) {
            throw new ArticleSmallImageSizeException();
        }
    }

    protected void validate(long companyId, long groupId, long classNameId, String articleId, boolean autoArticleId, double version, Map<Locale, String> titleMap, String content, String type, String ddmStructureKey, String ddmTemplateKey, Date expirationDate, boolean smallImage, String smallImageURL, File smallImageFile, byte[] smallImageBytes, ServiceContext serviceContext) throws PortalException {
        JournalArticle article;
        if (!autoArticleId) {
            this.validate(articleId);
        }
        if ((article = this.journalArticlePersistence.fetchByG_A_V(groupId, articleId, version)) != null) {
            StringBundler sb = new StringBundler(7);
            sb.append("{groupId=");
            sb.append(groupId);
            sb.append(", articleId=");
            sb.append(articleId);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            throw new DuplicateArticleIdException(sb.toString());
        }
        this.validate(companyId, groupId, classNameId, titleMap, content, type, ddmStructureKey, ddmTemplateKey, expirationDate, smallImage, smallImageURL, smallImageFile, smallImageBytes, serviceContext);
    }

    protected void validate(String articleId) throws PortalException {
        if (Validator.isNull((String)articleId) || articleId.indexOf(44) != -1 || articleId.indexOf(32) != -1) {
            throw new ArticleIdException();
        }
    }

    protected void validateContent(String content) throws PortalException {
        if (Validator.isNull((String)content)) {
            throw new ArticleContentException("Content is null");
        }
        try {
            SAXReaderUtil.read((String)content);
        }
        catch (DocumentException de) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid content:\n" + content));
            }
            throw new ArticleContentException("Unable to read content with an XML parser", (Throwable)de);
        }
    }

    protected void validateDDMStructureFields(DDMStructure ddmStructure, long classNameId, ServiceContext serviceContext) throws PortalException {
        Fields fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
        for (Field field : fields) {
            if (!ddmStructure.hasField(field.getName())) {
                throw new StorageFieldNameException();
            }
            if (!ddmStructure.getFieldRequired(field.getName()) || !Validator.isNull((Object)field.getValue()) || classNameId != 0L) continue;
            throw new StorageFieldRequiredException();
        }
    }

    protected void validateDDMStructureId(long groupId, long folderId, String ddmStructureKey) throws PortalException {
        int restrictionType = JournalUtil.getRestrictionType(folderId);
        DDMStructure ddmStructure = this.ddmStructureLocalService.getStructure(PortalUtil.getSiteGroupId((long)groupId), this.classNameLocalService.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        List folderDDMStructures = this.ddmStructureLocalService.getJournalFolderStructures(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), folderId, restrictionType);
        for (DDMStructure folderDDMStructure : folderDDMStructures) {
            if (folderDDMStructure.getStructureId() != ddmStructure.getStructureId()) continue;
            return;
        }
        throw new InvalidDDMStructureException("Invalid structure " + ddmStructure.getStructureId() + " for folder " + folderId);
    }
}

