/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.PortalPreferences;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.search.ArticleDisplayTerms;
import com.liferay.portlet.journal.search.ArticleSearchTerms;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class ArticleSearch
extends SearchContainer<JournalArticle> {
    public static List<String> headerNames = new ArrayList<String>();
    public static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static Log _log;

    public ArticleSearch(PortletRequest portletRequest, int cur, int delta, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new ArticleDisplayTerms(portletRequest), (DisplayTerms)new ArticleSearchTerms(portletRequest), "cur", cur, delta, iteratorURL, headerNames, null);
        PortletConfig portletConfig = (PortletConfig)portletRequest.getAttribute("javax.portlet.config");
        ArticleDisplayTerms displayTerms = (ArticleDisplayTerms)this.getDisplayTerms();
        ArticleSearchTerms searchTerms = (ArticleSearchTerms)this.getSearchTerms();
        String portletName = portletConfig.getPortletName();
        if (!portletName.equals("15")) {
            displayTerms.setStatus(0);
            searchTerms.setStatus(0);
        }
        iteratorURL.setParameter("searchArticleId", displayTerms.getArticleId());
        iteratorURL.setParameter("content", displayTerms.getContent());
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("folderId", String.valueOf(displayTerms.getFolderId()));
        iteratorURL.setParameter("groupId", String.valueOf(displayTerms.getGroupId()));
        iteratorURL.setParameter("navigation", displayTerms.getNavigation());
        iteratorURL.setParameter("status", String.valueOf(displayTerms.getStatus()));
        iteratorURL.setParameter("structureId", displayTerms.getStructureId());
        iteratorURL.setParameter("templateId", displayTerms.getTemplateId());
        iteratorURL.setParameter("title", displayTerms.getTitle());
        iteratorURL.setParameter("type", displayTerms.getType());
        iteratorURL.setParameter("version", String.valueOf(displayTerms.getVersion()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue("15", "articles-order-by-col", orderByCol);
                preferences.setValue("15", "articles-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue("15", "articles-order-by-col", "id");
                orderByType = preferences.getValue("15", "articles-order-by-type", "asc");
            }
            OrderByComparator<JournalArticle> orderByComparator = JournalUtil.getArticleOrderByComparator(orderByCol, orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    public ArticleSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, 0, DEFAULT_DELTA, iteratorURL);
    }

    static {
        headerNames.add("id");
        headerNames.add("title");
        headerNames.add("status");
        headerNames.add("modified-date");
        headerNames.add("display-date");
        headerNames.add("author");
        headerNames.add("structure");
        headerNames.add("");
        orderableHeaders.put("modified-date", "modified-date");
        orderableHeaders.put("display-date", "display-date");
        _log = LogFactoryUtil.getLog(ArticleSearch.class);
    }
}

