/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class JournalFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFolder> {
    public static final String[] CLASS_NAMES = new String[]{JournalFolder.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalFolder folder = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (folder != null) {
            JournalFolderLocalServiceUtil.deleteFolder((JournalFolder)folder);
        }
    }

    public JournalFolder fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List folders = JournalFolderLocalServiceUtil.getJournalFoldersByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)folders)) {
            return null;
        }
        return (JournalFolder)folders.get(0);
    }

    public JournalFolder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return JournalFolderLocalServiceUtil.fetchJournalFolderByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder);
        JournalFolder importedFolder = null;
        long groupId = portletDataContext.getScopeGroupId();
        if (portletDataContext.isDataStrategyMirror()) {
            JournalFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), groupId);
            if (existingFolder == null) {
                serviceContext.setUuid(folder.getUuid());
                importedFolder = JournalFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = JournalFolderLocalServiceUtil.updateFolder((long)userId, (long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            importedFolder = JournalFolderLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        JournalFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !existingFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingFolder.getTrashHandler();
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(userId, existingFolder.getFolderId());
        }
    }
}

