/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.journal.lar.JournalCreationStrategy;
import com.liferay.portlet.journal.lar.JournalCreationStrategyFactory;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleImage;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleImageLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class JournalArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalArticle> {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.fetchJournalArticleResourceByUuidAndGroupId((String)uuid, (long)groupId);
        if (articleResource == null) {
            return;
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        if (Validator.isNotNull((String)extraData) && extraDataJSONObject.has("uuid")) {
            String articleUuid = extraDataJSONObject.getString("uuid");
            JournalArticle article = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
            JournalArticleLocalServiceUtil.deleteArticle((JournalArticle)article);
        } else {
            JournalArticleLocalServiceUtil.deleteArticle((long)groupId, (String)articleResource.getArticleId(), null);
        }
    }

    public JournalArticle fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List articles = JournalArticleLocalServiceUtil.getJournalArticlesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)articles)) {
            return null;
        }
        return (JournalArticle)articles.get(0);
    }

    public JournalArticle fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return JournalArticleLocalServiceUtil.fetchJournalArticleByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalArticle article) {
        return article.getTitleCurrentValue();
    }

    public int[] getExportableStatuses() {
        return new int[]{0, 3, 7};
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, JournalArticle article) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        String articleResourceUuid = null;
        try {
            articleResourceUuid = article.getArticleResourceUuid();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find article resource for article " + article.getArticleId());
        }
        referenceAttributes.put("article-resource-uuid", articleResourceUuid);
        referenceAttributes.put("article-id", article.getArticleId());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)article.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == article.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        JournalArticle existingArticle = null;
        existingArticle = this.fetchExistingArticle(uuid, articleResourceUuid, liveGroupId, articleArticleId, null, 0.0, preloaded);
        Map articleArticleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleArticleIds.put(articleArticleId, existingArticle.getArticleId());
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
        long articleId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        articleIds.put(articleId, existingArticle.getId());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        JournalArticle existingArticle = this.fetchExistingArticle(uuid, articleResourceUuid, liveGroupId, articleArticleId, null, 0.0, preloaded);
        return existingArticle != null;
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, JournalArticle article) {
        return !portletDataContext.isModelCounted(JournalArticleResource.class.getName(), article.getResourcePrimKey());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Element articleElement = portletDataContext.getExportDataElement((ClassedModel)article);
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        if (article.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)article.getFolder(), (String)"parent");
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)article.getGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)article.getStructureId(), (boolean)true);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmStructure, (String)"strong");
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)article.getTemplateId(), (boolean)true);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmTemplate, (String)"strong");
        Layout layout = article.getLayout();
        if (layout != null) {
            portletDataContext.addReferenceElement((ClassedModel)article, articleElement, (ClassedModel)layout, "dependency", true);
        }
        if (article.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.fetchImage((long)article.getSmallImageId());
            if (Validator.isNotNull((String)article.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (String)(article.getSmallImageURL() + " "), (boolean)true);
                article.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                articleElement.addAttribute("small-image-path", smallImagePath);
                article.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        List articleImages = JournalArticleImageLocalServiceUtil.getArticleImages((long)article.getGroupId(), (String)article.getArticleId(), (double)article.getVersion());
        for (JournalArticleImage articleImage : articleImages) {
            this.exportArticleImage(portletDataContext, articleImage, article, articleElement);
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        String content = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (String)article.getContent(), (boolean)portletDataContext.getBooleanParameter("journal", "referenced-content"));
        article.setContent(content);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)article.getCompanyId());
        if (defaultUserId == article.getUserId()) {
            articleElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(articleElement, ExportImportPathUtil.getModelPath((StagedModel)article), (ClassedModel)article);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Map articleIds;
        String newArticleId;
        long userId = portletDataContext.getUserId(article.getUserUuid());
        JournalCreationStrategy creationStrategy = JournalCreationStrategyFactory.getInstance();
        long authorId = creationStrategy.getAuthorUserId(portletDataContext, article);
        if (authorId != 0L) {
            userId = authorId;
        }
        User user = UserLocalServiceUtil.getUser((long)userId);
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)article.getFolderId(), (long)article.getFolderId());
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || JournalArticleLocalServiceUtil.fetchArticle((long)portletDataContext.getScopeGroupId(), (String)articleId, (double)1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId")).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        content = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (String)content);
        article.setContent(content);
        String newContent = creationStrategy.getTransformedContent(portletDataContext, article);
        if (newContent != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        String parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)article.getStructureId(), (String)article.getStructureId());
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = 0L;
        if (article.getClassNameId() != 0L) {
            ddmStructureId = (Long)ddmStructureIds.get(article.getClassPK());
        }
        Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        String parentDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)article.getTemplateId(), (String)article.getTemplateId());
        File smallFile = null;
        try {
            Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
            if (article.isSmallImage()) {
                byte[] bytes;
                String smallImagePath = articleElement.attributeValue("small-image-path");
                if (Validator.isNotNull((String)article.getSmallImageURL())) {
                    String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)article, (String)article.getSmallImageURL());
                    article.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                    smallFile = FileUtil.createTempFile((String)article.getSmallImageType());
                    FileUtil.write((File)smallFile, (byte[])bytes);
                }
            }
            HashMap<String, byte[]> images = new HashMap<String, byte[]>();
            List imagesElements = portletDataContext.getReferenceDataElements((StagedModel)article, Image.class);
            for (Element imageElement : imagesElements) {
                String imagePath = imageElement.attributeValue("path");
                String fileName = imageElement.attributeValue("file-name");
                images.put(fileName, portletDataContext.getZipEntryAsByteArray(imagePath));
            }
            String articleURL = null;
            boolean addGroupPermissions = creationStrategy.addGroupPermissions(portletDataContext, article);
            boolean addGuestPermissions = creationStrategy.addGuestPermissions(portletDataContext, article);
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)article);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            if (article.getStatus() != 0 && article.getStatus() != 7) {
                serviceContext.setWorkflowAction(2);
            }
            JournalArticle importedArticle = null;
            String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
            if (portletDataContext.isDataStrategyMirror()) {
                serviceContext.setUuid(article.getUuid());
                serviceContext.setAttribute("articleResourceUuid", (Serializable)((Object)articleResourceUuid));
                serviceContext.setAttribute("urlTitle", (Serializable)((Object)article.getUrlTitle()));
                boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
                JournalArticle existingArticle = this.fetchExistingArticle(article.getUuid(), articleResourceUuid, portletDataContext.getScopeGroupId(), articleId, newArticleId, article.getVersion(), preloaded);
                if (existingArticle == null) {
                    importedArticle = JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (long)article.getClassNameId(), (long)ddmStructureId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
                } else {
                    String importedArticleUuid;
                    importedArticle = JournalArticleLocalServiceUtil.updateArticle((long)userId, (long)existingArticle.getGroupId(), (long)folderId, (String)existingArticle.getArticleId(), (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
                    String existingArticleUuid = existingArticle.getUuid();
                    if (!existingArticleUuid.equals(importedArticleUuid = importedArticle.getUuid())) {
                        importedArticle.setUuid(existingArticleUuid);
                        JournalArticleLocalServiceUtil.updateJournalArticle((JournalArticle)importedArticle);
                    }
                }
            } else {
                importedArticle = JournalArticleLocalServiceUtil.addArticle((long)userId, (long)portletDataContext.getScopeGroupId(), (long)folderId, (long)article.getClassNameId(), (long)ddmStructureId, (String)articleId, (boolean)autoArticleId, (double)article.getVersion(), (Map)article.getTitleMap(), (Map)article.getDescriptionMap(), (String)article.getContent(), (String)article.getType(), (String)parentDDMStructureKey, (String)parentDDMTemplateKey, (String)article.getLayoutUuid(), (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)article.isIndexable(), (boolean)article.isSmallImage(), (String)article.getSmallImageURL(), (File)smallFile, images, articleURL, (ServiceContext)serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)article, (ClassedModel)importedArticle);
            if (Validator.isNull((String)newArticleId)) {
                articleIds.put(article.getArticleId(), importedArticle.getArticleId());
            }
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        long userId = portletDataContext.getUserId(article.getUserUuid());
        Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
        JournalArticle existingArticle = this.fetchExistingArticle(article.getUuid(), articleResourceUuid, portletDataContext.getScopeGroupId(), article.getArticleId(), article.getArticleId(), article.getVersion(), preloaded);
        if (existingArticle == null || !existingArticle.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingArticle.getTrashHandler();
        if (trashHandler.isRestorable(existingArticle.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingArticle.getResourcePrimKey());
        }
    }

    protected void exportArticleImage(PortletDataContext portletDataContext, JournalArticleImage articleImage, JournalArticle article, Element articleElement) {
        String fileName;
        String articleImagePath;
        Image image = ImageLocalServiceUtil.fetchImage((long)articleImage.getArticleImageId());
        if (image == null || image.getTextObj() == null) {
            return;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(articleImage.getElInstanceId());
        sb.append("_");
        sb.append(articleImage.getElName());
        if (Validator.isNotNull((String)articleImage.getLanguageId())) {
            sb.append(articleImage.getLanguageId());
        }
        if (!portletDataContext.isPathNotProcessed(articleImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)(fileName = sb.toString())))) {
            return;
        }
        Element imageElement = portletDataContext.getExportDataElement((ClassedModel)image);
        imageElement.addAttribute("file-name", fileName);
        imageElement.addAttribute("path", articleImagePath);
        portletDataContext.addZipEntry(articleImagePath, image.getTextObj());
        portletDataContext.addReferenceElement((ClassedModel)article, articleElement, (ClassedModel)image, articleImagePath, "dependency", false);
    }

    protected JournalArticle fetchExistingArticle(String articleUuid, String articleResourceUuid, long groupId, String articleId, String newArticleId, double version, boolean preloaded) {
        JournalArticle existingArticle = null;
        if (!preloaded) {
            existingArticle = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
            if (existingArticle != null) {
                return existingArticle;
            }
            JournalArticleResource journalArticleResource = JournalArticleResourceLocalServiceUtil.fetchJournalArticleResourceByUuidAndGroupId((String)articleResourceUuid, (long)groupId);
            if (journalArticleResource == null) {
                return null;
            }
            return JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)journalArticleResource.getArticleId(), (double)version);
        }
        if (Validator.isNotNull((String)newArticleId) && version > 0.0) {
            existingArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)newArticleId, (double)version);
        }
        if (existingArticle == null && Validator.isNull((String)newArticleId)) {
            existingArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)version);
        }
        return existingArticle;
    }
}

