/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.journal.asset.JournalFolderAssetRenderer;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class JournalFolderAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "content_folder";

    public JournalFolderAssetRendererFactory() {
        this.setCategorizable(false);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        JournalFolderAssetRenderer journalFolderAssetRenderer = new JournalFolderAssetRenderer(folder);
        journalFolderAssetRenderer.setAssetRendererType(type);
        return journalFolderAssetRenderer;
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public String getIconCssClass() {
        return "icon-folder-close";
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("15", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
        return JournalFolderPermission.contains(permissionChecker, folder, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/folder.png";
    }
}

