/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRendererFactory;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalFolderPermission;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;

public class JournalFolderAssetRenderer
extends BaseAssetRenderer
implements TrashRenderer {
    public static final String TYPE = "folder";
    private JournalFolder _folder;

    public JournalFolderAssetRenderer(JournalFolder folder) {
        this._folder = folder;
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public long getClassPK() {
        return this._folder.getFolderId();
    }

    public Date getDisplayDate() {
        return this._folder.getModifiedDate();
    }

    public long getGroupId() {
        return this._folder.getGroupId();
    }

    public String getIconCssClass() throws PortalException {
        if (JournalFolderServiceUtil.getFoldersAndArticlesCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId()) > 0) {
            return "icon-folder-close";
        }
        return super.getIconCssClass();
    }

    public String getIconPath(ThemeDisplay themeDisplay) {
        try {
            if (JournalFolderServiceUtil.getFoldersAndArticlesCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId(), (int)0) > 0) {
                return themeDisplay.getPathThemeImages() + "/common/folder_full_document.png";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return themeDisplay.getPathThemeImages() + "/common/folder_empty.png";
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._folder.getDescription();
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int articlesCount = JournalArticleServiceUtil.getArticlesCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId());
        int foldersCount = JournalFolderServiceUtil.getFoldersCount((long)this._folder.getGroupId(), (long)this._folder.getFolderId());
        if (articlesCount > 0 || foldersCount > 0) {
            return themeDisplay.getPathThemeImages() + "/file_system/large/folder_full_article.png";
        }
        return themeDisplay.getPathThemeImages() + "/file_system/large/folder_empty_article.png";
    }

    public String getTitle(Locale locale) {
        return TrashUtil.getOriginalTitle((String)this._folder.getName());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL = liferayPortletResponse.createLiferayPortletURL(this.getControlPanelPlid(liferayPortletRequest), "15", "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_folder");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("struts_action", "/journal/view");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        portletURL.setWindowState(windowState);
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/journal/find_folder", "folderId", this._folder.getFolderId());
    }

    public long getUserId() {
        return this._folder.getUserId();
    }

    public String getUserName() {
        return this._folder.getUserName();
    }

    public String getUuid() {
        return this._folder.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalFolderPermission.contains(permissionChecker, this._folder, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalFolderPermission.contains(permissionChecker, this._folder, "VIEW");
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("full_content")) {
            renderRequest.setAttribute("JOURNAL_FOLDER", (Object)this._folder);
            return "/html/portlet/journal/asset/folder_" + template + ".jsp";
        }
        return null;
    }
}

