/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.asset.model.BaseDDMStructureClassTypeReader;
import com.liferay.portlet.asset.model.ClassTypeReader;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMStructurePermission;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.permission.JournalArticlePermission;
import com.liferay.portlet.journal.service.permission.JournalPermission;
import java.util.Locale;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "content";

    public JournalArticleAssetRendererFactory() {
        this.setLinkable(true);
        this.setSupportsClassTypes(true);
    }

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException {
        JournalArticle article;
        block5: {
            article = null;
            try {
                article = JournalArticleLocalServiceUtil.getArticle((long)classPK);
            }
            catch (NoSuchArticleException nsae1) {
                JournalArticleResource articleResource = JournalArticleResourceLocalServiceUtil.getArticleResource((long)classPK);
                boolean approvedArticleAvailable = true;
                if (type == 1) {
                    try {
                        article = JournalArticleLocalServiceUtil.getDisplayArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId());
                    }
                    catch (NoSuchArticleException nsae2) {
                        approvedArticleAvailable = false;
                    }
                }
                if (type == 1 && approvedArticleAvailable) break block5;
                article = JournalArticleLocalServiceUtil.getLatestArticle((long)articleResource.getGroupId(), (String)articleResource.getArticleId(), (int)-1);
            }
        }
        JournalArticleAssetRenderer journalArticleAssetRenderer = new JournalArticleAssetRenderer(article);
        journalArticleAssetRenderer.setAssetRendererType(type);
        return journalArticleAssetRenderer;
    }

    public AssetRenderer getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        JournalArticle article = JournalArticleServiceUtil.getDisplayArticleByUrlTitle((long)groupId, (String)urlTitle);
        return new JournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new BaseDDMStructureClassTypeReader(this.getClassName());
    }

    public String getIconCssClass() {
        return "icon-file-2";
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, long subtypeId) {
        try {
            DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)subtypeId);
            return ddmStructure.getName(locale);
        }
        catch (Exception e) {
            return super.getTypeName(locale, subtypeId);
        }
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL portletURL = liferayPortletResponse.createRenderURL("15");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("15", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException wse) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId == 0L) {
            return false;
        }
        if (!DDMStructurePermission.contains(permissionChecker, classTypeId, "VIEW")) {
            return false;
        }
        return JournalPermission.contains(permissionChecker, groupId, "ADD_ARTICLE");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return JournalArticlePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return themeDisplay.getPathThemeImages() + "/common/history.png";
    }
}

