/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.portlet.journal.util.comparator.ArticleModifiedDateComparator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetArticlesAction
extends Action {
    private static Log _log = LogFactoryUtil.getLog(GetArticlesAction.class);

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            List<JournalArticle> articles = this.getArticles(request);
            String fileName = null;
            byte[] bytes = this.getContent(request, articles);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, fileName, (byte[])bytes, (String)"text/xml; charset=UTF-8");
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected List<JournalArticle> getArticles(HttpServletRequest request) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
        ArrayList<Long> folderIds = new ArrayList<Long>(1);
        folderIds.add(folderId);
        String articleId = null;
        Double version = null;
        String title = null;
        String description = null;
        String content = null;
        String type = ParamUtil.getString((HttpServletRequest)request, (String)"type");
        String[] structureIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"structureId"));
        String[] templateIds = StringUtil.split((String)ParamUtil.getString((HttpServletRequest)request, (String)"templateId"));
        Date displayDateGT = null;
        String displayDateGTParam = ParamUtil.getString((HttpServletRequest)request, (String)"displayDateGT");
        if (Validator.isNotNull((String)displayDateGTParam)) {
            DateFormat displayDateGTFormat = DateUtil.getISOFormat((String)displayDateGTParam);
            displayDateGT = GetterUtil.getDate((String)displayDateGTParam, (DateFormat)displayDateGTFormat);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("displayDateGT is " + displayDateGT));
        }
        Date displayDateLT = null;
        String displayDateLTParam = ParamUtil.getString((HttpServletRequest)request, (String)"displayDateLT");
        if (Validator.isNotNull((String)displayDateLTParam)) {
            DateFormat displayDateLTFormat = DateUtil.getISOFormat((String)displayDateLTParam);
            displayDateLT = GetterUtil.getDate((String)displayDateLTParam, (DateFormat)displayDateLTFormat);
        }
        if (displayDateLT == null) {
            displayDateLT = new Date();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("displayDateLT is " + displayDateLT));
        }
        int status = 0;
        Date reviewDate = null;
        boolean andOperator = true;
        int start = 0;
        int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"delta", (int)5);
        String orderBy = ParamUtil.getString((HttpServletRequest)request, (String)"orderBy");
        String orderByCol = ParamUtil.getString((HttpServletRequest)request, (String)"orderByCol", (String)orderBy);
        String orderByType = ParamUtil.getString((HttpServletRequest)request, (String)"orderByType");
        boolean orderByAsc = orderByType.equals("asc");
        ArticleModifiedDateComparator obc = new ArticleModifiedDateComparator(orderByAsc);
        if (orderByCol.equals("display-date")) {
            obc = new ArticleDisplayDateComparator(orderByAsc);
        }
        return JournalArticleServiceUtil.search((long)companyId, (long)groupId, folderIds, (long)0L, articleId, version, title, description, content, (String)type, (String[])structureIds, (String[])templateIds, (Date)displayDateGT, (Date)displayDateLT, (int)status, reviewDate, (boolean)andOperator, (int)start, (int)end, (OrderByComparator)obc);
    }

    protected byte[] getContent(HttpServletRequest request, List<JournalArticle> articles) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map<String, String> tokens = JournalUtil.getTokens(groupId, themeDisplay);
        Document resultsDoc = SAXReaderUtil.createDocument((String)"UTF-8");
        Element resultSetEl = resultsDoc.addElement("result-set");
        for (JournalArticle article : articles) {
            Element resultEl = resultSetEl.addElement("result");
            Document articleDoc = SAXReaderUtil.read((String)article.getContentByLocale(languageId));
            resultEl.content().add(articleDoc.getRootElement().createCopy());
            resultEl = resultEl.element("root");
            JournalUtil.addAllReservedEls(resultEl, tokens, article, languageId, themeDisplay);
        }
        return DDMXMLUtil.formatXML((Document)resultsDoc).getBytes("UTF-8");
    }
}

