/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.ProcessingInstruction;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetArticleAction
extends Action {
    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            String articleId = ParamUtil.getString((HttpServletRequest)request, (String)"articleId");
            String languageId = LanguageUtil.getLanguageId((HttpServletRequest)request);
            JournalArticle article = JournalArticleServiceUtil.getLatestArticle((long)groupId, (String)articleId, (int)0);
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            Map<String, String> tokens = JournalUtil.getTokens(groupId, themeDisplay);
            String xml = article.getContentByLocale(languageId);
            Document doc = SAXReaderUtil.read((String)xml);
            Element root = doc.getRootElement();
            this.addProcessingInstructions(doc, request, themeDisplay, article);
            JournalUtil.addAllReservedEls(root, tokens, article, languageId, themeDisplay);
            xml = DDMXMLUtil.formatXML((Document)doc);
            String contentType = "text/xml; charset=UTF-8";
            String fileName = null;
            byte[] bytes = xml.getBytes();
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, fileName, (byte[])bytes, (String)contentType);
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected void addProcessingInstructions(Document doc, HttpServletRequest request, ThemeDisplay themeDisplay, JournalArticle article) {
        String url = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)(themeDisplay.getCDNDynamicResourcesHost() + themeDisplay.getPathContext() + "/html/portal/css.jsp"));
        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
        arguments.put("type", "text/css");
        arguments.put("href", url);
        arguments.put("title", "portal css");
        arguments.put("alternate", "yes");
        this.addStyleSheet(doc, url, arguments);
        url = PortalUtil.getStaticResourceURL((HttpServletRequest)request, (String)(themeDisplay.getPathThemeCss() + "/main.css"));
        arguments.clear();
        arguments.put("type", "text/css");
        arguments.put("href", url);
        arguments.put("title", "theme css");
        this.addStyleSheet(doc, url, arguments);
        String templateId = article.getTemplateId();
        if (Validator.isNull((String)templateId)) {
            return;
        }
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (String)templateId, (boolean)true);
            if (Validator.equals((Object)ddmTemplate.getLanguage(), (Object)"xsl")) {
                url = themeDisplay.getPathMain() + "/journal/get_template?groupId=" + article.getGroupId() + "&templateId=" + templateId;
                arguments.clear();
                arguments.put("type", "text/xsl");
                arguments.put("href", url);
                arguments.put("title", "xsl");
                this.addStyleSheet(doc, url, arguments);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void addStyleSheet(Document doc, String url, Map<String, String> arguments) {
        List content = doc.content();
        ProcessingInstruction processingInstruction = SAXReaderUtil.createProcessingInstruction((String)"xml-stylesheet", arguments);
        content.add(0, processingInstruction);
    }
}

