/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.FolderNameException;
import com.liferay.portlet.journal.InvalidDDMStructureException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            } else if (cmd.equals("updateWorkflowDefinitions")) {
                this.updateWorkflowDefinitions(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof DuplicateFolderNameException || e instanceof FolderNameException || e instanceof InvalidDDMStructureException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_folder"));
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ArrayList<JournalFolder> trashedModels = new ArrayList<JournalFolder>();
        for (long deleteFolderId : deleteFolderIds) {
            if (moveToTrash) {
                JournalFolder folder = JournalFolderServiceUtil.moveFolderToTrash((long)deleteFolderId);
                trashedModels.add(folder);
            } else {
                JournalFolderServiceUtil.deleteFolder((long)deleteFolderId);
            }
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, (String)JournalArticle.class.getName(), (long)deleteFolderId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        JournalFolderServiceUtil.subscribe((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        JournalFolderServiceUtil.unsubscribe((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean mergeWithParentFolder = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            JournalFolderServiceUtil.addFolder((long)serviceContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            long[] ddmStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructuresSearchContainerPrimaryKeys"), (long)0L);
            int restrinctionType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"restrictionType");
            JournalFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (long[])ddmStructureIds, (int)restrinctionType, (boolean)mergeWithParentFolder, (ServiceContext)serviceContext);
        }
    }

    protected void updateWorkflowDefinitions(ActionRequest actionRequest) throws Exception {
        long[] ddmStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructuresSearchContainerPrimaryKeys"), (long)0L);
        int restrinctionType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"restrictionType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        JournalFolderServiceUtil.updateFolder((long)0L, (long)0L, null, null, (long[])ddmStructureIds, (int)restrinctionType, (boolean)false, (ServiceContext)serviceContext);
    }
}

