/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.InvalidDDMStructureException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.ArrayList;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            WindowState windowState;
            if (cmd.equals("delete") || cmd.equals("delete_versions")) {
                this.deleteEntries(actionRequest, false);
            } else if (cmd.equals("expire")) {
                this.expireEntries(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveEntries(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteEntries(actionRequest, true);
            }
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (cmd.equals("delete_versions") && !ActionUtil.hasArticle(actionRequest)) {
                String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
                if (Validator.isNotNull((String)referringPortletResource)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.journal.asset.add_asset_redirect");
                    return;
                }
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
                redirect = portletURL.toString();
            }
            if (!(windowState = actionRequest.getWindowState()).equals((Object)LiferayWindowState.POP_UP)) {
                this.sendRedirect(actionRequest, actionResponse);
            } else if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof NoSuchFolderException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof DuplicateArticleIdException || e instanceof DuplicateFolderNameException || e instanceof InvalidDDMStructureException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticles((PortletRequest)renderRequest);
            ActionUtil.getFolders((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        String forward = "portlet.journal.edit_entry";
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void deleteEntries(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        String[] deleteArticleIds;
        long[] deleteFolderIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<Object> trashedModels = new ArrayList<Object>();
        for (long deleteFolderId : deleteFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L)) {
            if (moveToTrash) {
                JournalFolder folder = JournalFolderServiceUtil.moveFolderToTrash((long)deleteFolderId);
                trashedModels.add(folder);
                continue;
            }
            JournalFolderServiceUtil.deleteFolder((long)deleteFolderId);
        }
        for (String deleteArticleId : deleteArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"))) {
            if (moveToTrash) {
                JournalArticle article = JournalArticleServiceUtil.moveArticleToTrash((long)themeDisplay.getScopeGroupId(), (String)HtmlUtil.unescape((String)deleteArticleId));
                trashedModels.add(article);
                continue;
            }
            ActionUtil.deleteArticle(actionRequest, HtmlUtil.unescape((String)deleteArticleId));
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void expireEntries(ActionRequest actionRequest) throws Exception {
        String[] expireArticleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] expireFolderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (long expireFolderId : expireFolderIds) {
            ActionUtil.expireFolder(themeDisplay.getScopeGroupId(), expireFolderId, serviceContext);
        }
        for (String expireArticleId : expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"))) {
            ActionUtil.expireArticle(actionRequest, HtmlUtil.unescape((String)expireArticleId));
        }
    }

    protected void moveEntries(ActionRequest actionRequest) throws Exception {
        String[] articleIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        long[] folderIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (long folderId : folderIds) {
            JournalFolderServiceUtil.moveFolder((long)folderId, (long)newFolderId, (ServiceContext)serviceContext);
        }
        ArrayList<String> invalidArticleIds = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (String articleId : articleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"))) {
            try {
                JournalArticleServiceUtil.moveArticle((long)themeDisplay.getScopeGroupId(), (String)HtmlUtil.unescape((String)articleId), (long)newFolderId);
            }
            catch (InvalidDDMStructureException idse) {
                invalidArticleIds.add(articleId);
            }
        }
        if (!invalidArticleIds.isEmpty()) {
            throw new InvalidDDMStructureException();
        }
    }
}

