/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.asset.AssetCategoryException;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import com.liferay.portlet.journal.ArticleContentException;
import com.liferay.portlet.journal.ArticleContentSizeException;
import com.liferay.portlet.journal.ArticleDisplayDateException;
import com.liferay.portlet.journal.ArticleExpirationDateException;
import com.liferay.portlet.journal.ArticleIdException;
import com.liferay.portlet.journal.ArticleSmallImageNameException;
import com.liferay.portlet.journal.ArticleSmallImageSizeException;
import com.liferay.portlet.journal.ArticleTitleException;
import com.liferay.portlet.journal.ArticleTypeException;
import com.liferay.portlet.journal.ArticleVersionException;
import com.liferay.portlet.journal.DuplicateArticleIdException;
import com.liferay.portlet.journal.NoSuchArticleException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.asset.JournalArticleAssetRenderer;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditArticleAction
extends PortletAction {
    public static final String VERSION_SEPARATOR = "_version_";
    private static Log _log = LogFactoryUtil.getLog(EditArticleAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        JournalArticle article = null;
        String oldUrlTitle = "";
        try {
            String oldRedirectParam;
            String oldRedirect;
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                    throw new LiferayFileItemException();
                }
                if (uploadException.isExceededSizeLimit()) {
                    throw new ArticleContentSizeException();
                }
                throw new PortalException(uploadException.getCause());
            }
            if (Validator.isNull((String)cmd)) {
                return;
            }
            if (cmd.equals("add") || cmd.equals("preview") || cmd.equals("translate") || cmd.equals("update")) {
                Object[] contentAndImages = this.updateArticle(actionRequest);
                article = (JournalArticle)contentAndImages[0];
                oldUrlTitle = (String)contentAndImages[1];
            } else if (cmd.equals("delete")) {
                this.deleteArticles(actionRequest, false);
            } else if (cmd.equals("delete_translation")) {
                this.removeArticlesLocale(actionRequest);
            } else if (cmd.equals("expire")) {
                this.expireArticles(actionRequest);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteArticles(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeStructure(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeStructure(actionRequest);
            }
            String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
            int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
            String portletId = HttpUtil.getParameter((String)redirect, (String)"p_p_id", (boolean)false);
            String namespace = PortalUtil.getPortletNamespace((String)portletId);
            if (Validator.isNotNull((String)oldUrlTitle) && Validator.isNotNull((String)(oldRedirect = HttpUtil.getParameter((String)redirect, (String)(oldRedirectParam = namespace + "redirect"), (boolean)false)))) {
                String newRedirect = HttpUtil.decodeURL((String)oldRedirect);
                newRedirect = StringUtil.replace((String)newRedirect, (String)oldUrlTitle, (String)article.getUrlTitle());
                newRedirect = StringUtil.replace((String)newRedirect, (String)oldRedirectParam, (String)"redirect");
                redirect = StringUtil.replace((String)redirect, (String)oldRedirect, (String)newRedirect);
            }
            if (cmd.equals("delete") && !ActionUtil.hasArticle(actionRequest)) {
                String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
                if (Validator.isNotNull((String)referringPortletResource)) {
                    this.setForward((PortletRequest)actionRequest, "portlet.journal.asset.add_asset_redirect");
                    return;
                }
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)portletConfig.getPortletName(), (long)themeDisplay.getPlid(), (String)"RENDER_PHASE");
                redirect = portletURL.toString();
            }
            if (cmd.equals("delete_translation") || cmd.equals("translate")) {
                this.setForward((PortletRequest)actionRequest, "portlet.journal.update_translation_redirect");
            } else if (article != null && workflowAction == 2) {
                redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, article, redirect);
                if (cmd.equals("preview")) {
                    SessionMessages.add((PortletRequest)actionRequest, (String)"previewRequested");
                    this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                }
                this.sendRedirect(actionRequest, actionResponse, redirect);
            } else {
                WindowState windowState = actionRequest.getWindowState();
                if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
                    this.sendRedirect(actionRequest, actionResponse, redirect);
                } else if (Validator.isNotNull((String)(redirect = PortalUtil.escapeRedirect((String)redirect)))) {
                    if (cmd.equals("add") && article != null) {
                        redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "className"), (String)JournalArticle.class.getName());
                        redirect = HttpUtil.addParameter((String)redirect, (String)(namespace + "classPK"), (long)JournalArticleAssetRenderer.getClassPK(article));
                    }
                    actionResponse.sendRedirect(redirect);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof NoSuchStructureException || e instanceof NoSuchTemplateException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e instanceof ArticleContentException || e instanceof ArticleContentSizeException || e instanceof ArticleDisplayDateException || e instanceof ArticleExpirationDateException || e instanceof ArticleIdException || e instanceof ArticleSmallImageNameException || e instanceof ArticleSmallImageSizeException || e instanceof ArticleTitleException || e instanceof ArticleTypeException || e instanceof ArticleVersionException || e instanceof DuplicateArticleIdException || e instanceof FileSizeException || e instanceof LiferayFileItemException || e instanceof StorageFieldRequiredException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            if (e instanceof AssetCategoryException || e instanceof AssetTagException || e instanceof LocaleException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticle((PortletRequest)renderRequest);
        }
        catch (NoSuchArticleException nsae) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_article"));
    }

    protected void deleteArticles(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] deleteArticleIds = null;
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        deleteArticleIds = Validator.isNotNull((String)articleId) ? new String[]{articleId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"));
        ArrayList<JournalArticle> trashedModels = new ArrayList<JournalArticle>();
        for (String deleteArticleId : deleteArticleIds) {
            if (moveToTrash) {
                JournalArticle article = JournalArticleServiceUtil.moveArticleToTrash((long)themeDisplay.getScopeGroupId(), (String)HtmlUtil.unescape((String)deleteArticleId));
                trashedModels.add(article);
                continue;
            }
            ActionUtil.deleteArticle(actionRequest, HtmlUtil.unescape((String)deleteArticleId));
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            TrashUtil.addTrashSessionMessages((ActionRequest)actionRequest, trashedModels);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void expireArticles(ActionRequest actionRequest) throws Exception {
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        if (Validator.isNotNull((String)articleId)) {
            ActionUtil.expireArticle(actionRequest, articleId);
        } else {
            String[] expireArticleIds;
            for (String expireArticleId : expireArticleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"expireArticleIds"))) {
                ActionUtil.expireArticle(actionRequest, HtmlUtil.unescape((String)expireArticleId));
            }
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, JournalArticle article, String redirect) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/journal/edit_article");
        portletURL.setParameter("redirect", redirect, false);
        portletURL.setParameter("referringPortletResource", referringPortletResource, false);
        portletURL.setParameter("resourcePrimKey", String.valueOf(article.getResourcePrimKey()), false);
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()), false);
        portletURL.setParameter("folderId", String.valueOf(article.getFolderId()), false);
        portletURL.setParameter("articleId", article.getArticleId(), false);
        portletURL.setParameter("version", String.valueOf(article.getVersion()), false);
        portletURL.setParameter("languageId", languageId, false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected void removeArticlesLocale(ActionRequest actionRequest) throws Exception {
        String[] removeArticleLocaleIds;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        for (String removeArticleLocaleId : removeArticleLocaleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"articleIds"))) {
            int pos = removeArticleLocaleId.lastIndexOf(VERSION_SEPARATOR);
            String articleId = removeArticleLocaleId.substring(0, pos);
            double version = GetterUtil.getDouble((String)removeArticleLocaleId.substring(pos + VERSION_SEPARATOR.length()));
            String languageId = ParamUtil.getString((PortletRequest)actionRequest, (String)"languageId");
            JournalArticleServiceUtil.removeArticleLocale((long)groupId, (String)articleId, (double)version, (String)languageId);
        }
    }

    protected void subscribeStructure(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        JournalArticleServiceUtil.subscribeStructure((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (long)ddmStructureId);
    }

    protected void unsubscribeStructure(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        JournalArticleServiceUtil.unsubscribeStructure((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (long)ddmStructureId);
    }

    protected Object[] updateArticle(ActionRequest actionRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating article " + MapUtil.toString((Map)uploadPortletRequest.getParameterMap())));
        }
        String cmd = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"cmd");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleId");
        boolean autoArticleId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)"version");
        String defaultLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"defaultLanguageId");
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        String toLanguageId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"toLanguageId");
        Locale toLocale = null;
        String title = "";
        String description = "";
        if (Validator.isNull((String)toLanguageId)) {
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + defaultLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + defaultLanguageId));
        } else {
            toLocale = LocaleUtil.fromLanguageId((String)toLanguageId);
            title = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("title_" + toLanguageId));
            description = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)("description_" + toLanguageId));
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        String structureId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"structureId");
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)PortalUtil.getSiteGroupId((long)groupId), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)structureId, (boolean)true);
        String languageId = toLanguageId;
        if (Validator.isNull((String)languageId)) {
            languageId = defaultLanguageId;
        }
        Object[] contentAndImages = ActionUtil.getContentAndImages(ddmStructure, LocaleUtil.fromLanguageId((String)languageId), serviceContext);
        String content = (String)contentAndImages[0];
        HashMap images = (HashMap)contentAndImages[1];
        Boolean fileItemThresholdSizeExceeded = (Boolean)uploadPortletRequest.getAttribute("FILE_ITEM_THRESHOLD_SIZE_EXCEEDED");
        if (fileItemThresholdSizeExceeded != null && fileItemThresholdSizeExceeded.booleanValue()) {
            throw new ArticleContentSizeException();
        }
        String type = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"type");
        String templateId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"templateId");
        String layoutUuid = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutUuid");
        Layout targetLayout = JournalUtil.getArticleLayout(layoutUuid, groupId);
        if (targetLayout == null) {
            layoutUuid = null;
        }
        int displayDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        int expirationDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverExpire");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int reviewDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMonth");
        int reviewDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateDay");
        int reviewDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateYear");
        int reviewDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateHour");
        int reviewDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMinute");
        int reviewDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateAmPm");
        boolean neverReview = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverReview");
        if (reviewDateAmPm == 1) {
            reviewDateHour += 12;
        }
        boolean indexable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"indexable");
        boolean smallImage = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"smallImage");
        String smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        File smallFile = uploadPortletRequest.getFile("smallFile");
        String articleURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleURL");
        serviceContext.setAttribute("defaultLanguageId", (Serializable)((Object)defaultLanguageId));
        JournalArticle article = null;
        String oldUrlTitle = "";
        if (cmd.equals("add")) {
            HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
            titleMap.put(defaultLocale, title);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(defaultLocale, description);
            article = JournalArticleServiceUtil.addArticle((long)groupId, (long)folderId, (long)classNameId, (long)classPK, (String)articleId, (boolean)autoArticleId, titleMap, descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (Map)images, (String)articleURL, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection((PortletRequest)actionRequest, (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (int)-1);
        } else {
            JournalArticle curArticle = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            Fields newFields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
            Fields existingFields = JournalConverterUtil.getDDMFields((DDMStructure)ddmStructure, (Document)curArticle.getDocument());
            Fields mergedFields = DDMUtil.mergeFields((Fields)newFields, (Fields)existingFields);
            content = JournalConverterUtil.getContent((DDMStructure)ddmStructure, (Fields)mergedFields);
            article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
            Map titleMap = article.getTitleMap();
            Map descriptionMap = article.getDescriptionMap();
            String tempOldUrlTitle = article.getUrlTitle();
            if (cmd.equals("preview") || cmd.equals("update")) {
                titleMap.put(defaultLocale, title);
                descriptionMap.put(defaultLocale, description);
                article = JournalArticleServiceUtil.updateArticle((long)groupId, (long)folderId, (String)articleId, (double)version, (Map)titleMap, (Map)descriptionMap, (String)content, (String)type, (String)structureId, (String)templateId, (String)layoutUuid, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (boolean)neverExpire, (int)reviewDateMonth, (int)reviewDateDay, (int)reviewDateYear, (int)reviewDateHour, (int)reviewDateMinute, (boolean)neverReview, (boolean)indexable, (boolean)smallImage, (String)smallImageURL, (File)smallFile, (Map)images, (String)articleURL, (ServiceContext)serviceContext);
            } else if (cmd.equals("translate")) {
                article = JournalArticleServiceUtil.updateArticleTranslation((long)groupId, (String)articleId, (double)version, (Locale)toLocale, (String)title, (String)description, (String)content, (Map)images, (ServiceContext)serviceContext);
            }
            if (!tempOldUrlTitle.equals(article.getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
        }
        JournalUtil.addRecentArticle((PortletRequest)actionRequest, article);
        PortletPreferences portletPreferences = this.getStrictPortletSetup((PortletRequest)actionRequest);
        if (portletPreferences != null) {
            portletPreferences.setValue("groupId", String.valueOf(article.getGroupId()));
            portletPreferences.setValue("articleId", article.getArticleId());
            portletPreferences.store();
            String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
            this.updateContentSearch(actionRequest, portletResource, article.getArticleId());
        }
        return new Object[]{article, oldUrlTitle};
    }

    protected void updateContentSearch(ActionRequest actionRequest, String portletResource, String articleId) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        JournalContentSearchLocalServiceUtil.updateContentSearch((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)portletResource, (String)articleId, (boolean)true);
    }
}

