/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.diff.CompareVersionsException;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portlet.journal.service.JournalArticleServiceUtil;
import com.liferay.portlet.journal.util.JournalUtil;
import com.liferay.portlet.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portlet.wiki.NoSuchPageException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getArticle((PortletRequest)renderRequest);
            this.compareVersions(renderRequest, renderResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchPageException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e;
        }
        return actionMapping.findForward("portlet.journal.compare_versions");
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"articleId");
        double sourceVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterSourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterTargetVersion");
        String languageId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"languageId");
        String diffHtmlResults = null;
        try {
            diffHtmlResults = JournalUtil.diffHtml(groupId, articleId, sourceVersion, targetVersion, languageId, new PortletRequestModel((PortletRequest)resourceRequest, (PortletResponse)resourceResponse), themeDisplay);
        }
        catch (CompareVersionsException cve) {
            resourceRequest.setAttribute("DIFF_VERSION", (Object)cve.getVersion());
        }
        resourceRequest.setAttribute("DIFF_HTML_RESULTS", diffHtmlResults);
        PortletContext portletContext = portletConfig.getPortletContext();
        PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/html/taglib/ui/diff_version_comparator/diff_html.jsp");
        portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
    }

    protected void compareVersions(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"articleId");
        String sourceArticleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"sourceVersion");
        int index = sourceArticleId.lastIndexOf("_version_");
        if (index != -1) {
            sourceArticleId = sourceArticleId.substring(index + "_version_".length(), sourceArticleId.length());
        }
        double sourceVersion = GetterUtil.getDouble((String)sourceArticleId);
        String targetArticleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"targetVersion");
        index = targetArticleId.lastIndexOf("_version_");
        if (index != -1) {
            targetArticleId = targetArticleId.substring(index + "_version_".length(), targetArticleId.length());
        }
        double targetVersion = GetterUtil.getDouble((String)targetArticleId);
        if (sourceVersion == 0.0 && targetVersion == 0.0) {
            List sourceArticles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)0, (int)1, (OrderByComparator)new ArticleVersionComparator(false));
            JournalArticle sourceArticle = (JournalArticle)sourceArticles.get(0);
            sourceVersion = sourceArticle.getVersion();
            List targetArticles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)0, (int)1, (OrderByComparator)new ArticleVersionComparator(true));
            JournalArticle targetArticle = (JournalArticle)targetArticles.get(0);
            targetVersion = targetArticle.getVersion();
        }
        if (sourceVersion > targetVersion) {
            double tempVersion = targetVersion;
            targetVersion = sourceVersion;
            sourceVersion = tempVersion;
        }
        String languageId = this.getLanguageId(renderRequest, groupId, articleId, sourceVersion, targetVersion);
        String diffHtmlResults = null;
        try {
            diffHtmlResults = JournalUtil.diffHtml(groupId, articleId, sourceVersion, targetVersion, languageId, new PortletRequestModel((PortletRequest)renderRequest, (PortletResponse)renderResponse), themeDisplay);
        }
        catch (CompareVersionsException cve) {
            renderRequest.setAttribute("DIFF_VERSION", (Object)cve.getVersion());
        }
        renderRequest.setAttribute("DIFF_HTML_RESULTS", diffHtmlResults);
        renderRequest.setAttribute("SOURCE_VERSION", (Object)sourceVersion);
        renderRequest.setAttribute("TARGET_VERSION", (Object)targetVersion);
    }

    protected String getLanguageId(RenderRequest renderRequest, long groupId, String articleId, double sourceVersion, double targetVersion) throws Exception {
        JournalArticle sourceArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)sourceVersion);
        JournalArticle targetArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)targetVersion);
        HashSet<Locale> locales = new HashSet<Locale>();
        for (String locale : sourceArticle.getAvailableLanguageIds()) {
            locales.add(LocaleUtil.fromLanguageId((String)locale));
        }
        for (String locale : targetArticle.getAvailableLanguageIds()) {
            locales.add(LocaleUtil.fromLanguageId((String)locale));
        }
        String languageId = ParamUtil.get((PortletRequest)renderRequest, (String)"languageId", (String)targetArticle.getDefaultLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (!locales.contains(locale)) {
            languageId = targetArticle.getDefaultLanguageId();
        }
        renderRequest.setAttribute("AVAILABLE_LOCALES", locales);
        renderRequest.setAttribute("LANGUAGE_ID", (Object)languageId);
        return languageId;
    }
}

