/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imageuploader.action;

import com.liferay.portal.ImageTypeException;
import com.liferay.portal.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.FileExtensionException;
import com.liferay.portlet.documentlibrary.FileSizeException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileException;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UploadImageAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(UploadImageAction.class);

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long maxFileSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"maxFileSize");
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                if (uploadException.isExceededSizeLimit()) {
                    throw new FileSizeException(uploadException.getCause());
                }
                throw new PortalException(uploadException.getCause());
            }
            if (cmd.equals("add_temp")) {
                FileEntry tempImageFileEntry = this.addTempImageFileEntry((PortletRequest)actionRequest);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("tempImageFileName", tempImageFileEntry.getTitle());
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            } else {
                FileEntry fileEntry = null;
                boolean imageUploaded = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageUploaded");
                if (imageUploaded && (fileEntry = this.saveTempImageFileEntry(actionRequest)).getSize() > maxFileSize) {
                    throw new FileSizeException();
                }
                SessionMessages.add((PortletRequest)actionRequest, (String)"imageUploaded", (Object)fileEntry);
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            this.handleUploadException(actionRequest, actionResponse, cmd, maxFileSize, e);
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.image_uploader.view"));
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            String cmd = ParamUtil.getString((PortletRequest)resourceRequest, (String)"cmd");
            if (cmd.equals("get_temp")) {
                FileEntry tempFileEntry = this.getTempImageFileEntry((PortletRequest)resourceRequest);
                this.serveTempImageFile((MimeResponse)resourceResponse, tempFileEntry.getContentStream());
            }
        }
        catch (NoSuchFileEntryException nsfee) {
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileEntry addTempImageFileEntry(PortletRequest portletRequest) throws Exception {
        FileEntry fileEntry;
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String contentType = uploadPortletRequest.getContentType("fileName");
        if (!MimeTypesUtil.isWebImage((String)contentType)) {
            throw new ImageTypeException();
        }
        String fileName = uploadPortletRequest.getFileName("fileName");
        try {
            TempFileEntryUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFolderName(), (String)fileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        InputStream inputStream = null;
        try {
            inputStream = uploadPortletRequest.getFileAsStream("fileName");
            fileEntry = TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFolderName(), (String)fileName, (InputStream)inputStream, (String)contentType);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            throw throwable;
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
        return fileEntry;
    }

    protected FileEntry getTempImageFileEntry(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFolderName(), (String)this.getTempImageFileName(portletRequest));
    }

    protected String getTempImageFileName(PortletRequest portletRequest) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)"tempImageFileName");
    }

    protected String getTempImageFolderName() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getName();
    }

    protected void handleUploadException(ActionRequest actionRequest, ActionResponse actionResponse, String cmd, long maxFileSize, Exception e) throws Exception {
        if (e instanceof PrincipalException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            this.setForward((PortletRequest)actionRequest, "portal.error");
        } else if (e instanceof AntivirusScannerException || e instanceof FileExtensionException || e instanceof FileSizeException || e instanceof ImageTypeException || e instanceof NoSuchFileException || e instanceof UploadException) {
            if (cmd.equals("add_temp")) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                String errorMessage = "";
                if (e instanceof AntivirusScannerException) {
                    AntivirusScannerException ase = (AntivirusScannerException)e;
                    errorMessage = themeDisplay.translate(ase.getMessageKey());
                } else if (e instanceof FileExtensionException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])PropsValues.DL_FILE_EXTENSIONS, (String)",")});
                } else if (e instanceof FileSizeException) {
                    if (maxFileSize == 0L) {
                        maxFileSize = PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size");
                    }
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)maxFileSize, (Locale)themeDisplay.getLocale())});
                } else if (e instanceof ImageTypeException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-type");
                } else if (e instanceof NoSuchFileException || e instanceof UploadException) {
                    errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-uploading-your-file");
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("errorMessage", errorMessage);
                this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
        } else {
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileEntry saveTempImageFileEntry(ActionRequest actionRequest) throws Exception {
        tempFileEntry = null;
        tempImageStream = null;
        try {
            tempFileEntry = this.getTempImageFileEntry((PortletRequest)actionRequest);
            tempImageStream = tempFileEntry.getContentStream();
            imageBag = ImageToolUtil.read((InputStream)tempImageStream);
            renderedImage = imageBag.getRenderedImage();
            cropRegionJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"cropRegion");
            if (!Validator.isNotNull((String)cropRegionJSON)) ** GOTO lbl34
            jsonObject = JSONFactoryUtil.createJSONObject((String)cropRegionJSON);
            height = jsonObject.getInt("height");
            width = jsonObject.getInt("width");
            x = jsonObject.getInt("x");
            y = jsonObject.getInt("y");
            if (x == 0 && y == 0 && renderedImage.getHeight() == height && renderedImage.getWidth() == width) {
                var12_18 = tempFileEntry;
            }
            ** GOTO lbl-1000
        }
        catch (NoSuchFileEntryException nsfee) {
            try {
                throw new UploadException((Throwable)nsfee);
                catch (NoSuchRepositoryException nsre) {
                    throw new UploadException((Throwable)nsre);
                }
            }
            catch (Throwable var13_19) {
                StreamUtil.cleanUp((Closeable[])new Closeable[]{tempImageStream});
                throw var13_19;
            }
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{tempImageStream});
        return var12_18;
lbl-1000:
        // 1 sources

        {
            if (height + y > renderedImage.getHeight()) {
                height = renderedImage.getHeight() - y;
            }
            if (width + x > renderedImage.getWidth()) {
                width = renderedImage.getWidth() - x;
            }
            renderedImage = ImageToolUtil.crop((RenderedImage)renderedImage, (int)height, (int)width, (int)x, (int)y);
lbl34:
            // 2 sources

            bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
            themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            file = FileUtil.createTempFile((byte[])bytes);
            try {
                TempFileEntryUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFolderName(), (String)this.getTempImageFileName((PortletRequest)actionRequest));
            }
            catch (Exception e) {
                // empty catch block
            }
            var10_16 = TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)this.getTempImageFolderName(), (String)this.getTempImageFileName((PortletRequest)actionRequest), (File)file, (String)tempFileEntry.getMimeType());
        }
        StreamUtil.cleanUp((Closeable[])new Closeable[]{tempImageStream});
        return var10_16;
    }

    protected void serveTempImageFile(MimeResponse mimeResponse, InputStream tempImageStream) throws Exception {
        ImageBag imageBag = ImageToolUtil.read((InputStream)tempImageStream);
        byte[] bytes = ImageToolUtil.getBytes((RenderedImage)imageBag.getRenderedImage(), (String)imageBag.getType());
        String contentType = MimeTypesUtil.getExtensionContentType((String)imageBag.getType());
        mimeResponse.setContentType(contentType);
        PortletResponseUtil.write((MimeResponse)mimeResponse, (byte[])bytes);
    }
}

