/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallerydisplay.context;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.DLPortletInstanceSettings;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IGConfigurationDisplayContext {
    private List<KeyValuePair> _availableMimeTypes;
    private List<KeyValuePair> _currentMimeTypes;
    private DLPortletInstanceSettings _dlPortletInstanceSettings;
    private ThemeDisplay _themeDisplay;

    public IGConfigurationDisplayContext(HttpServletRequest request, DLPortletInstanceSettings dlPortletInstanceSettings) {
        this._dlPortletInstanceSettings = dlPortletInstanceSettings;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<KeyValuePair> getAvailableMimeTypes() {
        if (this._availableMimeTypes == null) {
            this._populateMimeTypes();
        }
        return this._availableMimeTypes;
    }

    public List<KeyValuePair> getCurrentMimeTypes() {
        if (this._currentMimeTypes == null) {
            this._populateMimeTypes();
        }
        return this._currentMimeTypes;
    }

    private void _populateMimeTypes() {
        Object[] mediaGalleryMimeTypes = this._dlPortletInstanceSettings.getMimeTypes();
        this._currentMimeTypes = new ArrayList<KeyValuePair>();
        for (String string : mediaGalleryMimeTypes) {
            this._currentMimeTypes.add(new KeyValuePair(string, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)string)));
        }
        this._availableMimeTypes = new ArrayList<KeyValuePair>();
        Set allMediaGalleryMimeTypes = DLUtil.getAllMediaGalleryMimeTypes();
        for (String mimeType : allMediaGalleryMimeTypes) {
            if (Arrays.binarySearch(mediaGalleryMimeTypes, mimeType) >= 0) continue;
            this._availableMimeTypes.add(new KeyValuePair(mimeType, LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)mimeType)));
        }
    }
}

