/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.servlet.JSPSupportServlet;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormJSONDeserializerUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDSerializerUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStorageLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMFieldsCounter;
import com.liferay.portlet.dynamicdatamapping.util.DDMXSD;
import com.liferay.util.freemarker.FreeMarkerTaglibFactoryUtil;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateHashModel;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class DDMXSDImpl
implements DDMXSD {
    private static final String _DEFAULT_NAMESPACE = "alloy";
    private static final String _DEFAULT_READ_ONLY_NAMESPACE = "readonly";
    private static final String _TPL_EXT = ".ftl";
    private static final String _TPL_PATH = "com/liferay/portlet/dynamicdatamapping/dependencies/";
    private TemplateResource _defaultReadOnlyTemplateResource;
    private TemplateResource _defaultTemplateResource;

    public DDMXSDImpl() {
        String defaultTemplateId = "com/liferay/portlet/dynamicdatamapping/dependencies/alloy/text.ftl";
        URL defaultTemplateURL = this.getResource(defaultTemplateId);
        this._defaultTemplateResource = new URLTemplateResource(defaultTemplateId, defaultTemplateURL);
        String defaultReadOnlyTemplateId = "com/liferay/portlet/dynamicdatamapping/dependencies/readonly/default.ftl";
        URL defaultReadOnlyTemplateURL = this.getResource(defaultReadOnlyTemplateId);
        this._defaultReadOnlyTemplateResource = new URLTemplateResource(defaultReadOnlyTemplateId, defaultReadOnlyTemplateURL);
    }

    public String getFieldHTML(HttpServletRequest request, HttpServletResponse response, Element element, Fields fields, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        Map<String, Object> freeMarkerContext = this.getFreeMarkerContext(request, response, portletNamespace, namespace, element, locale);
        if (fields != null) {
            freeMarkerContext.put("fields", fields);
        }
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        int fieldRepetition = 1;
        int offset = 0;
        DDMFieldsCounter ddmFieldsCounter = this.getFieldsCounter(request, response, fields, portletNamespace, namespace);
        String name = element.attributeValue("name");
        String fieldDisplayValue = this.getFieldsDisplayValue(request, response, fields);
        Object[] fieldsDisplayValues = this.getFieldsDisplayValues(fieldDisplayValue);
        boolean fieldDisplayable = ArrayUtil.contains((Object[])fieldsDisplayValues, (Object)name);
        if (fieldDisplayable) {
            Map parentFieldStructure = (Map)freeMarkerContext.get("parentFieldStructure");
            String parentFieldName = (String)parentFieldStructure.get("name");
            offset = this.getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get(name));
            if (offset == fieldsDisplayValues.length) {
                return "";
            }
            fieldRepetition = this.countFieldRepetition((String[])fieldsDisplayValues, parentFieldName, offset);
        }
        StringBundler sb = new StringBundler(fieldRepetition);
        while (fieldRepetition > 0) {
            offset = this.getFieldOffset((String[])fieldsDisplayValues, name, ddmFieldsCounter.get(name));
            String fieldNamespace = StringUtil.randomId();
            if (fieldDisplayable) {
                fieldNamespace = this.getFieldNamespace(fieldDisplayValue, ddmFieldsCounter, offset);
            }
            fieldStructure.put("fieldNamespace", fieldNamespace);
            fieldStructure.put("valueIndex", ddmFieldsCounter.get(name));
            if (fieldDisplayable) {
                ddmFieldsCounter.incrementKey(name);
            }
            String childrenHTML = this.getHTML(request, response, element, fields, portletNamespace, namespace, mode, readOnly, locale);
            fieldStructure.put("children", childrenHTML);
            boolean disabled = GetterUtil.getBoolean(fieldStructure.get("disabled"), (boolean)false);
            if (disabled) {
                readOnly = true;
            }
            sb.append(this.processFTL(request, response, element, mode, readOnly, freeMarkerContext));
            --fieldRepetition;
        }
        return sb.toString();
    }

    public String getFieldHTMLByName(HttpServletRequest request, HttpServletResponse response, long classNameId, long classPK, String fieldName, Fields fields, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        String xsd = this.getXSD(classNameId, classPK);
        Document document = SAXReaderUtil.read((String)xsd);
        String xPathExpression = "//dynamic-element[@name=".concat(HtmlUtil.escapeXPathAttribute((String)fieldName)).concat("]");
        XPath xPathSelector = SAXReaderUtil.createXPath((String)xPathExpression);
        Node node = xPathSelector.selectSingleNode((Object)document.getRootElement());
        Element element = (Element)node.asXPathResult(node.getParent());
        return this.getFieldHTML(request, response, element, fields, portletNamespace, namespace, mode, readOnly, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, DDMStructure ddmStructure, Fields fields, String portletNamespace, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(request, response, ddmStructure.getDefinition(), fields, portletNamespace, namespace, readOnly, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, DDMTemplate ddmTemplate, Fields fields, String portletNamespace, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(request, response, ddmTemplate.getScript(), fields, portletNamespace, namespace, ddmTemplate.getMode(), readOnly, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, Element element, Fields fields, String portletNamespace, Locale locale) throws Exception {
        return this.getHTML(request, response, element, fields, portletNamespace, "", null, false, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, Element element, Fields fields, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        List dynamicElementElements = element.elements("dynamic-element");
        StringBundler sb = new StringBundler(dynamicElementElements.size());
        for (Element dynamicElementElement : dynamicElementElements) {
            sb.append(this.getFieldHTML(request, response, dynamicElementElement, fields, portletNamespace, namespace, mode, readOnly, locale));
        }
        return sb.toString();
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, Element element, String portletNamespace, Locale locale) throws Exception {
        return this.getHTML(request, response, element, null, portletNamespace, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, String xml, Fields fields, String portletNamespace, Locale locale) throws Exception {
        return this.getHTML(request, response, xml, fields, portletNamespace, "", locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, String xml, Fields fields, String portletNamespace, String namespace, boolean readOnly, Locale locale) throws Exception {
        return this.getHTML(request, response, xml, fields, portletNamespace, namespace, null, readOnly, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, String xml, Fields fields, String portletNamespace, String namespace, Locale locale) throws Exception {
        return this.getHTML(request, response, xml, fields, portletNamespace, namespace, false, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, String xml, Fields fields, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        Document document = SAXReaderUtil.read((String)xml);
        return this.getHTML(request, response, document.getRootElement(), fields, portletNamespace, namespace, mode, readOnly, locale);
    }

    public String getHTML(HttpServletRequest request, HttpServletResponse response, String xml, String portletNamespace, Locale locale) throws Exception {
        return this.getHTML(request, response, xml, null, locale);
    }

    public JSONArray getJSONArray(DDMStructure structure, String xsd) throws PortalException {
        JSONArray jsonArray = null;
        jsonArray = Validator.isNull((String)xsd) ? this.getJSONArray(structure.getDefinition()) : this.getJSONArray(xsd);
        this.addStructureFieldAttributes(structure, jsonArray);
        return jsonArray;
    }

    public JSONArray getJSONArray(Document document) throws PortalException {
        return this.getJSONArray(document.getRootElement());
    }

    public JSONArray getJSONArray(Element element) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Document document = element.getDocument();
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)document.asXML());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONObject localizationMapJSONObject = JSONFactoryUtil.createJSONObject();
            for (Attribute attribute : dynamicElementElement.attributes()) {
                jsonObject.put(attribute.getName(), attribute.getValue());
            }
            jsonObject.put("autoGeneratedName", false);
            jsonObject.put("id", dynamicElementElement.attributeValue("name"));
            String type = jsonObject.getString("type");
            List metadataElements = dynamicElementElement.elements("meta-data");
            for (Element metadataElement : metadataElements) {
                if (metadataElement == null) continue;
                String locale = metadataElement.attributeValue("locale");
                JSONObject localeMap = JSONFactoryUtil.createJSONObject();
                for (Element metadataEntryElement : metadataElement.elements()) {
                    String attributeName = metadataEntryElement.attributeValue("name");
                    String attributeValue = metadataEntryElement.getTextTrim();
                    this.putMetadataValue(localeMap, attributeName, attributeValue, type);
                    if (!defaultLanguageId.equals(locale)) continue;
                    this.putMetadataValue(jsonObject, attributeName, attributeValue, type);
                }
                localizationMapJSONObject.put(locale, localeMap);
            }
            jsonObject.put("localizationMap", localizationMapJSONObject);
            JSONArray hiddenAttributesJSONArray = JSONFactoryUtil.createJSONArray();
            if (type.equals("checkbox")) {
                hiddenAttributesJSONArray.put("required");
            }
            hiddenAttributesJSONArray.put("readOnly");
            jsonObject.put("hiddenAttributes", hiddenAttributesJSONArray);
            String key = "fields";
            if (type.equals("radio") || type.equals("select")) {
                key = "options";
            }
            jsonObject.put(key, this.getJSONArray(dynamicElementElement));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public JSONArray getJSONArray(String xml) throws PortalException {
        try {
            return this.getJSONArray(SAXReaderUtil.read((String)xml));
        }
        catch (DocumentException de) {
            throw new SystemException();
        }
    }

    public String getSimpleFieldHTML(HttpServletRequest request, HttpServletResponse response, Element element, Field field, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        Map<String, Object> freeMarkerContext = this.getFreeMarkerContext(request, response, portletNamespace, namespace, element, locale);
        freeMarkerContext.put("ignoreRepeatable", Boolean.TRUE);
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        DDMFieldsCounter ddmFieldsCounter = this.getFieldsCounter(request, response, null, portletNamespace, namespace);
        String name = element.attributeValue("name");
        if (field != null && Validator.isNotNull((Object)field.getValue())) {
            Fields fields = new Fields();
            fields.put(field);
            freeMarkerContext.put("fields", fields);
        }
        fieldStructure.put("fieldNamespace", StringUtil.randomId());
        fieldStructure.put("valueIndex", ddmFieldsCounter.get(name));
        List dynamicElementElements = element.elements("dynamic-element");
        StringBundler sb = new StringBundler(dynamicElementElements.size());
        for (Element dynamicElementElement : dynamicElementElements) {
            String type = dynamicElementElement.attributeValue("type");
            if (!type.equals("option")) {
                sb.append("");
                continue;
            }
            sb.append(this.getSimpleFieldHTML(request, response, dynamicElementElement, field, portletNamespace, namespace, mode, readOnly, locale));
        }
        fieldStructure.put("children", sb.toString());
        return this.processFTL(request, response, element, mode, readOnly, freeMarkerContext);
    }

    public String getSimpleFieldHTMLByName(HttpServletRequest request, HttpServletResponse response, long classNameId, long classPK, Field field, String portletNamespace, String namespace, String mode, boolean readOnly, Locale locale) throws Exception {
        String xsd = this.getXSD(classNameId, classPK);
        Document document = SAXReaderUtil.read((String)xsd);
        String xPathExpression = "//dynamic-element[@name=".concat(HtmlUtil.escapeXPathAttribute((String)field.getName())).concat("]");
        XPath xPathSelector = SAXReaderUtil.createXPath((String)xPathExpression);
        Node node = xPathSelector.selectSingleNode((Object)document.getRootElement());
        Element element = (Element)node.asXPathResult(node.getParent());
        return this.getSimpleFieldHTML(request, response, element, field, portletNamespace, namespace, mode, readOnly, locale);
    }

    public String getXSD(long classNameId, long classPK) throws PortalException {
        if (classNameId <= 0L || classPK <= 0L) {
            return null;
        }
        long ddmStructureClassNameId = PortalUtil.getClassNameId(DDMStructure.class);
        long ddmTemplateClassNameId = PortalUtil.getClassNameId(DDMTemplate.class);
        if (classNameId == ddmStructureClassNameId) {
            DDMStructure structure = DDMStructureLocalServiceUtil.getStructure((long)classPK);
            DDMForm ddmForm = structure.getFullHierarchyDDMForm();
            return DDMFormXSDSerializerUtil.serialize((DDMForm)ddmForm);
        }
        if (classNameId == ddmTemplateClassNameId) {
            DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)classPK);
            return template.getScript();
        }
        return null;
    }

    public String getXSD(String json) throws PortalException {
        DDMForm ddmForm = DDMFormJSONDeserializerUtil.deserialize((String)json);
        return DDMFormXSDSerializerUtil.serialize((DDMForm)ddmForm);
    }

    protected JSONArray addStructureFieldAttributes(DDMStructure structure, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String fieldName = jsonObject.getString("name");
            jsonObject.put("readOnlyAttributes", this.getStructureFieldReadOnlyAttributes(structure, fieldName));
        }
        return jsonArray;
    }

    protected int countFieldRepetition(String[] fieldsDisplayValues, String parentFieldName, int offset) {
        int total = 0;
        String fieldName = fieldsDisplayValues[offset];
        while (offset < fieldsDisplayValues.length) {
            String fieldNameValue = fieldsDisplayValues[offset];
            if (fieldNameValue.equals(fieldName)) {
                ++total;
            }
            if (fieldNameValue.equals(parentFieldName)) break;
            ++offset;
        }
        return total;
    }

    protected Map<String, Object> getFieldContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace, Element dynamicElementElement, Locale locale) {
        String editingLanguageId;
        String name;
        Map<String, Map<String, Object>> fieldsContext = this.getFieldsContext(request, response, portletNamespace, namespace);
        Map<String, Object> fieldContext = fieldsContext.get(name = dynamicElementElement.attributeValue("name"));
        if (fieldContext != null) {
            return fieldContext;
        }
        Document document = dynamicElementElement.getDocument();
        Object[] availableLanguageIds = LocalizationUtil.getAvailableLanguageIds((Document)document);
        String defaultLanguageId = LocalizationUtil.getDefaultLanguageId((Document)document);
        String structureLanguageId = editingLanguageId = LocaleUtil.toLanguageId((Locale)locale);
        if (!ArrayUtil.contains((Object[])availableLanguageIds, (Object)editingLanguageId)) {
            structureLanguageId = defaultLanguageId;
        }
        Element metadataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + structureLanguageId + "']");
        fieldContext = new HashMap<String, Object>();
        if (metadataElement != null) {
            for (Element metadataEntry : metadataElement.elements()) {
                fieldContext.put(metadataEntry.attributeValue("name"), metadataEntry.getText());
            }
        }
        for (Attribute attribute : dynamicElementElement.attributes()) {
            fieldContext.put(attribute.getName(), attribute.getValue());
        }
        boolean localizable = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("localizable"), (boolean)true);
        if (!localizable && !editingLanguageId.equals(defaultLanguageId)) {
            fieldContext.put("disabled", Boolean.TRUE.toString());
        }
        fieldContext.put("fieldNamespace", StringUtil.randomId());
        boolean checkRequired = GetterUtil.getBoolean((Object)request.getAttribute("checkRequired"), (boolean)true);
        if (!checkRequired) {
            fieldContext.put("required", Boolean.FALSE.toString());
        }
        fieldsContext.put(name, fieldContext);
        return fieldContext;
    }

    protected String getFieldNamespace(String fieldDisplayValue, DDMFieldsCounter ddmFieldsCounter, int offset) {
        String[] fieldsDisplayValues = StringUtil.split((String)fieldDisplayValue);
        String fieldsDisplayValue = fieldsDisplayValues[offset];
        return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
    }

    protected int getFieldOffset(String[] fieldsDisplayValues, String name, int index) {
        int offset;
        for (offset = 0; !(offset >= fieldsDisplayValues.length || name.equals(fieldsDisplayValues[offset]) && --index < 0); ++offset) {
        }
        return offset;
    }

    protected Map<String, Map<String, Object>> getFieldsContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace) {
        String fieldsContextKey = portletNamespace + namespace + "fieldsContext";
        HashMap fieldsContext = (HashMap)request.getAttribute(fieldsContextKey);
        if (fieldsContext == null) {
            fieldsContext = new HashMap();
            request.setAttribute(fieldsContextKey, fieldsContext);
        }
        return fieldsContext;
    }

    protected DDMFieldsCounter getFieldsCounter(HttpServletRequest request, HttpServletResponse response, Fields fields, String portletNamespace, String namespace) {
        String fieldsCounterKey = portletNamespace + namespace + "fieldsCount";
        DDMFieldsCounter ddmFieldsCounter = (DDMFieldsCounter)request.getAttribute(fieldsCounterKey);
        if (ddmFieldsCounter == null) {
            ddmFieldsCounter = new DDMFieldsCounter();
            request.setAttribute(fieldsCounterKey, (Object)ddmFieldsCounter);
        }
        return ddmFieldsCounter;
    }

    protected String getFieldsDisplayValue(HttpServletRequest request, HttpServletResponse response, Fields fields) {
        Field fieldsDisplayField;
        String defaultFieldsDisplayValue = null;
        if (fields != null && (fieldsDisplayField = fields.get("_fieldsDisplay")) != null) {
            defaultFieldsDisplayValue = (String)((Object)fieldsDisplayField.getValue());
        }
        return ParamUtil.getString((HttpServletRequest)request, (String)"_fieldsDisplay", defaultFieldsDisplayValue);
    }

    protected String[] getFieldsDisplayValues(String fieldDisplayValue) {
        ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
        for (String value : StringUtil.split((String)fieldDisplayValue)) {
            String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
            fieldsDisplayValues.add(fieldName);
        }
        return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
    }

    protected Map<String, Object> getFreeMarkerContext(HttpServletRequest request, HttpServletResponse response, String portletNamespace, String namespace, Element dynamicElementElement, Locale locale) {
        HashMap<String, Object> freeMarkerContext = new HashMap<String, Object>();
        Map<String, Object> fieldContext = this.getFieldContext(request, response, portletNamespace, namespace, dynamicElementElement, locale);
        Map<Object, Object> parentFieldContext = new HashMap();
        Element parentElement = dynamicElementElement.getParent();
        if (parentElement != null) {
            parentFieldContext = this.getFieldContext(request, response, portletNamespace, namespace, parentElement, locale);
        }
        freeMarkerContext.put("fieldStructure", fieldContext);
        freeMarkerContext.put("namespace", namespace);
        freeMarkerContext.put("parentFieldStructure", parentFieldContext);
        freeMarkerContext.put("portletNamespace", portletNamespace);
        freeMarkerContext.put("requestedLanguageDir", LanguageUtil.get((Locale)locale, (String)"lang.dir"));
        freeMarkerContext.put("requestedLocale", locale);
        return freeMarkerContext;
    }

    protected URL getResource(String name) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResource(name);
    }

    protected JSONArray getStructureFieldReadOnlyAttributes(DDMStructure structure, String fieldName) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        try {
            if (DDMStorageLinkLocalServiceUtil.getStructureStorageLinksCount((long)structure.getStructureId()) > 0) {
                jsonArray.put("name");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return jsonArray;
    }

    protected String processFTL(HttpServletRequest request, HttpServletResponse response, Element element, String mode, boolean readOnly, Map<String, Object> freeMarkerContext) throws Exception {
        String fieldNamespace = element.attributeValue("fieldNamespace", _DEFAULT_NAMESPACE);
        TemplateResource templateResource = this._defaultTemplateResource;
        Map fieldStructure = (Map)freeMarkerContext.get("fieldStructure");
        boolean fieldReadOnly = GetterUtil.getBoolean(fieldStructure.get("readOnly"));
        if (fieldReadOnly && Validator.isNotNull((String)mode) && StringUtil.equalsIgnoreCase((String)mode, (String)"edit") || readOnly) {
            fieldNamespace = _DEFAULT_READ_ONLY_NAMESPACE;
            templateResource = this._defaultReadOnlyTemplateResource;
        }
        String type = element.attributeValue("type");
        String templateName = StringUtil.replaceFirst((String)type, (String)fieldNamespace.concat("-"), (String)"");
        StringBundler resourcePath = new StringBundler(5);
        resourcePath.append(_TPL_PATH);
        resourcePath.append(StringUtil.toLowerCase((String)fieldNamespace));
        resourcePath.append('/');
        resourcePath.append(templateName);
        resourcePath.append(_TPL_EXT);
        String resource = resourcePath.toString();
        URL url = this.getResource(resource);
        if (url != null) {
            templateResource = new URLTemplateResource(resource, url);
        }
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + resource);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)false);
        for (Map.Entry<String, Object> entry : freeMarkerContext.entrySet()) {
            template.put(entry.getKey(), entry.getValue());
        }
        return this.processFTL(request, response, template);
    }

    protected String processFTL(HttpServletRequest request, HttpServletResponse response, Template template) throws Exception {
        template.prepare(request);
        UnsyncStringWriter writer = new UnsyncStringWriter();
        TemplateHashModel portalTaglib = FreeMarkerTaglibFactoryUtil.createTaglibFactory((ServletContext)request.getServletContext());
        template.put("PortalJspTagLibs", (Object)portalTaglib);
        JSPSupportServlet genericServlet = new JSPSupportServlet(request.getServletContext());
        ServletContextHashModel servletContextHashModel = new ServletContextHashModel((GenericServlet)genericServlet, ObjectWrapper.DEFAULT_WRAPPER);
        template.put("Application", (Object)servletContextHashModel);
        HttpRequestHashModel httpRequestHashModel = new HttpRequestHashModel(request, response, ObjectWrapper.DEFAULT_WRAPPER);
        template.put("Request", (Object)httpRequestHashModel);
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    protected void putMetadataValue(JSONObject jsonObject, String attributeName, String attributeValue, String type) {
        if ((type.equals("radio") || type.equals("select")) && attributeName.equals("predefinedValue")) {
            try {
                jsonObject.put(attributeName, JSONFactoryUtil.createJSONArray((String)attributeValue));
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        jsonObject.put(attributeName, attributeValue);
    }
}

