/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XMLSchema;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portlet.dynamicdatamapping.StructureDefinitionException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMXML;
import com.liferay.util.xml.XMLFormatter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

@DoPrivileged
public class DDMXMLImpl
implements DDMXML {
    private static final String _AVAILABLE_LOCALES = "available-locales";
    private static final String _DEFAULT_LOCALE = "default-locale";
    private static final String _DYNAMIC_ELEMENT = "dynamic-element";
    private static final String _LOCALE = "locale";
    private static final String _XML_INDENT = "  ";
    private static Log _log = LogFactoryUtil.getLog(DDMXMLImpl.class);
    private XMLSchema _xmlSchema;

    public String formatXML(Document document) {
        try {
            return document.formattedString(_XML_INDENT);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public String formatXML(String xml) {
        try {
            xml = StringUtil.replace((String)xml, (String)"&#", (String)"[$SPECIAL_CHARACTER$]");
            xml = XMLFormatter.toString((String)xml, (String)_XML_INDENT);
            xml = StringUtil.replace((String)xml, (String)"[$SPECIAL_CHARACTER$]", (String)"&#");
            return xml;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        catch (org.dom4j.DocumentException de) {
            throw new SystemException((Throwable)de);
        }
    }

    public Fields getFields(DDMStructure structure, String xml) throws PortalException {
        return this.getFields(structure, null, xml, null);
    }

    public Fields getFields(DDMStructure structure, XPath xPath, String xml, List<String> fieldNames) throws PortalException {
        Document document = null;
        try {
            document = SAXReaderUtil.read((String)xml);
        }
        catch (DocumentException de) {
            return null;
        }
        if (xPath != null && !xPath.booleanValueOf((Object)document)) {
            return null;
        }
        Fields fields = new Fields();
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements(_DYNAMIC_ELEMENT);
        for (Element dynamicElementElement : dynamicElementElements) {
            String fieldName = dynamicElementElement.attributeValue("name");
            if (!structure.hasField(fieldName) || fieldNames != null && !fieldNames.contains(fieldName)) continue;
            String fieldDataType = structure.getFieldDataType(fieldName);
            List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String fieldValue = dynamicContentElement.getText();
                String languageId = dynamicContentElement.attributeValue("language-id");
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)fieldValue);
                Field field = fields.get(fieldName);
                if (field == null) {
                    field = new Field();
                    String defaultLanguageId = dynamicElementElement.attributeValue("default-language-id");
                    Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
                    field.setDefaultLocale(defaultLocale);
                    field.setDDMStructureId(structure.getStructureId());
                    field.setName(fieldName);
                    field.setValue(locale, fieldValueSerializable);
                    fields.put(field);
                    continue;
                }
                field.addValue(locale, fieldValueSerializable);
            }
        }
        return fields;
    }

    public String getXML(Document document, Fields fields) {
        Element rootElement = null;
        try {
            if (document != null) {
                rootElement = document.getRootElement();
            } else {
                document = SAXReaderUtil.createDocument();
                rootElement = document.addElement("root");
            }
            Iterator itr = fields.iterator(true);
            while (itr.hasNext()) {
                Field field = (Field)itr.next();
                List<Node> nodes = this.getElementsByName(document, field.getName());
                for (Node node : nodes) {
                    document.remove(node);
                }
                this.appendField(rootElement, field);
            }
            return document.formattedString();
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public String getXML(Fields fields) {
        return this.getXML(null, fields);
    }

    public void setXMLSchema(XMLSchema xmlSchema) {
        this._xmlSchema = xmlSchema;
    }

    public String updateXMLDefaultLocale(String xml, Locale contentDefaultLocale, Locale contentNewDefaultLocale) {
        try {
            if (LocaleUtil.equals((Locale)contentDefaultLocale, (Locale)contentNewDefaultLocale)) {
                return xml;
            }
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            Attribute availableLocalesAttribute = rootElement.attribute(_AVAILABLE_LOCALES);
            String contentNewDefaultLanguageId = LocaleUtil.toLanguageId((Locale)contentNewDefaultLocale);
            String availableLocalesAttributeValue = availableLocalesAttribute.getValue();
            if (!availableLocalesAttributeValue.contains(contentNewDefaultLanguageId)) {
                StringBundler sb = new StringBundler(3);
                sb.append(availableLocalesAttribute.getValue());
                sb.append(",");
                sb.append(contentNewDefaultLanguageId);
                availableLocalesAttribute.setValue(sb.toString());
            }
            Attribute defaultLocaleAttribute = rootElement.attribute(_DEFAULT_LOCALE);
            defaultLocaleAttribute.setValue(contentNewDefaultLanguageId);
            this.fixElementsDefaultLocale(rootElement, contentDefaultLocale, contentNewDefaultLocale);
            return document.formattedString();
        }
        catch (DocumentException de) {
            throw new SystemException((Throwable)de);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public String validateXML(String xml) throws PortalException {
        try {
            Document document = SAXReaderUtil.read((String)xml, (XMLSchema)this._xmlSchema);
            return document.asXML();
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid XML content " + e.getMessage()), (Throwable)e);
            }
            throw new StructureDefinitionException();
        }
    }

    protected void appendField(Element element, Field field) {
        Element dynamicElementElement = element.addElement(_DYNAMIC_ELEMENT);
        dynamicElementElement.addAttribute("default-language-id", LocaleUtil.toLanguageId((Locale)field.getDefaultLocale()));
        dynamicElementElement.addAttribute("name", field.getName());
        for (Locale locale : field.getAvailableLocales()) {
            List values = field.getValues(locale);
            for (Serializable value : values) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
                this.updateField(dynamicContentElement, value);
            }
        }
    }

    protected void fixElementsDefaultLocale(Element element, Locale contentDefaultLocale, Locale contentNewDefaultLocale) {
        for (Element dynamicElementElement : element.elements(_DYNAMIC_ELEMENT)) {
            Element importMetaDataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + contentNewDefaultLocale.toString() + "']");
            if (importMetaDataElement == null) {
                Element metaDataElement = (Element)dynamicElementElement.selectSingleNode("meta-data[@locale='" + contentDefaultLocale.toString() + "']");
                Element copiedMetadataElement = metaDataElement.createCopy();
                Attribute localeAttribute = copiedMetadataElement.attribute(_LOCALE);
                String contentNewDefaultLanguageId = LocaleUtil.toLanguageId((Locale)contentNewDefaultLocale);
                localeAttribute.setValue(contentNewDefaultLanguageId);
                dynamicElementElement.add(copiedMetadataElement);
            }
            this.fixElementsDefaultLocale(dynamicElementElement, contentDefaultLocale, contentNewDefaultLocale);
        }
    }

    protected List<Node> getElementsByName(Document document, String name) {
        name = HtmlUtil.escapeXPathAttribute((String)name);
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element[@name=".concat(name).concat("]"));
        return xPathSelector.selectNodes((Object)document);
    }

    protected void updateField(Element dynamicContentElement, Serializable fieldValue) {
        dynamicContentElement.clearContent();
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            fieldValue = Long.valueOf(valueDate.getTime());
        }
        String valueString = String.valueOf(fieldValue);
        dynamicContentElement.addCDATA(valueString.trim());
    }
}

