/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMTemplateHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DDMTemplateHelperImpl
implements DDMTemplateHelper {
    private static final String _TEMPLATE_CONTENT = "# Placeholder";
    private static final String _TEMPLATE_ID = "0";

    public DDMStructure fetchStructure(DDMTemplate template) {
        try {
            long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
            if (template.getClassNameId() == classNameId) {
                return DDMStructureLocalServiceUtil.fetchDDMStructure((long)template.getClassPK());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getAutocompleteJSON(HttpServletRequest request, String language) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        JSONObject typesJSONObject = JSONFactoryUtil.createJSONObject();
        JSONObject variablesJSONObject = JSONFactoryUtil.createJSONObject();
        for (TemplateVariableDefinition templateVariableDefinition : this.getAutocompleteTemplateVariableDefinitions(request, language)) {
            Class clazz = templateVariableDefinition.getClazz();
            if (clazz == null) {
                variablesJSONObject.put(templateVariableDefinition.getName(), "");
                continue;
            }
            if (!typesJSONObject.has(clazz.getName())) {
                typesJSONObject.put(clazz.getName(), this.getAutocompleteClassJSONObject(clazz));
            }
            variablesJSONObject.put(templateVariableDefinition.getName(), this.getAutocompleteVariableJSONObject(clazz));
        }
        jsonObject.put("types", typesJSONObject);
        jsonObject.put("variables", variablesJSONObject);
        return jsonObject.toString();
    }

    public boolean isAutocompleteEnabled(String language) {
        return language.equals("ftl") || language.equals("vm");
    }

    protected JSONObject getAutocompleteClassJSONObject(Class<?> clazz) {
        JSONObject typeJSONObject = JSONFactoryUtil.createJSONObject();
        for (Field field : clazz.getFields()) {
            JSONObject fieldJSONObject = this.getAutocompleteVariableJSONObject(field.getType());
            typeJSONObject.put(field.getName(), fieldJSONObject);
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            Class<?>[] parameterTypes;
            JSONObject methodJSONObject = JSONFactoryUtil.createJSONObject();
            JSONArray parametersTypesArray = JSONFactoryUtil.createJSONArray();
            for (Class<?> parameterType : parameterTypes = ((Method)accessibleObject).getParameterTypes()) {
                parametersTypesArray.put(parameterType.getCanonicalName());
            }
            methodJSONObject.put("argumentTypes", parametersTypesArray);
            Class<?> returnTypeClass = ((Method)accessibleObject).getReturnType();
            methodJSONObject.put("returnType", returnTypeClass.getName());
            methodJSONObject.put("type", "Method");
            typeJSONObject.put(((Method)accessibleObject).getName(), methodJSONObject);
        }
        return typeJSONObject;
    }

    protected List<TemplateVariableDefinition> getAutocompleteTemplateVariableDefinitions(HttpServletRequest request, String language) throws Exception {
        if (!this.isAutocompleteEnabled(language)) {
            return Collections.emptyList();
        }
        LinkedHashSet<TemplateVariableDefinition> templateVariableDefinitions = new LinkedHashSet<TemplateVariableDefinition>();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMTemplate ddmTemplate = (DDMTemplate)request.getAttribute("DYNAMIC_DATA_MAPPING_TEMPLATE");
        long classPK = BeanParamUtil.getLong((Object)ddmTemplate, (HttpServletRequest)request, (String)"classPK");
        long classNameId = BeanParamUtil.getLong((Object)ddmTemplate, (HttpServletRequest)request, (String)"classNameId");
        if (classPK > 0L) {
            DDMStructure ddmStructure = DDMStructureServiceUtil.getStructure((long)classPK);
            classNameId = ddmStructure.getClassNameId();
        } else if (ddmTemplate != null) {
            classNameId = ddmTemplate.getClassNameId();
        }
        Map<String, TemplateVariableGroup> templateVariableGroups = TemplateContextHelper.getTemplateVariableGroups(classNameId, classPK, language, themeDisplay.getLocale());
        for (TemplateVariableGroup templateVariableGroup : templateVariableGroups.values()) {
            if (!templateVariableGroup.isAutocompleteEnabled()) continue;
            templateVariableDefinitions.addAll(templateVariableGroup.getTemplateVariableDefinitions());
        }
        StringTemplateResource templateResource = new StringTemplateResource(_TEMPLATE_ID, _TEMPLATE_CONTENT);
        Template template = TemplateManagerUtil.getTemplate((String)language, (TemplateResource)templateResource, (boolean)false);
        for (String key : template.getKeys()) {
            Object value = template.get(key);
            if (value == null) continue;
            TemplateVariableDefinition variableDefinition = new TemplateVariableDefinition(key, value.getClass(), key, (String)null);
            templateVariableDefinitions.add(variableDefinition);
        }
        return new ArrayList<TemplateVariableDefinition>(templateVariableDefinitions);
    }

    protected JSONObject getAutocompleteVariableJSONObject(Class<?> clazz) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("type", clazz.getName());
        return jsonObject;
    }
}

