/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDMIndexer;
import java.io.Serializable;
import java.text.Format;
import java.util.Date;
import java.util.Locale;

public class DDMIndexerImpl
implements DDMIndexer {
    private static Log _log = LogFactoryUtil.getLog(DDMIndexerImpl.class);

    public void addAttributes(Document document, DDMStructure ddmStructure, Fields fields) {
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType)) continue;
                for (Locale locale : LanguageUtil.getAvailableLocales()) {
                    String name = this.encodeName(ddmStructure.getStructureId(), field.getName(), locale);
                    Serializable value = field.getValue(locale);
                    if (value instanceof Boolean) {
                        document.addKeyword(name, (Boolean)value);
                        continue;
                    }
                    if (value instanceof Boolean[]) {
                        document.addKeyword(name, (Boolean[])value);
                        continue;
                    }
                    if (value instanceof Date) {
                        document.addDate(name, (Date)value);
                        continue;
                    }
                    if (value instanceof Date[]) {
                        document.addDate(name, (Date[])value);
                        continue;
                    }
                    if (value instanceof Double) {
                        document.addNumber(name, (Double)value);
                        continue;
                    }
                    if (value instanceof Double[]) {
                        document.addNumber(name, (Double[])value);
                        continue;
                    }
                    if (value instanceof Integer) {
                        document.addNumber(name, (Integer)value);
                        continue;
                    }
                    if (value instanceof Integer[]) {
                        document.addNumber(name, (Integer[])value);
                        continue;
                    }
                    if (value instanceof Long) {
                        document.addNumber(name, (Long)value);
                        continue;
                    }
                    if (value instanceof Long[]) {
                        document.addNumber(name, (Long[])value);
                        continue;
                    }
                    if (value instanceof Float) {
                        document.addNumber(name, (Float)value);
                        continue;
                    }
                    if (value instanceof Float[]) {
                        document.addNumber(name, (Float[])value);
                        continue;
                    }
                    if (value instanceof Object[]) {
                        String[] valuesString = ArrayUtil.toStringArray((Object[])((Object[])value));
                        if (indexType.equals("keyword")) {
                            document.addKeyword(name, valuesString);
                            continue;
                        }
                        document.addText(name, valuesString);
                        continue;
                    }
                    String valueString = String.valueOf(value);
                    String type = field.getType();
                    if (type.equals("radio") || type.equals("select")) {
                        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                        String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                        if (indexType.equals("keyword")) {
                            document.addKeyword(name, stringArray);
                            continue;
                        }
                        document.addText(name, stringArray);
                        continue;
                    }
                    if (type.equals("ddm-text-html")) {
                        valueString = HtmlUtil.extractText((String)valueString);
                    }
                    if (indexType.equals("keyword")) {
                        document.addKeyword(name, valueString);
                        continue;
                    }
                    document.addText(name, valueString);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public String encodeName(long ddmStructureId, String fieldName) {
        return this.encodeName(ddmStructureId, fieldName, null);
    }

    public String encodeName(long ddmStructureId, String fieldName, Locale locale) {
        StringBundler sb = new StringBundler(7);
        sb.append("ddm");
        sb.append("__");
        sb.append(ddmStructureId);
        sb.append("__");
        sb.append(fieldName);
        if (locale != null) {
            sb.append("_");
            sb.append(LocaleUtil.toLanguageId((Locale)locale));
        }
        return sb.toString();
    }

    public String extractIndexableAttributes(DDMStructure ddmStructure, Fields fields, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsUtil.get((String)"index.date.format.pattern"));
        StringBundler sb = new StringBundler();
        for (Field field : fields) {
            try {
                String indexType = ddmStructure.getFieldProperty(field.getName(), "indexType");
                if (Validator.isNull((String)indexType)) continue;
                Serializable value = field.getValue(locale);
                if (value instanceof Boolean || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof Float) {
                    sb.append((Object)value);
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date) {
                    sb.append(dateFormat.format(value));
                    sb.append(" ");
                    continue;
                }
                if (value instanceof Date[]) {
                    Date[] dates = (Date[])value;
                    for (Date date : dates) {
                        sb.append(dateFormat.format(date));
                        sb.append(" ");
                    }
                    continue;
                }
                if (value instanceof Object[]) {
                    Object[] values = (Object[])value;
                    for (Object object : values) {
                        sb.append(object);
                        sb.append(" ");
                    }
                    continue;
                }
                String valueString = String.valueOf(value);
                String type = field.getType();
                if (type.equals("radio") || type.equals("select")) {
                    JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
                    String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
                    sb.append(stringArray);
                    sb.append(" ");
                    continue;
                }
                if (type.equals("ddm-text-html")) {
                    valueString = HtmlUtil.extractText((String)valueString);
                }
                sb.append(valueString);
                sb.append(" ");
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        return sb.toString();
    }
}

