/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.upload.UploadRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.Layout;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchTemplateException;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormValuesJSONDeserializerUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormValues;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.FieldConstants;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.util.DDM;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplay;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplayRegistryUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMFormValuesToFieldsConverterUtil;
import com.liferay.portlet.dynamicdatamapping.util.comparator.StructureIdComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateIdComparator;
import com.liferay.portlet.dynamicdatamapping.util.comparator.TemplateModifiedDateComparator;
import java.io.File;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class DDMImpl
implements DDM {
    public static final String FIELDS_DISPLAY_NAME = "_fieldsDisplay";
    public static final String INSTANCE_SEPARATOR = "_INSTANCE_";
    public static final String TYPE_CHECKBOX = "checkbox";
    public static final String TYPE_DDM_DATE = "ddm-date";
    public static final String TYPE_DDM_DOCUMENTLIBRARY = "ddm-documentlibrary";
    public static final String TYPE_DDM_IMAGE = "ddm-image";
    public static final String TYPE_DDM_LINK_TO_PAGE = "ddm-link-to-page";
    public static final String TYPE_DDM_TEXT_HTML = "ddm-text-html";
    public static final String TYPE_RADIO = "radio";
    public static final String TYPE_SELECT = "select";

    public DDMDisplay getDDMDisplay(ServiceContext serviceContext) {
        String refererPortletName = (String)((Object)serviceContext.getAttribute("refererPortletName"));
        if (refererPortletName == null) {
            refererPortletName = serviceContext.getPortletId();
        }
        return DDMDisplayRegistryUtil.getDDMDisplay((String)refererPortletName);
    }

    public Serializable getDisplayFieldValue(ThemeDisplay themeDisplay, Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getDate((Locale)themeDisplay.getLocale());
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals(TYPE_CHECKBOX)) {
            Boolean valueBoolean = (Boolean)fieldValue;
            fieldValue = valueBoolean.booleanValue() ? LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"yes") : LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"no");
        } else if (type.equals(TYPE_DDM_DOCUMENTLIBRARY)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            fieldValue = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
        } else if (type.equals(TYPE_DDM_LINK_TO_PAGE)) {
            if (Validator.isNull((Object)fieldValue)) {
                return "";
            }
            String valueString = String.valueOf(fieldValue);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            long groupId = jsonObject.getLong("groupId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            long layoutId = jsonObject.getLong("layoutId");
            Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
            fieldValue = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = String.valueOf(fieldValue);
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, ServiceContext serviceContext) throws PortalException {
        return this.getFields(ddmStructureId, ddmTemplateId, "", serviceContext);
    }

    public Fields getFields(long ddmStructureId, long ddmTemplateId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure(ddmStructureId, ddmTemplateId);
        Set fieldNames = ddmStructure.getFieldNames();
        boolean translating = true;
        String defaultLanguageId = (String)((Object)serviceContext.getAttribute("defaultLanguageId"));
        String toLanguageId = (String)((Object)serviceContext.getAttribute("toLanguageId"));
        if (Validator.isNull((String)toLanguageId) || Validator.equals((Object)defaultLanguageId, (Object)toLanguageId)) {
            translating = false;
        }
        Fields fields = new Fields();
        for (String fieldName : fieldNames) {
            List<Serializable> fieldValues;
            boolean localizable = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "localizable"), (boolean)true);
            if (!localizable && translating && !ddmStructure.isFieldPrivate(fieldName) || (fieldValues = this.getFieldValues(ddmStructure, fieldName, fieldNamespace, serviceContext)) == null || fieldValues.isEmpty()) continue;
            Field field = this.createField(ddmStructure, fieldName, fieldValues, serviceContext);
            fields.put(field);
        }
        return fields;
    }

    public Fields getFields(long ddmStructureId, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute("ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, serviceContext);
    }

    public Fields getFields(long ddmStructureId, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        String serializedDDMFormValues = GetterUtil.getString((Object)serviceContext.getAttribute(fieldNamespace + "ddmFormValues"));
        if (Validator.isNotNull((String)serializedDDMFormValues)) {
            return this.getFields(ddmStructureId, serializedDDMFormValues);
        }
        return this.getFields(ddmStructureId, 0L, fieldNamespace, serviceContext);
    }

    public String[] getFieldsDisplayValues(Field fieldsDisplayField) throws Exception {
        String[] values;
        DDMStructure ddmStructure = fieldsDisplayField.getDDMStructure();
        ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
        for (String value : values = this.splitFieldsDisplayValue(fieldsDisplayField)) {
            String fieldName = StringUtil.extractFirst((String)value, (String)INSTANCE_SEPARATOR);
            if (!ddmStructure.hasField(fieldName)) continue;
            fieldsDisplayValues.add(fieldName);
        }
        return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
    }

    public Serializable getIndexedFieldValue(Serializable fieldValue, String type) throws Exception {
        if (fieldValue instanceof Date) {
            Date valueDate = (Date)fieldValue;
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyyMMddHHmmss");
            fieldValue = dateFormat.format(valueDate);
        } else if (type.equals(TYPE_RADIO) || type.equals(TYPE_SELECT)) {
            String valueString = (String)fieldValue;
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)valueString);
            String[] stringArray = ArrayUtil.toStringArray((JSONArray)jsonArray);
            fieldValue = stringArray[0];
        }
        return fieldValue;
    }

    public OrderByComparator<DDMStructure> getStructureOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        StructureIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new StructureIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new StructureModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public OrderByComparator<DDMTemplate> getTemplateOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        TemplateIdComparator orderByComparator = null;
        if (orderByCol.equals("id")) {
            orderByComparator = new TemplateIdComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new TemplateModifiedDateComparator(orderByAsc);
        }
        return orderByComparator;
    }

    public Fields mergeFields(Fields newFields, Fields existingFields) {
        String[] newFieldsDisplayValues = this.splitFieldsDisplayValue(newFields.get(FIELDS_DISPLAY_NAME));
        String[] existingFieldsDisplayValues = this.splitFieldsDisplayValue(existingFields.get(FIELDS_DISPLAY_NAME));
        Iterator itr = newFields.iterator(true);
        while (itr.hasNext()) {
            Field newField = (Field)itr.next();
            Field existingField = existingFields.get(newField.getName());
            if (existingField == null || newField.isPrivate()) {
                existingFields.put(newField);
                continue;
            }
            existingField.setDefaultLocale(newField.getDefaultLocale());
            Map<Locale, List<Serializable>> mergedFieldValuesMap = this.getMergedFieldValuesMap(newField, newFieldsDisplayValues, existingField, existingFieldsDisplayValues);
            existingField.setValuesMap(mergedFieldValuesMap);
        }
        return existingFields;
    }

    protected int countFieldRepetition(String[] fieldsDisplayValues, String fieldName) {
        int count = 0;
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            String prefix = StringUtil.extractFirst((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
            if (!prefix.equals(fieldName)) continue;
            ++count;
        }
        return count;
    }

    protected Field createField(DDMStructure ddmStructure, String fieldName, List<Serializable> fieldValues, ServiceContext serviceContext) {
        Field field = new Field();
        field.setDDMStructureId(ddmStructure.getStructureId());
        String languageId = GetterUtil.getString((Object)serviceContext.getAttribute("languageId"), (String)serviceContext.getLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        String defaultLanguageId = GetterUtil.getString((Object)serviceContext.getAttribute("defaultLanguageId"));
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        if (ddmStructure.isFieldPrivate(fieldName)) {
            locale = LocaleUtil.getSiteDefault();
            defaultLocale = LocaleUtil.getSiteDefault();
        }
        field.setDefaultLocale(defaultLocale);
        field.setName(fieldName);
        field.setValues(locale, fieldValues);
        return field;
    }

    protected DDMStructure getDDMStructure(long ddmStructureId, long ddmTemplateId) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        try {
            DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)ddmTemplateId);
            ddmStructure = (DDMStructure)ddmStructure.clone();
            ddmStructure.setDefinition(ddmTemplate.getScript());
        }
        catch (NoSuchTemplateException nste) {
            // empty catch block
        }
        return ddmStructure;
    }

    protected int getExistingFieldValueIndex(String[] newFieldsDisplayValues, String[] existingFieldsDisplayValues, String fieldName, int index) {
        String instanceId = this.getFieldIntanceId(newFieldsDisplayValues, fieldName, index);
        return this.getFieldValueIndex(existingFieldsDisplayValues, fieldName, instanceId);
    }

    protected String getFieldIntanceId(String[] fieldsDisplayValues, String fieldName, int index) {
        String prefix = fieldName.concat(INSTANCE_SEPARATOR);
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
        }
        return null;
    }

    protected List<String> getFieldNames(String fieldNamespace, String fieldName, ServiceContext serviceContext) {
        String[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)serviceContext.getAttribute(fieldNamespace + FIELDS_DISPLAY_NAME))));
        List privateFieldNames = ListUtil.fromArray((Object[])PropsValues.DYNAMIC_DATA_MAPPING_STRUCTURE_PRIVATE_FIELD_NAMES);
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (fieldsDisplayValues.length == 0 || privateFieldNames.contains(fieldName)) {
            fieldNames.add(fieldNamespace + fieldName);
        } else {
            for (String namespacedFieldName : fieldsDisplayValues) {
                String fieldNameValue = StringUtil.extractFirst((String)namespacedFieldName, (String)INSTANCE_SEPARATOR);
                if (!fieldNameValue.equals(fieldName)) continue;
                fieldNames.add(fieldNamespace + namespacedFieldName);
            }
        }
        return fieldNames;
    }

    protected Fields getFields(long ddmStructureId, String serializedDDMFormValues) throws PortalException {
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.getStructure((long)ddmStructureId);
        DDMFormValues ddmFormValues = DDMFormValuesJSONDeserializerUtil.deserialize((String)serializedDDMFormValues);
        return DDMFormValuesToFieldsConverterUtil.convert((DDMStructure)ddmStructure, (DDMFormValues)ddmFormValues);
    }

    protected int getFieldValueIndex(String[] fieldsDisplayValues, String fieldName, String instanceId) {
        if (instanceId == null) {
            return -1;
        }
        int offset = 0;
        for (String fieldsDisplayValue : fieldsDisplayValues) {
            if (!fieldsDisplayValue.startsWith(fieldName)) continue;
            String fieldIstanceId = StringUtil.extractLast((String)fieldsDisplayValue, (String)INSTANCE_SEPARATOR);
            if (fieldIstanceId.equals(instanceId)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    protected List<Serializable> getFieldValues(DDMStructure ddmStructure, String fieldName, String fieldNamespace, ServiceContext serviceContext) throws PortalException {
        String fieldDataType = ddmStructure.getFieldDataType(fieldName);
        String fieldType = ddmStructure.getFieldType(fieldName);
        List<String> fieldNames = this.getFieldNames(fieldNamespace, fieldName, serviceContext);
        ArrayList<Serializable> fieldValues = new ArrayList<Serializable>(fieldNames.size());
        for (String fieldNameValue : fieldNames) {
            Object fieldValue = serviceContext.getAttribute(fieldNameValue);
            if (fieldType.equals(TYPE_CHECKBOX) && Validator.isNull((Object)fieldValue)) {
                fieldValue = "false";
            } else if (fieldDataType.equals("date")) {
                int fieldValueYear;
                int fieldValueDay;
                int fieldValueMonth = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Month"));
                Date fieldValueDate = PortalUtil.getDate((int)fieldValueMonth, (int)(fieldValueDay = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Day"))), (int)(fieldValueYear = GetterUtil.getInteger((Object)serviceContext.getAttribute(fieldNameValue + "Year"))));
                if (fieldValueDate != null) {
                    fieldValue = String.valueOf(fieldValueDate.getTime());
                }
            } else if (fieldDataType.equals("image") && Validator.isNull((Object)fieldValue)) {
                HttpServletRequest request = serviceContext.getRequest();
                if (!(request instanceof UploadRequest)) {
                    return null;
                }
                fieldValue = this.getImageFieldValue((UploadRequest)request, fieldNameValue);
            }
            if (fieldValue == null) {
                return null;
            }
            if (TYPE_RADIO.equals(fieldType) || TYPE_SELECT.equals(fieldType)) {
                if (fieldValue instanceof String) {
                    fieldValue = new String[]{String.valueOf(fieldValue)};
                }
                fieldValue = JSONFactoryUtil.serialize((Object)fieldValue);
            }
            Serializable fieldValueSerializable = FieldConstants.getSerializable((String)fieldDataType, (String)GetterUtil.getString((Object)fieldValue));
            fieldValues.add(fieldValueSerializable);
        }
        return fieldValues;
    }

    protected List<Serializable> getFieldValues(Field field, Locale locale) {
        Map fieldValuesMap = field.getValuesMap();
        return (List)fieldValuesMap.get(locale);
    }

    protected byte[] getImageBytes(UploadRequest uploadRequest, String fieldNameValue) throws Exception {
        File file = uploadRequest.getFile(fieldNameValue + "File");
        byte[] bytes = FileUtil.getBytes((File)file);
        if (ArrayUtil.isNotEmpty((byte[])bytes)) {
            return bytes;
        }
        String url = uploadRequest.getParameter(fieldNameValue + "URL");
        long imageId = GetterUtil.getLong((String)HttpUtil.getParameter((String)url, (String)"img_id", (boolean)false));
        Image image = ImageLocalServiceUtil.fetchImage((long)imageId);
        if (image == null) {
            return null;
        }
        return image.getTextObj();
    }

    protected String getImageFieldValue(UploadRequest uploadRequest, String fieldNameValue) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("alt", "");
        jsonObject.put("data", "");
        try {
            byte[] bytes = this.getImageBytes(uploadRequest, fieldNameValue);
            if (ArrayUtil.isNotEmpty((byte[])bytes)) {
                jsonObject.put("alt", uploadRequest.getParameter(fieldNameValue + "Alt"));
                jsonObject.put("data", UnicodeFormatter.bytesToHex((byte[])bytes));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    protected Set<Locale> getMergedAvailableLocales(Set<Locale> newFieldAvailableLocales, Set<Locale> existingFieldAvailableLocales) {
        HashSet<Locale> mergedAvailableLocales = new HashSet<Locale>();
        mergedAvailableLocales.addAll(newFieldAvailableLocales);
        mergedAvailableLocales.addAll(existingFieldAvailableLocales);
        return mergedAvailableLocales;
    }

    protected List<Serializable> getMergedFieldValues(String fieldName, List<Serializable> newFieldValues, String[] newFieldsDisplayValues, List<Serializable> existingFieldValues, String[] existingFieldsDisplayValues, List<Serializable> defaultFieldValues) {
        if (existingFieldValues == null) {
            return newFieldValues;
        }
        ArrayList<Serializable> mergedLocaleValues = new ArrayList<Serializable>();
        int repetition = this.countFieldRepetition(newFieldsDisplayValues, fieldName);
        for (int i = 0; i < repetition; ++i) {
            int existingFieldValueIndex = this.getExistingFieldValueIndex(newFieldsDisplayValues, existingFieldsDisplayValues, fieldName, i);
            if (existingFieldValueIndex == -1) {
                mergedLocaleValues.add(i, defaultFieldValues.get(i));
                continue;
            }
            if (newFieldValues != null) {
                mergedLocaleValues.add(i, newFieldValues.get(i));
                continue;
            }
            Serializable existingValue = existingFieldValues.get(existingFieldValueIndex);
            mergedLocaleValues.add(i, existingValue);
        }
        return mergedLocaleValues;
    }

    protected Map<Locale, List<Serializable>> getMergedFieldValuesMap(Field newField, String[] newFieldsDisplayValues, Field existingField, String[] existingFieldsDisplayValues) {
        Set<Locale> availableLocales = this.getMergedAvailableLocales(newField.getAvailableLocales(), existingField.getAvailableLocales());
        for (Locale locale : availableLocales) {
            List<Serializable> newFieldValues = this.getFieldValues(newField, locale);
            List<Serializable> existingFieldValues = this.getFieldValues(existingField, locale);
            List<Serializable> defaultFieldValues = this.getFieldValues(newField, newField.getDefaultLocale());
            List<Serializable> mergedLocaleValues = this.getMergedFieldValues(newField.getName(), newFieldValues, newFieldsDisplayValues, existingFieldValues, existingFieldsDisplayValues, defaultFieldValues);
            existingField.setValues(locale, mergedLocaleValues);
        }
        return existingField.getValuesMap();
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }
}

