/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDDeserializerUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDSerializerUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DDMFormTemplateSynchonizer {
    private List<DDMTemplate> _ddmFormTemplates = new ArrayList<DDMTemplate>();
    private DDMForm _structureDDMForm;

    public DDMFormTemplateSynchonizer(DDMForm structureDDMForm) {
        this._structureDDMForm = structureDDMForm;
    }

    public void setDDMFormTemplates(List<DDMTemplate> ddmFormTemplates) {
        this._ddmFormTemplates = ddmFormTemplates;
    }

    public void synchronize() throws PortalException {
        for (DDMTemplate ddmTemplate : this.getDDMFormTemplates()) {
            DDMForm templateDDMForm = DDMFormXSDDeserializerUtil.deserialize((String)ddmTemplate.getScript());
            this.synchronizeDDMFormFields(this._structureDDMForm.getDDMFormFieldsMap(true), templateDDMForm.getDDMFormFields(), ddmTemplate.getMode());
            String mode = ddmTemplate.getMode();
            if (mode.equals("create")) {
                this.addRequiredDDMFormFields(this._structureDDMForm.getDDMFormFields(), templateDDMForm.getDDMFormFields());
            }
            this.updateDDMTemplate(ddmTemplate, templateDDMForm);
        }
    }

    protected void addRequiredDDMFormFields(List<DDMFormField> structureDDMFormFields, List<DDMFormField> templateDDMFormFields) {
        for (int i = 0; i < structureDDMFormFields.size(); ++i) {
            DDMFormField structureDDMFormField = structureDDMFormFields.get(i);
            DDMFormField templateDDMFormField = this.getDDMFormField(templateDDMFormFields, structureDDMFormField.getName());
            if (templateDDMFormField == null) {
                if (!structureDDMFormField.isRequired()) continue;
                templateDDMFormFields.add(structureDDMFormField);
                continue;
            }
            this.addRequiredDDMFormFields(structureDDMFormField.getNestedDDMFormFields(), templateDDMFormField.getNestedDDMFormFields());
        }
    }

    protected DDMFormField getDDMFormField(List<DDMFormField> ddmFormFields, String name) {
        LinkedList<DDMFormField> queue = new LinkedList<DDMFormField>(ddmFormFields);
        DDMFormField ddmFormField = null;
        while ((ddmFormField = (DDMFormField)queue.poll()) != null) {
            if (name.equals(ddmFormField.getName())) {
                return ddmFormField;
            }
            queue.addAll(ddmFormField.getNestedDDMFormFields());
        }
        return null;
    }

    protected List<DDMTemplate> getDDMFormTemplates() {
        return this._ddmFormTemplates;
    }

    protected String serializeDDMForm(DDMForm templateDDMForm) {
        String script = DDMFormXSDSerializerUtil.serialize((DDMForm)templateDDMForm);
        return DDMXMLUtil.formatXML((String)script);
    }

    protected void synchronizeDDMFormFieldRequiredProperty(DDMFormField structureDDMFormField, DDMFormField templateDDMFormField, String templateMode) {
        if (structureDDMFormField == null) {
            return;
        }
        if (!templateMode.equals("create")) {
            return;
        }
        templateDDMFormField.setRequired(structureDDMFormField.isRequired());
    }

    protected void synchronizeDDMFormFields(Map<String, DDMFormField> structureDDMFormFieldsMap, List<DDMFormField> templateDDMFormFields, String templateMode) {
        Iterator<DDMFormField> itr = templateDDMFormFields.iterator();
        while (itr.hasNext()) {
            DDMFormField templateDDMFormField = itr.next();
            String dataType = templateDDMFormField.getDataType();
            String name = templateDDMFormField.getName();
            if (Validator.isNotNull((String)dataType) && !structureDDMFormFieldsMap.containsKey(name)) {
                itr.remove();
                continue;
            }
            this.synchronizeDDMFormFieldRequiredProperty(structureDDMFormFieldsMap.get(name), templateDDMFormField, templateMode);
            this.synchronizeDDMFormFields(structureDDMFormFieldsMap, templateDDMFormField.getNestedDDMFormFields(), templateMode);
        }
    }

    protected void updateDDMTemplate(DDMTemplate ddmTemplate, DDMForm templateDDMForm) {
        String script = this.serializeDDMForm(templateDDMForm);
        ddmTemplate.setScript(script);
        DDMTemplateLocalServiceUtil.updateDDMTemplate((DDMTemplate)ddmTemplate);
    }
}

