/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormFieldOptions;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class StringFieldRenderer
extends BaseFieldRenderer {
    protected String doRender(Field field, Locale locale) throws Exception {
        String fieldType = this.getFieldType(field);
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            if (fieldType.equals("radio") || fieldType.equals("select")) {
                valueString = this.handleJSON(field, valueString, locale);
            }
            values.add(valueString);
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) throws Exception {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        String fieldType = this.getFieldType(field);
        if (fieldType.equals("radio") || fieldType.equals("select")) {
            return this.handleJSON(field, String.valueOf(value), locale);
        }
        return String.valueOf(value);
    }

    protected LocalizedValue getFieldOptionLabel(Field field, String optionValue) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        DDMFormField ddmFormField = ddmStructure.getDDMFormField(field.getName());
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        return ddmFormFieldOptions.getOptionLabels(optionValue);
    }

    protected String getFieldType(Field field) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        return ddmStructure.getFieldType(field.getName());
    }

    protected String handleJSON(Field field, String json, Locale locale) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        StringBundler sb = new StringBundler(jsonArray.length() * 2);
        for (int i = 0; i < jsonArray.length(); ++i) {
            LocalizedValue label = this.getFieldOptionLabel(field, jsonArray.getString(i));
            if (label == null) continue;
            sb.append(label.getString(locale));
            if (i + 1 >= jsonArray.length()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

