/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class DocumentLibraryFieldRenderer
extends BaseFieldRenderer {
    private static Log _log = LogFactoryUtil.getLog(DocumentLibraryFieldRenderer.class);

    protected String doRender(Field field, Locale locale) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            values.add(this.handleJSON(valueString, locale));
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        return this.handleJSON(String.valueOf(value), locale);
    }

    protected String handleJSON(String json, Locale locale) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        }
        catch (JSONException jsone) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON", (Throwable)jsone);
            }
            return "";
        }
        long fileEntryGroupId = jsonObject.getLong("groupId");
        String fileEntryUUID = jsonObject.getString("uuid");
        try {
            FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)fileEntryUUID, (long)fileEntryGroupId);
            return fileEntry.getTitle();
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                return LanguageUtil.format((Locale)locale, (String)"is-temporarily-unavailable", (Object)"content");
            }
            return "";
        }
    }
}

