/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.StorageException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldNameException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldRequiredException;
import com.liferay.portlet.dynamicdatamapping.StorageFieldValueException;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.Value;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormFieldValue;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormValues;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormValuesValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMFormValuesValidatorImpl
implements DDMFormValuesValidator {
    public void validate(DDMFormValues ddmFormValues) throws StorageException {
        DDMForm ddmForm = ddmFormValues.getDDMForm();
        if (ddmForm == null) {
            throw new NullPointerException("A DDM Form instance was never set");
        }
        this.traverseDDMFormFields(ddmForm.getDDMFormFields(), ddmFormValues.getDDMFormFieldValuesMap());
        this.traverseDDMFormFieldValues(ddmFormValues.getDDMFormFieldValues(), ddmForm.getDDMFormFieldsMap(false));
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValuesByFieldName(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, String fieldName) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(fieldName);
        if (ddmFormFieldValues == null) {
            return Collections.emptyList();
        }
        return ddmFormFieldValues;
    }

    protected boolean isNull(Value value) {
        return value == null || MapUtil.isEmpty((Map)value.getValues());
    }

    protected void traverseDDMFormFields(List<DDMFormField> ddmFormFields, Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap) throws StorageException {
        for (DDMFormField ddmFormField : ddmFormFields) {
            List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValuesByFieldName(ddmFormFieldValuesMap, ddmFormField.getName());
            this.validateDDMFormFieldValues(ddmFormField, ddmFormFieldValues);
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                this.traverseDDMFormFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldValue.getNestedDDMFormFieldValuesMap());
            }
        }
    }

    protected void traverseDDMFormFieldValues(List<DDMFormFieldValue> ddmFormFieldValues, Map<String, DDMFormField> ddmFormFieldsMap) throws StorageException {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this.validateDDMFormFieldValue(ddmFormFieldsMap.get(ddmFormFieldValue.getName()), ddmFormFieldValue);
        }
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) throws StorageException {
        if (ddmFormField == null) {
            throw new StorageFieldNameException("There is no such field name defined on DDM Form " + ddmFormFieldValue.getName());
        }
        DDMFormValues ddmFormValues = ddmFormFieldValue.getDDMFormValues();
        this.validateDDMFormFieldValue(ddmFormField, ddmFormValues.getAvailableLocales(), ddmFormValues.getDefaultLocale(), ddmFormFieldValue.getValue());
        this.traverseDDMFormFieldValues(ddmFormFieldValue.getNestedDDMFormFieldValues(), ddmFormField.getNestedDDMFormFieldsMap());
    }

    protected void validateDDMFormFieldValue(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws StorageException {
        if (this.isNull(value)) {
            throw new StorageFieldValueException("No value defined for field " + ddmFormField.getName());
        }
        if (Validator.isNull((String)ddmFormField.getDataType())) {
            throw new StorageFieldValueException("Value should not be set for field " + ddmFormField.getName());
        }
        if (ddmFormField.isLocalizable() && !value.isLocalized() || !ddmFormField.isLocalizable() && value.isLocalized()) {
            throw new StorageFieldValueException("Invalid value set for field " + ddmFormField.getName());
        }
        this.validateDDMFormFieldValueLocales(ddmFormField, availableLocales, defaultLocale, value);
    }

    protected void validateDDMFormFieldValueLocales(DDMFormField ddmFormField, Set<Locale> availableLocales, Locale defaultLocale, Value value) throws StorageException {
        if (!value.isLocalized()) {
            return;
        }
        if (!availableLocales.equals(value.getAvailableLocales())) {
            throw new StorageFieldValueException("Invalid available locales set for field " + ddmFormField.getName());
        }
        if (!defaultLocale.equals(value.getDefaultLocale())) {
            throw new StorageFieldValueException("Invalid default locale set for field " + ddmFormField.getName());
        }
    }

    protected void validateDDMFormFieldValues(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) throws StorageException {
        if (ddmFormField.isRequired() && ddmFormFieldValues.size() == 0) {
            throw new StorageFieldRequiredException("No value defined for field " + ddmFormField.getName());
        }
        if (!ddmFormField.isRepeatable() && ddmFormFieldValues.size() > 1) {
            throw new StorageFieldValueException("Incorrect number of values set for field " + ddmFormField.getName());
        }
    }
}

