/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;

public class DDMTemplatePermission {
    public static void check(PermissionChecker permissionChecker, DDMTemplate template, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, template, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, DDMTemplate template, String portletId, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, groupId, template, portletId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long templateId, String portletId, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, groupId, templateId, portletId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long templateId, String actionId) throws PortalException {
        if (!DDMTemplatePermission.contains(permissionChecker, templateId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, DDMTemplate template, String actionId) {
        if (permissionChecker.hasOwnerPermission(template.getCompanyId(), DDMTemplate.class.getName(), template.getTemplateId(), template.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(template.getGroupId(), DDMTemplate.class.getName(), template.getTemplateId(), actionId);
    }

    @Deprecated
    public static boolean contains(PermissionChecker permissionChecker, DDMTemplate template, String portletId, String actionId) {
        return DDMTemplatePermission.contains(permissionChecker, template, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, DDMTemplate template, String portletId, String actionId) {
        Boolean hasPermission;
        if (Validator.isNotNull((String)portletId) && (hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)groupId, (String)DDMTemplate.class.getName(), (long)template.getTemplateId(), (String)portletId, (String)actionId)) != null) {
            return hasPermission;
        }
        return DDMTemplatePermission.contains(permissionChecker, template, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long templateId, String portletId, String actionId) throws PortalException {
        DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)templateId);
        return DDMTemplatePermission.contains(permissionChecker, groupId, template, portletId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long templateId, String actionId) throws PortalException {
        DDMTemplate template = DDMTemplateLocalServiceUtil.getTemplate((long)templateId);
        return DDMTemplatePermission.contains(permissionChecker, template, actionId);
    }

    @Deprecated
    public static boolean contains(PermissionChecker permissionChecker, long templateId, String portletId, String actionId) throws PortalException {
        return DDMTemplatePermission.contains(permissionChecker, templateId, actionId);
    }
}

