/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMTemplateServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMPermission;
import com.liferay.portlet.dynamicdatamapping.service.permission.DDMTemplatePermission;
import com.liferay.portlet.dynamicdatamapping.util.DDMDisplay;
import com.liferay.portlet.dynamicdatamapping.util.DDMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMTemplateServiceImpl
extends DDMTemplateServiceBaseImpl {
    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, ServiceContext serviceContext) throws PortalException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(classNameId), ddmDisplay.getAddTemplateActionId());
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, null, nameMap, descriptionMap, type, mode, language, script, false, false, null, null, serviceContext);
    }

    public DDMTemplate addTemplate(long groupId, long classNameId, long classPK, String templateKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(classNameId), ddmDisplay.getAddTemplateActionId());
        return this.ddmTemplateLocalService.addTemplate(this.getUserId(), groupId, classNameId, classPK, templateKey, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        long classNameId = template.getClassNameId();
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(classNameId), ddmDisplay.getAddTemplateActionId());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, nameMap, descriptionMap, serviceContext);
    }

    public DDMTemplate copyTemplate(long templateId, ServiceContext serviceContext) throws PortalException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMTemplate template = this.ddmTemplatePersistence.findByPrimaryKey(templateId);
        long classNameId = template.getClassNameId();
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(classNameId), ddmDisplay.getAddTemplateActionId());
        return this.ddmTemplateLocalService.copyTemplate(this.getUserId(), templateId, serviceContext);
    }

    public List<DDMTemplate> copyTemplates(long classNameId, long classPK, long newClassPK, String type, ServiceContext serviceContext) throws PortalException {
        DDMDisplay ddmDisplay = DDMUtil.getDDMDisplay((ServiceContext)serviceContext);
        DDMPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), ddmDisplay.getResourceName(classNameId), ddmDisplay.getAddTemplateActionId());
        return this.ddmTemplateLocalService.copyTemplates(this.getUserId(), classNameId, classPK, newClassPK, type, serviceContext);
    }

    public void deleteTemplate(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "DELETE");
        this.ddmTemplateLocalService.deleteTemplate(templateId);
    }

    public DDMTemplate fetchTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.fetchTemplate(groupId, classNameId, templateKey);
        if (ddmTemplate != null) {
            DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        }
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long templateId) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "VIEW");
        return this.ddmTemplatePersistence.findByPrimaryKey(templateId);
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey);
        DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public DDMTemplate getTemplate(long groupId, long classNameId, String templateKey, boolean includeAncestorTemplates) throws PortalException {
        DDMTemplate ddmTemplate = this.ddmTemplateLocalService.getTemplate(groupId, classNameId, templateKey, includeAncestorTemplates);
        DDMTemplatePermission.check(this.getPermissionChecker(), ddmTemplate, "VIEW");
        return ddmTemplate;
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId) {
        return this.ddmTemplatePersistence.filterFindByG_C(groupId, classNameId);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK) {
        return this.ddmTemplatePersistence.filterFindByG_C_C(groupId, classNameId, classPK);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, boolean includeAncestorTemplates) throws PortalException {
        ArrayList<DDMTemplate> ddmTemplates = new ArrayList<DDMTemplate>();
        ddmTemplates.addAll(this.ddmTemplatePersistence.filterFindByG_C_C(groupId, classNameId, classPK));
        if (!includeAncestorTemplates) {
            return ddmTemplates;
        }
        ddmTemplates.addAll(this.ddmTemplatePersistence.filterFindByG_C_C(PortalUtil.getAncestorSiteGroupIds((long)groupId), classNameId, classPK));
        return ddmTemplates;
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type) {
        return this.ddmTemplatePersistence.filterFindByG_C_C_T(groupId, classNameId, classPK, type);
    }

    public List<DDMTemplate> getTemplates(long groupId, long classNameId, long classPK, String type, String mode) {
        return this.ddmTemplatePersistence.filterFindByG_C_C_T_M(groupId, classNameId, classPK, type, mode);
    }

    public List<DDMTemplate> getTemplatesByClassPK(long groupId, long classPK) {
        return this.ddmTemplatePersistence.filterFindByG_CPK(groupId, classPK);
    }

    public List<DDMTemplate> getTemplatesByStructureClassNameId(long groupId, long structureClassNameId, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByG_SC(groupId, structureClassNameId, start, end, orderByComparator);
    }

    public int getTemplatesByStructureClassNameIdCount(long groupId, long structureClassNameId) {
        return this.ddmTemplateFinder.filterCountByG_SC(groupId, structureClassNameId);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, String keywords, String type, String mode, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByKeywords(companyId, groupId, classNameId, classPK, keywords, type, mode, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long groupId, long classNameId, long classPK, String name, String description, String type, String mode, String language, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_N_D_T_M_L(companyId, groupId, classNameId, classPK, name, description, type, mode, language, andOperator, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String keywords, String type, String mode, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, type, mode, start, end, orderByComparator);
    }

    public List<DDMTemplate> search(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String name, String description, String type, String mode, String language, boolean andOperator, int start, int end, OrderByComparator<DDMTemplate> orderByComparator) {
        return this.ddmTemplateFinder.filterFindByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, type, mode, language, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, String keywords, String type, String mode) {
        return this.ddmTemplateFinder.filterCountByKeywords(companyId, groupId, classNameId, classPK, keywords, type, mode);
    }

    public int searchCount(long companyId, long groupId, long classNameId, long classPK, String name, String description, String type, String mode, String language, boolean andOperator) {
        return this.ddmTemplateFinder.filterCountByC_G_C_C_N_D_T_M_L(companyId, groupId, classNameId, classPK, name, description, type, mode, language, andOperator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String keywords, String type, String mode) {
        return this.ddmTemplateFinder.filterCountByKeywords(companyId, groupIds, classNameIds, classPKs, keywords, type, mode);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, long[] classPKs, String name, String description, String type, String mode, String language, boolean andOperator) {
        return this.ddmTemplateFinder.filterCountByC_G_C_C_N_D_T_M_L(companyId, groupIds, classNameIds, classPKs, name, description, type, mode, language, andOperator);
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, boolean smallImage, String smallImageURL, File smallImageFile, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, smallImage, smallImageURL, smallImageFile, serviceContext);
    }

    public DDMTemplate updateTemplate(long templateId, long classPK, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String mode, String language, String script, boolean cacheable, ServiceContext serviceContext) throws PortalException {
        DDMTemplatePermission.check(this.getPermissionChecker(), templateId, "UPDATE");
        return this.ddmTemplateLocalService.updateTemplate(templateId, classPK, nameMap, descriptionMap, type, mode, language, script, cacheable, serviceContext);
    }
}

