/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDefinitionException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateStructureKeyException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMFormTemplateSynchonizer;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class DDMStructureLocalServiceImpl
extends DDMStructureLocalServiceBaseImpl {
    public DDMStructure addStructure(long userId, long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        structureKey = Validator.isNull((String)structureKey) ? String.valueOf(this.counterLocalService.increment()) : StringUtil.toUpperCase((String)structureKey.trim());
        try {
            definition = DDMXMLUtil.validateXML((String)definition);
            definition = DDMXMLUtil.formatXML((String)definition);
        }
        catch (Exception e) {
            throw new StructureDefinitionException();
        }
        Date now = new Date();
        this.validate(groupId, parentStructureId, classNameId, structureKey, nameMap, definition);
        long structureId = this.counterLocalService.increment();
        DDMStructure structure = this.ddmStructurePersistence.create(structureId);
        structure.setUuid(serviceContext.getUuid());
        structure.setGroupId(groupId);
        structure.setCompanyId(user.getCompanyId());
        structure.setUserId(user.getUserId());
        structure.setUserName(user.getFullName());
        structure.setCreateDate(serviceContext.getCreateDate(now));
        structure.setModifiedDate(serviceContext.getModifiedDate(now));
        structure.setParentStructureId(parentStructureId);
        structure.setClassNameId(classNameId);
        structure.setStructureKey(structureKey);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        structure.setStorageType(storageType);
        structure.setType(type);
        this.ddmStructurePersistence.update((BaseModel)structure);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addStructureResources(structure, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addStructureResources(structure, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        return structure;
    }

    public DDMStructure addStructure(long userId, long groupId, long classNameId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        return this.addStructure(userId, groupId, 0L, classNameId, null, nameMap, descriptionMap, definition, PropsValues.DYNAMIC_DATA_LISTS_STORAGE_TYPE, 0, serviceContext);
    }

    public DDMStructure addStructure(long userId, long groupId, String parentStructureKey, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, String storageType, int type, ServiceContext serviceContext) throws PortalException {
        DDMStructure parentStructure = this.fetchStructure(groupId, classNameId, parentStructureKey);
        long parentStructureId = 0L;
        if (parentStructure != null) {
            parentStructureId = parentStructure.getStructureId();
        }
        return this.addStructure(userId, groupId, parentStructureId, classNameId, structureKey, nameMap, descriptionMap, definition, storageType, type, serviceContext);
    }

    public void addStructureResources(DDMStructure structure, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addStructureResources(DDMStructure structure, String[] groupPermissions, String[] guestPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(structure.getCompanyId(), structure.getGroupId(), structure.getUserId(), DDMStructure.class.getName(), structure.getStructureId(), groupPermissions, guestPermissions);
    }

    public DDMStructure copyStructure(long userId, long structureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, nameMap, descriptionMap, structure.getDefinition(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    public DDMStructure copyStructure(long userId, long structureId, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.addStructure(userId, structure.getGroupId(), structure.getParentStructureId(), structure.getClassNameId(), null, (Map<Locale, String>)structure.getNameMap(), (Map<Locale, String>)structure.getDescriptionMap(), structure.getDefinition(), structure.getStorageType(), structure.getType(), serviceContext);
    }

    @SystemEvent(type=1)
    public void deleteStructure(DDMStructure structure) throws PortalException {
        if (!GroupThreadLocal.isDeleteInProcess()) {
            if (this.ddmStructureLinkPersistence.countByStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(2);
            }
            if (this.ddmStructurePersistence.countByParentStructureId(structure.getStructureId()) > 0) {
                throw new RequiredStructureException(1);
            }
            long classNameId = this.classNameLocalService.getClassNameId(DDMStructure.class);
            if (this.ddmTemplatePersistence.countByG_C_C(structure.getGroupId(), classNameId, structure.getPrimaryKey()) > 0) {
                throw new RequiredStructureException(3);
            }
        }
        this.ddmStructurePersistence.remove((BaseModel)structure);
        this.resourceLocalService.deleteResource(structure.getCompanyId(), DDMStructure.class.getName(), 4, structure.getStructureId());
    }

    public void deleteStructure(long structureId) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        this.ddmStructureLocalService.deleteStructure(structure);
    }

    public void deleteStructures(long groupId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByGroupId(groupId);
        for (DDMStructure structure : structures) {
            this.ddmStructureLocalService.deleteStructure(structure);
        }
    }

    public DDMStructure fetchStructure(long structureId) {
        return this.ddmStructurePersistence.fetchByPrimaryKey(structureId);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey) {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure fetchStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            return null;
        }
        for (long ancestorSiteGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(ancestorSiteGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    @Deprecated
    public List<DDMStructure> getClassStructures(long classNameId) {
        return this.ddmStructurePersistence.findByClassNameId(classNameId);
    }

    @Deprecated
    public List<DDMStructure> getClassStructures(long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, start, end);
    }

    public List<DDMStructure> getClassStructures(long companyId, long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByC_C(companyId, classNameId, -1, -1, orderByComparator);
    }

    @Deprecated
    public List<DDMStructure> getClassStructures(long classNameId, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByClassNameId(classNameId, -1, -1, orderByComparator);
    }

    public List<DDMStructure> getDLFileEntryTypeStructures(long dlFileEntryTypeId) {
        return this.dlFileEntryTypePersistence.getDDMStructures(dlFileEntryTypeId);
    }

    public List<DDMStructure> getJournalFolderStructures(long[] groupIds, long journalFolderId, int restrictionType) throws PortalException {
        if (restrictionType == 1) {
            return this.journalFolderPersistence.getDDMStructures(journalFolderId);
        }
        List structures = null;
        if ((journalFolderId = this.journalFolderLocalService.getOverridedDDMStructuresFolderId(journalFolderId)) != 0L) {
            structures = this.journalFolderPersistence.getDDMStructures(journalFolderId);
        } else {
            long classNameId = this.classNameLocalService.getClassNameId(JournalArticle.class);
            structures = this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
        }
        return structures;
    }

    public DDMStructure getStructure(long structureId) throws PortalException {
        return this.ddmStructurePersistence.findByPrimaryKey(structureId);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        return this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
    }

    public DDMStructure getStructure(long groupId, long classNameId, String structureKey, boolean includeAncestorStructures) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            return structure;
        }
        if (!includeAncestorStructures) {
            throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey);
        }
        for (long curGroupId : PortalUtil.getAncestorSiteGroupIds((long)groupId)) {
            structure = this.ddmStructurePersistence.fetchByG_C_S(curGroupId, classNameId, structureKey);
            if (structure == null) continue;
            return structure;
        }
        throw new NoSuchStructureException("No DDMStructure exists with the structure key " + structureKey + " in the ancestor groups");
    }

    public List<DDMStructure> getStructure(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    @Deprecated
    public List<DDMStructure> getStructureEntries() {
        return this.getStructures();
    }

    @Deprecated
    public List<DDMStructure> getStructureEntries(long groupId) {
        return this.getStructures(groupId);
    }

    @Deprecated
    public List<DDMStructure> getStructureEntries(long groupId, int start, int end) {
        return this.getStructures(groupId, start, end);
    }

    public List<DDMStructure> getStructures() {
        return this.ddmStructurePersistence.findAll();
    }

    public List<DDMStructure> getStructures(long groupId) {
        return this.ddmStructurePersistence.findByGroupId(groupId);
    }

    public List<DDMStructure> getStructures(long groupId, int start, int end) {
        return this.ddmStructurePersistence.findByGroupId(groupId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end);
    }

    public List<DDMStructure> getStructures(long groupId, long classNameId, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructurePersistence.findByG_C(groupId, classNameId, start, end, orderByComparator);
    }

    public List<DDMStructure> getStructures(long groupId, String name, String description) {
        return this.ddmStructurePersistence.findByG_N_D(groupId, name, description);
    }

    public List<DDMStructure> getStructures(long[] groupIds) {
        return this.ddmStructurePersistence.findByGroupId(groupIds);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> getStructures(long[] groupIds, long classNameId, int start, int end) {
        return this.ddmStructurePersistence.findByG_C(groupIds, classNameId, start, end);
    }

    public int getStructuresCount(long groupId) {
        return this.ddmStructurePersistence.countByGroupId(groupId);
    }

    public int getStructuresCount(long groupId, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupId, classNameId);
    }

    public int getStructuresCount(long[] groupIds, long classNameId) {
        return this.ddmStructurePersistence.countByG_C(groupIds, classNameId);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String keywords, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.findByKeywords(companyId, groupIds, classNameIds, keywords, start, end, orderByComparator);
    }

    public List<DDMStructure> search(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator, int start, int end, OrderByComparator<DDMStructure> orderByComparator) {
        return this.ddmStructureFinder.findByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator, start, end, orderByComparator);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String keywords) {
        return this.ddmStructureFinder.countByKeywords(companyId, groupIds, classNameIds, keywords);
    }

    public int searchCount(long companyId, long[] groupIds, long[] classNameIds, String name, String description, String storageType, int type, boolean andOperator) {
        return this.ddmStructureFinder.countByC_G_C_N_D_S_T(companyId, groupIds, classNameIds, name, description, storageType, type, andOperator);
    }

    public DDMStructure updateDefinition(long structureId, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(structure.getParentStructureId(), structure.getNameMap(), structure.getDescriptionMap(), definition, serviceContext, structure);
    }

    public DDMStructure updateStructure(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        structureKey = this.getStructureKey(structureKey);
        DDMStructure structure = this.ddmStructurePersistence.findByG_C_S(groupId, classNameId, structureKey);
        return this.doUpdateStructure(parentStructureId, nameMap, descriptionMap, definition, serviceContext, structure);
    }

    public DDMStructure updateStructure(long structureId, long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.findByPrimaryKey(structureId);
        return this.doUpdateStructure(parentStructureId, nameMap, descriptionMap, definition, serviceContext, structure);
    }

    protected DDMStructure doUpdateStructure(long parentStructureId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String definition, ServiceContext serviceContext, DDMStructure structure) throws PortalException {
        try {
            definition = DDMXMLUtil.validateXML((String)definition);
            definition = DDMXMLUtil.formatXML((String)definition);
        }
        catch (Exception e) {
            throw new StructureDefinitionException();
        }
        DDMForm parentDDMForm = this.getParentDDMForm(parentStructureId);
        this.validate(nameMap, parentDDMForm, definition);
        structure.setModifiedDate(serviceContext.getModifiedDate(null));
        structure.setParentStructureId(parentStructureId);
        structure.setNameMap(nameMap);
        structure.setDescriptionMap(descriptionMap);
        structure.setDefinition(definition);
        this.ddmStructurePersistence.update((BaseModel)structure);
        this.syncStructureTemplatesFields(structure);
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)structure.getClassName());
        if (indexer != null) {
            List<Long> ddmStructureIds = this.getChildrenStructureIds(structure.getGroupId(), structure.getStructureId());
            indexer.reindexDDMStructures(ddmStructureIds);
        }
        return structure;
    }

    protected void getChildrenStructureIds(List<Long> structureIds, long groupId, long parentStructureId) throws PortalException {
        List structures = this.ddmStructurePersistence.findByG_P(groupId, parentStructureId);
        for (DDMStructure structure : structures) {
            structureIds.add(structure.getStructureId());
            this.getChildrenStructureIds(structureIds, structure.getGroupId(), structure.getStructureId());
        }
    }

    protected List<Long> getChildrenStructureIds(long groupId, long structureId) throws PortalException {
        ArrayList<Long> structureIds = new ArrayList<Long>();
        this.getChildrenStructureIds(structureIds, groupId, structureId);
        structureIds.add(0, structureId);
        return structureIds;
    }

    protected Set<String> getDDMFormFieldsNames(DDMForm ddmForm) {
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        HashSet<String> ddmFormFieldsNames = new HashSet<String>(ddmFormFieldsMap.size());
        for (String ddmFormFieldName : ddmFormFieldsMap.keySet()) {
            ddmFormFieldsNames.add(StringUtil.toLowerCase((String)ddmFormFieldName));
        }
        return ddmFormFieldsNames;
    }

    protected Set<String> getElementNames(Document document) {
        HashSet<String> elementNames = new HashSet<String>();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        List nodes = xPathSelector.selectNodes((Object)document);
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = StringUtil.toLowerCase((String)element.attributeValue("name"));
            elementNames.add(name);
        }
        return elementNames;
    }

    protected DDMForm getParentDDMForm(long parentStructureId) {
        DDMStructure parentStructure = this.ddmStructurePersistence.fetchByPrimaryKey(parentStructureId);
        if (parentStructure == null) {
            return null;
        }
        return parentStructure.getFullHierarchyDDMForm();
    }

    protected String getStructureKey(String structureKey) {
        if (structureKey != null) {
            structureKey = structureKey.trim();
            return StringUtil.toUpperCase((String)structureKey);
        }
        return "";
    }

    protected List<DDMTemplate> getStructureTemplates(DDMStructure structure, String type) {
        long classNameId = this.classNameLocalService.getClassNameId(DDMStructure.class);
        return this.ddmTemplateLocalService.getTemplates(structure.getGroupId(), classNameId, structure.getStructureId(), type);
    }

    protected void syncStructureTemplatesFields(final DDMStructure structure) {
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DDMFormTemplateSynchonizer ddmFormTemplateSynchonizer = new DDMFormTemplateSynchonizer(structure.getDDMForm());
                List<DDMTemplate> templates = DDMStructureLocalServiceImpl.this.getStructureTemplates(structure, "form");
                ddmFormTemplateSynchonizer.setDDMFormTemplates(templates);
                ddmFormTemplateSynchonizer.synchronize();
                return null;
            }
        });
    }

    protected void validate(DDMForm parentDDMForm, Document childDocument) throws PortalException {
        Set<String> parentElementNames = this.getDDMFormFieldsNames(parentDDMForm);
        for (String childElementName : this.getElementNames(childDocument)) {
            if (!parentElementNames.contains(childElementName)) continue;
            throw new StructureDuplicateElementException();
        }
    }

    protected void validate(Document document) throws PortalException {
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        List nodes = xPathSelector.selectNodes((Object)document);
        HashSet<String> elementNames = new HashSet<String>();
        for (Node node : nodes) {
            Element element = (Element)node;
            String name = StringUtil.toLowerCase((String)element.attributeValue("name"));
            if (name.startsWith("reserved")) {
                throw new StructureDefinitionException();
            }
            if (elementNames.contains(name)) {
                throw new StructureDuplicateElementException();
            }
            elementNames.add(name);
        }
    }

    protected void validate(long groupId, long parentStructureId, long classNameId, String structureKey, Map<Locale, String> nameMap, String definition) throws PortalException {
        DDMStructure structure = this.ddmStructurePersistence.fetchByG_C_S(groupId, classNameId, structureKey = this.getStructureKey(structureKey));
        if (structure != null) {
            StructureDuplicateStructureKeyException sdske = new StructureDuplicateStructureKeyException();
            sdske.setStructureKey(structure.getStructureKey());
            throw sdske;
        }
        DDMForm parentDDMForm = this.getParentDDMForm(parentStructureId);
        this.validate(nameMap, parentDDMForm, definition);
    }

    protected void validate(Map<Locale, String> nameMap, DDMForm parentDDMForm, String childDefinition) throws PortalException {
        try {
            Document document = SAXReaderUtil.read((String)childDefinition);
            Element rootElement = document.getRootElement();
            Locale contentDefaultLocale = LocaleUtil.fromLanguageId((String)rootElement.attributeValue("default-locale"));
            this.validate(nameMap, contentDefaultLocale);
            this.validate(document);
            if (parentDDMForm != null) {
                this.validate(parentDDMForm, document);
            }
        }
        catch (LocaleException le) {
            throw le;
        }
        catch (StructureDuplicateElementException sdee) {
            throw sdee;
        }
        catch (StructureNameException sne) {
            throw sne;
        }
        catch (StructureDefinitionException sde) {
            throw sde;
        }
        catch (Exception e) {
            throw new StructureDefinitionException();
        }
    }

    protected void validate(Map<Locale, String> nameMap, Locale contentDefaultLocale) throws PortalException {
        String name = nameMap.get(contentDefaultLocale);
        if (Validator.isNull((String)name)) {
            throw new StructureNameException();
        }
        Object[] availableLocales = LanguageUtil.getAvailableLocales();
        if (!ArrayUtil.contains((Object[])availableLocales, (Object)contentDefaultLocale)) {
            Long companyId = CompanyThreadLocal.getCompanyId();
            LocaleException le = new LocaleException(3, "The locale " + contentDefaultLocale + " is not available in company " + companyId);
            le.setSourceAvailableLocales(new Locale[]{contentDefaultLocale});
            le.setTargetAvailableLocales((Locale[])availableLocales);
            throw le;
        }
    }
}

