/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMStructureLinkLocalServiceBaseImpl;
import java.util.List;

public class DDMStructureLinkLocalServiceImpl
extends DDMStructureLinkLocalServiceBaseImpl {
    public DDMStructureLink addStructureLink(long classNameId, long classPK, long structureId, ServiceContext serviceContext) {
        long structureLinkId = this.counterLocalService.increment();
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.create(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
        return structureLink;
    }

    public void deleteClassStructureLink(long classPK) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByClassPK(classPK);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureLink(DDMStructureLink structureLink) {
        this.ddmStructureLinkPersistence.remove((BaseModel)structureLink);
    }

    public void deleteStructureLink(long structureLinkId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        this.deleteStructureLink(structureLink);
    }

    public void deleteStructureStructureLinks(long structureId) {
        List structureLinks = this.ddmStructureLinkPersistence.findByStructureId(structureId);
        for (DDMStructureLink structureLink : structureLinks) {
            this.deleteStructureLink(structureLink);
        }
    }

    public DDMStructureLink getClassStructureLink(long classPK) throws PortalException {
        return this.ddmStructureLinkPersistence.findByClassPK(classPK);
    }

    public List<DDMStructureLink> getClassStructureLinks(long classNameId) {
        return this.ddmStructureLinkPersistence.findByStructureId(classNameId);
    }

    public DDMStructureLink getStructureLink(long structureLinkId) throws PortalException {
        return this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
    }

    public List<DDMStructureLink> getStructureLinks(long structureId, int start, int end) {
        return this.ddmStructureLinkPersistence.findByStructureId(structureId, start, end);
    }

    public DDMStructureLink updateStructureLink(long structureLinkId, long classNameId, long classPK, long structureId) throws PortalException {
        DDMStructureLink structureLink = this.ddmStructureLinkPersistence.findByPrimaryKey(structureLinkId);
        structureLink.setClassNameId(classNameId);
        structureLink.setClassPK(classPK);
        structureLink.setStructureId(structureId);
        this.ddmStructureLinkPersistence.update((BaseModel)structureLink);
        return structureLink;
    }
}

