/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatamapping.ContentDataException;
import com.liferay.portlet.dynamicdatamapping.ContentException;
import com.liferay.portlet.dynamicdatamapping.ContentNameException;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.service.base.DDMContentLocalServiceBaseImpl;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.Date;
import java.util.List;

public class DDMContentLocalServiceImpl
extends DDMContentLocalServiceBaseImpl {
    public DDMContent addContent(long userId, long groupId, String name, String description, String data, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            data = DDMXMLUtil.formatXML((String)data);
        }
        catch (Exception e) {
            throw new ContentDataException((Throwable)e);
        }
        Date now = new Date();
        this.validate(name, data);
        long contentId = this.counterLocalService.increment();
        DDMContent content = this.ddmContentPersistence.create(contentId);
        content.setUuid(serviceContext.getUuid());
        content.setGroupId(serviceContext.getScopeGroupId());
        content.setCompanyId(user.getCompanyId());
        content.setUserId(user.getUserId());
        content.setUserName(user.getFullName());
        content.setCreateDate(serviceContext.getCreateDate(now));
        content.setModifiedDate(serviceContext.getModifiedDate(now));
        content.setName(name);
        content.setDescription(description);
        content.setData(data);
        this.ddmContentPersistence.update((BaseModel)content);
        return content;
    }

    public void deleteContent(DDMContent content) {
        this.ddmContentPersistence.remove((BaseModel)content);
    }

    public void deleteContents(long groupId) {
        List contents = this.ddmContentPersistence.findByGroupId(groupId);
        for (DDMContent content : contents) {
            this.deleteContent(content);
        }
    }

    public DDMContent getContent(long contentId) throws PortalException {
        return this.ddmContentPersistence.findByPrimaryKey(contentId);
    }

    public List<DDMContent> getContents() {
        return this.ddmContentPersistence.findAll();
    }

    public List<DDMContent> getContents(long groupId) {
        return this.ddmContentPersistence.findByGroupId(groupId);
    }

    public List<DDMContent> getContents(long groupId, int start, int end) {
        return this.ddmContentPersistence.findByGroupId(groupId, start, end);
    }

    public int getContentsCount(long groupId) {
        return this.ddmContentPersistence.countByGroupId(groupId);
    }

    public DDMContent updateContent(long contentId, String name, String description, String data, ServiceContext serviceContext) throws PortalException {
        try {
            data = DDMXMLUtil.formatXML((String)data);
        }
        catch (Exception e) {
            throw new ContentDataException();
        }
        this.validate(name, data);
        DDMContent content = this.ddmContentPersistence.findByPrimaryKey(contentId);
        content.setModifiedDate(serviceContext.getModifiedDate(null));
        content.setName(name);
        content.setDescription(description);
        content.setData(data);
        this.ddmContentPersistence.update((BaseModel)content);
        return content;
    }

    protected void validate(String name, String xml) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new ContentNameException();
        }
        if (Validator.isNull((String)xml)) {
            throw new ContentException();
        }
        try {
            SAXReaderUtil.read((String)xml);
        }
        catch (DocumentException de) {
            throw new ContentException();
        }
    }
}

