/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.model.impl;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.dynamicdatamapping.StructureFieldException;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDDeserializerUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDSerializerUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureBaseImpl;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMStructureImpl
extends DDMStructureBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(DDMStructureImpl.class);
    private DDMForm _ddmForm;
    private DDMForm _fullHierarchyDDMForm;

    public DDMForm createFullHierarchyDDMForm() throws PortalException {
        DDMForm fullHierarchyDDMForm = DDMFormXSDDeserializerUtil.deserialize((String)this.getDefinition());
        DDMStructure parentDDMStructure = this.getParentDDMStructure();
        if (parentDDMStructure != null) {
            DDMForm ancestorsDDMForm = parentDDMStructure.createFullHierarchyDDMForm();
            List ddmFormFields = fullHierarchyDDMForm.getDDMFormFields();
            ddmFormFields.addAll(ancestorsDDMForm.getDDMFormFields());
        }
        return fullHierarchyDDMForm;
    }

    @Override
    public String[] getAvailableLanguageIds() {
        DDMForm ddmForm = this.getDDMForm();
        Set availableLocales = ddmForm.getAvailableLocales();
        return LocaleUtil.toLanguageIds((Locale[])availableLocales.toArray(new Locale[availableLocales.size()]));
    }

    public List<String> getChildrenFieldNames(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return this.getDDMFormFieldNames(ddmFormField.getNestedDDMFormFields());
    }

    @Override
    public DDMForm getDDMForm() {
        if (this._ddmForm == null) {
            try {
                this._ddmForm = DDMFormXSDDeserializerUtil.deserialize((String)this.getDefinition());
                this.addDDMFormPrivateDDMFormFields(this._ddmForm);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return this._ddmForm;
    }

    public DDMFormField getDDMFormField(String fieldName) throws PortalException {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        DDMFormField ddmFormField = ddmFormFieldsMap.get(fieldName);
        if (ddmFormField == null) {
            throw new StructureFieldException();
        }
        return ddmFormField;
    }

    public List<DDMFormField> getDDMFormFields(boolean includeTransientFields) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>(ddmFormFieldsMap.values());
        if (includeTransientFields) {
            return ddmFormFields;
        }
        return this.filterTransientDDMFormFields(ddmFormFields);
    }

    @Override
    public String getDefaultLanguageId() {
        DDMForm ddmForm = this.getDDMForm();
        return LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale());
    }

    public String getFieldDataType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.getDataType();
    }

    public String getFieldLabel(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        LocalizedValue label = ddmFormField.getLabel();
        return label.getString(locale);
    }

    public String getFieldLabel(String fieldName, String locale) throws PortalException {
        return this.getFieldLabel(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public Set<String> getFieldNames() {
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(false);
        List<String> ddmFormFieldNames = this.getDDMFormFieldNames(ddmFormFields);
        return SetUtil.fromList(ddmFormFieldNames);
    }

    public String getFieldProperty(String fieldName, String property) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return BeanPropertiesUtil.getString((Object)ddmFormField, (String)property);
    }

    public boolean getFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean getFieldRequired(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRequired();
    }

    public String getFieldTip(String fieldName, Locale locale) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        LocalizedValue tip = ddmFormField.getTip();
        return tip.getString(locale);
    }

    public String getFieldTip(String fieldName, String locale) throws PortalException {
        return this.getFieldTip(fieldName, LocaleUtil.fromLanguageId((String)locale));
    }

    public String getFieldType(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.getType();
    }

    @Override
    public DDMForm getFullHierarchyDDMForm() {
        if (this._fullHierarchyDDMForm == null) {
            try {
                this._fullHierarchyDDMForm = this.createFullHierarchyDDMForm();
                this.addDDMFormPrivateDDMFormFields(this._fullHierarchyDDMForm);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return this._fullHierarchyDDMForm;
    }

    public Map<String, DDMFormField> getFullHierarchyDDMFormFieldsMap(boolean includeNestedDDMFormFields) {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return ddmForm.getDDMFormFieldsMap(includeNestedDDMFormFields);
    }

    public List<String> getRootFieldNames() {
        DDMForm ddmForm = this.getFullHierarchyDDMForm();
        return this.getDDMFormFieldNames(ddmForm.getDDMFormFields());
    }

    public List<DDMTemplate> getTemplates() {
        return DDMTemplateLocalServiceUtil.getTemplates((long)this.getStructureId());
    }

    public String getUnambiguousName(List<DDMStructure> structures, long groupId, final Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getName(locale);
        }
        boolean hasAmbiguousName = ListUtil.exists(structures, (PredicateFilter)new PredicateFilter<DDMStructure>(){

            public boolean filter(DDMStructure structure) {
                String name = structure.getName(locale);
                return name.equals(DDMStructureImpl.this.getName(locale)) && structure.getStructureId() != DDMStructureImpl.this.getStructureId();
            }
        });
        if (hasAmbiguousName) {
            Group group = GroupLocalServiceUtil.getGroup((long)this.getGroupId());
            return group.getUnambiguousName(this.getName(locale), locale);
        }
        return this.getName(locale);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, String webDAVToken) {
        StringBundler sb = new StringBundler(11);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = PortalUtil.getPortalURL((String)themeDisplay.getServerName(), (int)themeDisplay.getServerPort(), (boolean)secure);
        sb.append(portalURL);
        sb.append(themeDisplay.getPathContext());
        sb.append("/");
        sb.append("webdav");
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getFriendlyURL());
        sb.append("/");
        sb.append(webDAVToken);
        sb.append("/");
        sb.append("Structures");
        sb.append("/");
        sb.append(this.getStructureId());
        return sb.toString();
    }

    public boolean hasField(String fieldName) {
        Map<String, DDMFormField> ddmFormFieldsMap = this.getFullHierarchyDDMFormFieldsMap(true);
        return ddmFormFieldsMap.containsKey(fieldName);
    }

    public boolean isFieldPrivate(String fieldName) {
        return fieldName.startsWith("_");
    }

    public boolean isFieldRepeatable(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return ddmFormField.isRepeatable();
    }

    public boolean isFieldTransient(String fieldName) throws PortalException {
        DDMFormField ddmFormField = this.getDDMFormField(fieldName);
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        super.prepareLocalizedFieldsForImport(defaultImportLocale);
        Locale ddmStructureDefaultLocale = LocaleUtil.fromLanguageId((String)this.getDefaultLanguageId());
        try {
            this.setDefinition(DDMXMLUtil.updateXMLDefaultLocale((String)this.getDefinition(), (Locale)ddmStructureDefaultLocale, (Locale)defaultImportLocale));
        }
        catch (Exception e) {
            throw new LocaleException(2, (Throwable)e);
        }
    }

    @Override
    public void setDDMForm(DDMForm ddmForm) {
        this._ddmForm = ddmForm;
    }

    @Override
    public void setDefinition(String definition) {
        super.setDefinition(definition);
        this._ddmForm = null;
    }

    @Override
    public void setFullHierarchyDDMForm(DDMForm fullHierarchyDDMForm) {
        this._fullHierarchyDDMForm = fullHierarchyDDMForm;
    }

    public void updateDDMForm(DDMForm ddmForm) {
        this.setDefinition(DDMFormXSDSerializerUtil.serialize((DDMForm)ddmForm));
    }

    protected void addDDMFormPrivateDDMFormFields(DDMForm ddmForm) {
        String[] privateFieldNames;
        List ddmFormFields = ddmForm.getDDMFormFields();
        for (String privateFieldName : privateFieldNames = PropsValues.DYNAMIC_DATA_MAPPING_STRUCTURE_PRIVATE_FIELD_NAMES) {
            DDMFormField privateDDMFormField = this.createPrivateDDMFormField(privateFieldName);
            ddmFormFields.add(privateDDMFormField);
        }
    }

    protected DDMFormField createPrivateDDMFormField(String privateFieldName) {
        DDMFormField privateDDMFormField = new DDMFormField(privateFieldName, "text");
        String dataType = PropsUtil.get((String)"dynamic.data.mapping.structure.private.field.datatype", (Filter)new Filter(privateFieldName));
        privateDDMFormField.setDataType(dataType);
        String repeatable = PropsUtil.get((String)"dynamic.data.mapping.structure.private.field.repeatable", (Filter)new Filter(privateFieldName));
        privateDDMFormField.setRepeatable(Boolean.valueOf(repeatable).booleanValue());
        return privateDDMFormField;
    }

    protected List<DDMFormField> filterTransientDDMFormFields(List<DDMFormField> ddmFormFields) {
        PredicateFilter<DDMFormField> predicateFilter = new PredicateFilter<DDMFormField>(){

            public boolean filter(DDMFormField ddmFormField) {
                return !Validator.isNull((String)ddmFormField.getDataType());
            }
        };
        return ListUtil.filter(ddmFormFields, (PredicateFilter)predicateFilter);
    }

    protected List<String> getDDMFormFieldNames(List<DDMFormField> ddmFormFields) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (DDMFormField ddmFormField : ddmFormFields) {
            fieldNames.add(ddmFormField.getName());
        }
        return fieldNames;
    }

    protected DDMStructure getParentDDMStructure() throws PortalException {
        if (this.getParentStructureId() == 0L) {
            return null;
        }
        DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)this.getParentStructureId());
        return parentStructure;
    }
}

