/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportHelperUtil;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Image;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDMTemplateStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMTemplate> {
    public static final String[] CLASS_NAMES = new String[]{DDMTemplate.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMTemplate ddmTemplate = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmTemplate != null) {
            DDMTemplateLocalServiceUtil.deleteTemplate((DDMTemplate)ddmTemplate);
        }
    }

    public DDMTemplate fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List templates = DDMTemplateLocalServiceUtil.getDDMTemplatesByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)templates)) {
            return null;
        }
        return (DDMTemplate)templates.get(0);
    }

    public DDMTemplate fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return DDMTemplateLocalServiceUtil.fetchDDMTemplateByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMTemplate template) {
        return template.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DDMTemplate template) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("referenced-class-name", template.getClassName());
        referenceAttributes.put("template-key", template.getTemplateKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)template.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == template.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        long classNameId = PortalUtil.getClassNameId((String)referenceElement.attributeValue("referenced-class-name"));
        String templateKey = referenceElement.attributeValue("template-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMTemplate existingTemplate = null;
        existingTemplate = this.fetchExistingTemplate(uuid, liveGroupId, classNameId, templateKey, preloaded);
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long templateId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        templateIds.put(templateId, existingTemplate.getTemplateId());
        Map templateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        templateKeys.put(templateKey, existingTemplate.getTemplateKey());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        long classNameId = PortalUtil.getClassNameId((String)referenceElement.attributeValue("referenced-class-name"));
        String templateKey = referenceElement.attributeValue("template-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMTemplate existingTemplate = this.fetchExistingTemplate(uuid, liveGroupId, classNameId, templateKey, preloaded);
        return existingTemplate != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        Element templateElement = portletDataContext.getExportDataElement((ClassedModel)template);
        DDMStructure structure = DDMStructureLocalServiceUtil.fetchStructure((long)template.getClassPK());
        if (structure != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)template, (StagedModel)structure, (String)"strong");
        }
        if (template.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.fetchImage((long)template.getSmallImageId());
            if (Validator.isNotNull((String)template.getSmallImageURL())) {
                String smallImageURL = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (String)(template.getSmallImageURL() + " "), (boolean)true);
                template.setSmallImageURL(smallImageURL);
            } else if (smallImage != null) {
                String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)template, (String)(smallImage.getImageId() + "." + template.getSmallImageType()));
                templateElement.addAttribute("small-image-path", smallImagePath);
                template.setSmallImageType(smallImage.getType());
                portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
            }
        }
        String script = ExportImportHelperUtil.replaceExportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (String)template.getScript(), (boolean)portletDataContext.getBooleanParameter("dynamic_data_mapping", "referenced-content"));
        template.setScript(script);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)template.getCompanyId());
        if (defaultUserId == template.getUserId()) {
            templateElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(templateElement, ExportImportPathUtil.getModelPath((StagedModel)template), (ClassedModel)template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMTemplate template) throws Exception {
        long userId = portletDataContext.getUserId(template.getUserUuid());
        long classPK = template.getClassPK();
        if (classPK > 0L) {
            Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            classPK = MapUtil.getLong((Map)structureIds, (long)classPK, (long)classPK);
        }
        File smallFile = null;
        try {
            if (template.isSmallImage()) {
                byte[] bytes;
                Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)template);
                String smallImagePath = element.attributeValue("small-image-path");
                if (Validator.isNotNull((String)template.getSmallImageURL())) {
                    String smallImageURL = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (String)template.getSmallImageURL());
                    template.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                    smallFile = FileUtil.createTempFile((String)template.getSmallImageType());
                    FileUtil.write((File)smallFile, (byte[])bytes);
                }
            }
            String script = ExportImportHelperUtil.replaceImportContentReferences((PortletDataContext)portletDataContext, (StagedModel)template, (String)template.getScript());
            template.setScript(script);
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)template);
            DDMTemplate importedTemplate = null;
            if (portletDataContext.isDataStrategyMirror()) {
                Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)template);
                boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
                DDMTemplate existingTemplate = this.fetchExistingTemplate(template.getUuid(), portletDataContext.getScopeGroupId(), template.getClassNameId(), template.getTemplateKey(), preloaded);
                if (existingTemplate == null) {
                    serviceContext.setUuid(template.getUuid());
                    importedTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (long)template.getClassNameId(), (long)classPK, (String)template.getTemplateKey(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
                } else {
                    importedTemplate = DDMTemplateLocalServiceUtil.updateTemplate((long)existingTemplate.getTemplateId(), (long)template.getClassPK(), (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
                }
            } else {
                importedTemplate = DDMTemplateLocalServiceUtil.addTemplate((long)userId, (long)portletDataContext.getScopeGroupId(), (long)template.getClassNameId(), (long)classPK, null, (Map)template.getNameMap(), (Map)template.getDescriptionMap(), (String)template.getType(), (String)template.getMode(), (String)template.getLanguage(), (String)template.getScript(), (boolean)template.isCacheable(), (boolean)template.isSmallImage(), (String)template.getSmallImageURL(), (File)smallFile, (ServiceContext)serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)template, (ClassedModel)importedTemplate);
            Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
            ddmTemplateKeys.put(template.getTemplateKey(), importedTemplate.getTemplateKey());
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected DDMTemplate fetchExistingTemplate(String uuid, long groupId, long classNameId, String templateKey, boolean preloaded) {
        DDMTemplate existingTemplate = null;
        existingTemplate = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)classNameId, (String)templateKey);
        return existingTemplate;
    }
}

