/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDMStructureStagedModelDataHandler
extends BaseStagedModelDataHandler<DDMStructure> {
    public static final String[] CLASS_NAMES = new String[]{DDMStructure.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DDMStructure ddmStructure = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (ddmStructure != null) {
            DDMStructureLocalServiceUtil.deleteStructure((DDMStructure)ddmStructure);
        }
    }

    public DDMStructure fetchStagedModelByUuidAndCompanyId(String uuid, long companyId) {
        List structures = DDMStructureLocalServiceUtil.getDDMStructuresByUuidAndCompanyId((String)uuid, (long)companyId, (int)-1, (int)-1, (OrderByComparator)new StagedModelModifiedDateComparator());
        if (ListUtil.isEmpty((List)structures)) {
            return null;
        }
        return (DDMStructure)structures.get(0);
    }

    public DDMStructure fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return DDMStructureLocalServiceUtil.fetchDDMStructureByUuidAndGroupId((String)uuid, (long)groupId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDMStructure structure) {
        return structure.getNameCurrentValue();
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DDMStructure structure) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("referenced-class-name", structure.getClassName());
        referenceAttributes.put("structure-key", structure.getStructureKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == structure.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        long classNameId = PortalUtil.getClassNameId((String)referenceElement.attributeValue("referenced-class-name"));
        String structureKey = referenceElement.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMStructure existingStructure = null;
        existingStructure = this.fetchExistingStructure(uuid, liveGroupId, classNameId, structureKey, preloaded);
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long structureId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        structureIds.put(structureId, existingStructure.getStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        structureKeys.put(structureKey, existingStructure.getStructureKey());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long liveGroupId = GetterUtil.getLong((String)referenceElement.attributeValue("live-group-id"));
        liveGroupId = MapUtil.getLong((Map)groupIds, (long)liveGroupId);
        long classNameId = PortalUtil.getClassNameId((String)referenceElement.attributeValue("referenced-class-name"));
        String structureKey = referenceElement.attributeValue("structure-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DDMStructure existingStructure = this.fetchExistingStructure(uuid, liveGroupId, classNameId, structureKey, preloaded);
        return existingStructure != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long defaultUserId;
        Element structureElement = portletDataContext.getExportDataElement((ClassedModel)structure);
        if (structure.getParentStructureId() != 0L) {
            DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)structure.getParentStructureId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)structure, (StagedModel)parentStructure, (String)"parent");
        }
        if ((defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)structure.getCompanyId())) == structure.getUserId()) {
            structureElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(structureElement, ExportImportPathUtil.getModelPath((StagedModel)structure), (ClassedModel)structure);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDMStructure structure) throws Exception {
        long userId = portletDataContext.getUserId(structure.getUserUuid());
        Map structureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long parentStructureId = MapUtil.getLong((Map)structureIds, (long)structure.getParentStructureId(), (long)structure.getParentStructureId());
        Map structureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)structure);
        DDMStructure importedStructure = null;
        if (portletDataContext.isDataStrategyMirror()) {
            Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)structure);
            boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
            DDMStructure existingStructure = this.fetchExistingStructure(structure.getUuid(), portletDataContext.getScopeGroupId(), structure.getClassNameId(), structure.getStructureKey(), preloaded);
            if (existingStructure == null) {
                serviceContext.setUuid(structure.getUuid());
                importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), (String)structure.getStructureKey(), (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getDefinition(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
            } else {
                importedStructure = DDMStructureLocalServiceUtil.updateStructure((long)existingStructure.getStructureId(), (long)parentStructureId, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getDefinition(), (ServiceContext)serviceContext);
            }
        } else {
            importedStructure = DDMStructureLocalServiceUtil.addStructure((long)userId, (long)portletDataContext.getScopeGroupId(), (long)parentStructureId, (long)structure.getClassNameId(), null, (Map)structure.getNameMap(), (Map)structure.getDescriptionMap(), (String)structure.getDefinition(), (String)structure.getStorageType(), (int)structure.getType(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)structure, (ClassedModel)importedStructure);
        structureKeys.put(structure.getStructureKey(), importedStructure.getStructureKey());
    }

    protected DDMStructure fetchExistingStructure(String uuid, long groupId, long classNameId, String structureKey, boolean preloaded) {
        DDMStructure existingStructure = null;
        existingStructure = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)classNameId, (String)structureKey);
        return existingStructure;
    }
}

