/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.io;

import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormXSDSerializer;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormFieldOptions;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMFormXSDSerializerImpl
implements DDMFormXSDSerializer {
    public String serialize(DDMForm ddmForm) {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        rootElement.addAttribute("available-locales", this.getAvailableLanguagesIds(ddmForm));
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId((Locale)ddmForm.getDefaultLocale()));
        this.addDynamicElementElements(ddmForm.getDDMFormFields(), rootElement);
        return document.asXML();
    }

    protected void addDynamicElementAttributes(DDMFormField ddmFormField, Element dynamicElementElement) {
        dynamicElementElement.addAttribute("dataType", ddmFormField.getDataType());
        dynamicElementElement.addAttribute("fieldNamespace", ddmFormField.getNamespace());
        dynamicElementElement.addAttribute("indexType", ddmFormField.getIndexType());
        dynamicElementElement.addAttribute("localizable", Boolean.toString(ddmFormField.isLocalizable()));
        dynamicElementElement.addAttribute("multiple", Boolean.toString(ddmFormField.isMultiple()));
        dynamicElementElement.addAttribute("name", ddmFormField.getName());
        dynamicElementElement.addAttribute("readOnly", Boolean.toString(ddmFormField.isReadOnly()));
        dynamicElementElement.addAttribute("repeatable", Boolean.toString(ddmFormField.isRepeatable()));
        dynamicElementElement.addAttribute("required", Boolean.toString(ddmFormField.isRequired()));
        dynamicElementElement.addAttribute("showLabel", Boolean.toString(ddmFormField.isShowLabel()));
        dynamicElementElement.addAttribute("type", ddmFormField.getType());
    }

    protected void addDynamicElementElement(DDMFormField ddmFormField, Element element) {
        Element dynamicElementElement = element.addElement("dynamic-element");
        this.addDynamicElementAttributes(ddmFormField, dynamicElementElement);
        this.addDynamicElementElements(ddmFormField.getNestedDDMFormFields(), dynamicElementElement);
        String ddmFormFieldType = ddmFormField.getType();
        if (ddmFormFieldType.equals("radio") || ddmFormFieldType.equals("select")) {
            this.addOptionsDynamicElements(ddmFormField.getDDMFormFieldOptions(), dynamicElementElement);
        }
        Map<Locale, Map<String, String>> metadataMap = this.getDDMFormFieldMetadataMap(ddmFormField);
        this.addMetadataElements(metadataMap, dynamicElementElement);
    }

    protected void addDynamicElementElements(List<DDMFormField> ddmFormFields, Element element) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this.addDynamicElementElement(ddmFormField, element);
        }
    }

    protected void addMetadataElements(Map<Locale, Map<String, String>> metadataMap, Element dynamicElementElement) {
        for (Locale locale : metadataMap.keySet()) {
            Element metadataElement = dynamicElementElement.addElement("meta-data");
            metadataElement.addAttribute("locale", LocaleUtil.toLanguageId((Locale)locale));
            this.addMetadataEntry(metadataMap.get(locale), metadataElement);
        }
    }

    protected void addMetadataEntry(Map<String, String> entryMap, Element metadataElement) {
        for (Map.Entry<String, String> entry : entryMap.entrySet()) {
            Element entryElement = metadataElement.addElement("entry");
            entryElement.addAttribute("name", entry.getKey());
            entryElement.addText(entry.getValue());
        }
    }

    protected void addMetadataEntryValues(Map<Locale, Map<String, String>> ddmFormFieldMetadataMap, String entryName, LocalizedValue localizedValue) {
        for (Locale availableLocale : localizedValue.getAvailableLocales()) {
            Map<String, String> metadataMap = ddmFormFieldMetadataMap.get(availableLocale);
            if (metadataMap == null) {
                metadataMap = new HashMap<String, String>();
                ddmFormFieldMetadataMap.put(availableLocale, metadataMap);
            }
            metadataMap.put(entryName, localizedValue.getString(availableLocale));
        }
    }

    protected Element addOptionDynamicElement(String optionValue, Element dynamicElement) {
        Element optionElement = dynamicElement.addElement("dynamic-element");
        optionElement.addAttribute("name", "option_" + StringUtil.randomId());
        optionElement.addAttribute("type", "option");
        optionElement.addAttribute("value", optionValue);
        return optionElement;
    }

    protected void addOptionsDynamicElements(DDMFormFieldOptions ddmFormFieldOptions, Element dynamicElementElement) {
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            Element optionElement = this.addOptionDynamicElement(optionValue, dynamicElementElement);
            Map<Locale, Map<String, String>> optionLabelsMap = this.getOptionLabelsMap(ddmFormFieldOptions.getOptionLabels(optionValue));
            this.addMetadataElements(optionLabelsMap, optionElement);
        }
    }

    protected String getAvailableLanguagesIds(DDMForm ddmForm) {
        Set availableLocales = ddmForm.getAvailableLocales();
        Object[] availableLanguageIds = LocaleUtil.toLanguageIds((Locale[])availableLocales.toArray(new Locale[availableLocales.size()]));
        return StringUtil.merge((Object[])availableLanguageIds);
    }

    protected Map<Locale, Map<String, String>> getDDMFormFieldMetadataMap(DDMFormField ddmFormField) {
        HashMap<Locale, Map<String, String>> ddmFormFieldMetadataMap = new HashMap<Locale, Map<String, String>>();
        this.addMetadataEntryValues(ddmFormFieldMetadataMap, "label", ddmFormField.getLabel());
        this.addMetadataEntryValues(ddmFormFieldMetadataMap, "predefinedValue", ddmFormField.getPredefinedValue());
        this.addMetadataEntryValues(ddmFormFieldMetadataMap, "tip", ddmFormField.getTip());
        return ddmFormFieldMetadataMap;
    }

    protected Map<Locale, Map<String, String>> getOptionLabelsMap(LocalizedValue optionLabels) {
        HashMap<Locale, Map<String, String>> optionLabelsMap = new HashMap<Locale, Map<String, String>>();
        for (Locale availableLocale : optionLabels.getAvailableLocales()) {
            HashMap<String, String> optionMetadataEntries = new HashMap<String, String>();
            optionMetadataEntries.put("label", optionLabels.getString(availableLocale));
            optionLabelsMap.put(availableLocale, optionMetadataEntries);
        }
        return optionLabelsMap;
    }
}

