/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.io;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormValuesJSONSerializer;
import com.liferay.portlet.dynamicdatamapping.model.Value;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormFieldValue;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormValues;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DDMFormValuesJSONSerializerImpl
implements DDMFormValuesJSONSerializer {
    public String serialize(DDMFormValues ddmFormValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmFormValues.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmFormValues.getDefaultLocale());
        this.addFieldValues(jsonObject, ddmFormValues.getDDMFormFieldValues());
        return jsonObject.toString();
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addFieldValues(JSONObject jsonObject, List<DDMFormFieldValue> ddmFormFieldValues) {
        jsonObject.put("fieldValues", this.toJSONArray(ddmFormFieldValues));
    }

    protected void addNestedFieldValues(JSONObject jsonObject, List<DDMFormFieldValue> nestedDDMFormFieldValues) {
        if (nestedDDMFormFieldValues.isEmpty()) {
            return;
        }
        jsonObject.put("nestedFieldValues", this.toJSONArray(nestedDDMFormFieldValues));
    }

    protected void addValue(JSONObject jsonObject, Value value) {
        if (value == null) {
            return;
        }
        if (value.isLocalized()) {
            jsonObject.put("value", this.toJSONObject(value));
        } else {
            jsonObject.put("value", value.getString(LocaleUtil.ROOT));
        }
    }

    protected JSONArray toJSONArray(List<DDMFormFieldValue> ddmFormFieldValues) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            jsonArray.put(this.toJSONObject(ddmFormFieldValue));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(DDMFormFieldValue ddmFormFieldValue) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("instanceId", ddmFormFieldValue.getInstanceId());
        jsonObject.put("name", ddmFormFieldValue.getName());
        this.addNestedFieldValues(jsonObject, ddmFormFieldValue.getNestedDDMFormFieldValues());
        this.addValue(jsonObject, ddmFormFieldValue.getValue());
        return jsonObject;
    }

    protected JSONObject toJSONObject(Value value) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (Locale availableLocale : value.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), value.getString(availableLocale));
        }
        return jsonObject;
    }
}

