/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.io;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import com.liferay.portlet.dynamicdatamapping.model.UnlocalizedValue;
import com.liferay.portlet.dynamicdatamapping.model.Value;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormFieldValue;
import com.liferay.portlet.dynamicdatamapping.storage.DDMFormValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DDMFormValuesJSONDeserializerImpl
implements DDMFormValuesJSONDeserializer {
    public DDMFormValues deserialize(String serializedDDMFormValues) throws PortalException {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)serializedDDMFormValues);
            DDMFormValues ddmFormValues = new DDMFormValues();
            this.setDDMFormValuesAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmFormValues);
            this.setDDMFormValuesDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmFormValues);
            this.setDDMFormFieldValues(jsonObject.getJSONArray("fieldValues"), ddmFormValues);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmFormValues);
            return ddmFormValues;
        }
        catch (JSONException jsone) {
            throw new PortalException((Throwable)jsone);
        }
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
        ddmFormFieldValue.setName(jsonObject.getString("name"));
        this.setDDMFormFieldValueValue(jsonObject, ddmFormFieldValue);
        this.setNestedDDMFormFieldValues(jsonObject.getJSONArray("nestedFieldValues"), ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected List<DDMFormFieldValue> getDDMFormFieldValues(JSONArray jsonArray) {
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        return ddmFormFieldValues;
    }

    protected LocalizedValue getLocalizedValue(JSONObject jsonObject) {
        LocalizedValue localizedValue = new LocalizedValue();
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
        return localizedValue;
    }

    protected Value getValue(JSONObject jsonObject) {
        JSONObject valueJSONObject = jsonObject.getJSONObject("value");
        if (this.isLocalized(valueJSONObject)) {
            return this.getLocalizedValue(valueJSONObject);
        }
        return new UnlocalizedValue(jsonObject.getString("value"));
    }

    protected boolean isLocalized(JSONObject jsonObject) {
        if (jsonObject == null) {
            return false;
        }
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (LanguageUtil.isAvailableLocale((String)key)) continue;
            return false;
        }
        return true;
    }

    protected void setDDMFormFieldValueLocalizedValueDefaultLocale(DDMFormFieldValue ddmFormFieldValue, Locale defaultLocale) {
        Value value = ddmFormFieldValue.getValue();
        if (value != null && value.isLocalized()) {
            value.setDefaultLocale(defaultLocale);
        }
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(nestedDDMFormFieldValue, defaultLocale);
        }
    }

    protected void setDDMFormFieldValues(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        List<DDMFormFieldValue> ddmFormFieldValues = this.getDDMFormFieldValues(jsonArray);
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    protected void setDDMFormFieldValueValue(JSONObject jsonObject, DDMFormFieldValue ddmFormFieldValue) {
        String valueString = jsonObject.getString("value", null);
        if (valueString == null) {
            return;
        }
        Value value = this.getValue(jsonObject);
        ddmFormFieldValue.setValue(value);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMFormValues ddmFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            this.setDDMFormFieldValueLocalizedValueDefaultLocale(ddmFormFieldValue, ddmFormValues.getDefaultLocale());
        }
    }

    protected void setDDMFormValuesAvailableLocales(JSONArray jsonArray, DDMFormValues ddmFormValues) {
        Set<Locale> availableLocales = this.getAvailableLocales(jsonArray);
        ddmFormValues.setAvailableLocales(availableLocales);
    }

    protected void setDDMFormValuesDefaultLocale(String defaultLanguageId, DDMFormValues ddmFormValues) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmFormValues.setDefaultLocale(defaultLocale);
    }

    protected void setNestedDDMFormFieldValues(JSONArray jsonArray, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormFieldValue> nestedDDMFormFieldValues = this.getDDMFormFieldValues(jsonArray);
        ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
    }
}

