/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.io;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormJSONSerializer;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormFieldOptions;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DDMFormJSONSerializerImpl
implements DDMFormJSONSerializer {
    public String serialize(DDMForm ddmForm) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        this.addAvailableLanguageIds(jsonObject, ddmForm.getAvailableLocales());
        this.addDefaultLanguageId(jsonObject, ddmForm.getDefaultLocale());
        this.addFields(jsonObject, ddmForm.getDDMFormFields());
        return jsonObject.toString();
    }

    protected void addAvailableLanguageIds(JSONObject jsonObject, Set<Locale> availableLocales) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (Locale availableLocale : availableLocales) {
            jsonArray.put(LocaleUtil.toLanguageId((Locale)availableLocale));
        }
        jsonObject.put("availableLanguageIds", jsonArray);
    }

    protected void addDefaultLanguageId(JSONObject jsonObject, Locale defaultLocale) {
        jsonObject.put("defaultLanguageId", LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void addFields(JSONObject jsonObject, List<DDMFormField> ddmFormFields) {
        jsonObject.put("fields", this.toJSONArray(ddmFormFields));
    }

    protected void addLocalizedProperty(JSONObject jsonObject, String propertyName, LocalizedValue localizedValue) {
        Map values = localizedValue.getValues();
        if (values.isEmpty()) {
            return;
        }
        jsonObject.put(propertyName, this.toJSONObject(localizedValue));
    }

    protected void addNestedFields(JSONObject jsonObject, List<DDMFormField> nestedDDMFormFields) {
        if (nestedDDMFormFields.isEmpty()) {
            return;
        }
        jsonObject.put("nestedFields", this.toJSONArray(nestedDDMFormFields));
    }

    protected void addOptions(JSONObject jsonObject, DDMFormFieldOptions ddmFormFieldOptions) {
        Set optionValues = ddmFormFieldOptions.getOptionsValues();
        if (optionValues.isEmpty()) {
            return;
        }
        jsonObject.put("options", this.toJSONArray(ddmFormFieldOptions));
    }

    protected void addSimpleProperties(JSONObject jsonObject, DDMFormField ddmFormField) {
        jsonObject.put("dataType", ddmFormField.getDataType());
        jsonObject.put("fieldNamespace", ddmFormField.getNamespace());
        jsonObject.put("indexType", ddmFormField.getIndexType());
        jsonObject.put("localizable", ddmFormField.isLocalizable());
        jsonObject.put("multiple", ddmFormField.isMultiple());
        jsonObject.put("name", ddmFormField.getName());
        jsonObject.put("readOnly", ddmFormField.isReadOnly());
        jsonObject.put("repeatable", ddmFormField.isRepeatable());
        jsonObject.put("required", ddmFormField.isRequired());
        jsonObject.put("showLabel", ddmFormField.isShowLabel());
        jsonObject.put("type", ddmFormField.getType());
    }

    protected JSONArray toJSONArray(DDMFormFieldOptions ddmFormFieldOptions) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (String optionValue : ddmFormFieldOptions.getOptionsValues()) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("value", optionValue);
            jsonObject.put("label", this.toJSONObject(ddmFormFieldOptions.getOptionLabels(optionValue)));
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    protected JSONArray toJSONArray(List<DDMFormField> ddmFormFields) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (DDMFormField ddmFormField : ddmFormFields) {
            jsonArray.put(this.toJSONObject(ddmFormField));
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(DDMFormField ddmFormField) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        this.addLocalizedProperty(jsonObject, "label", ddmFormField.getLabel());
        this.addLocalizedProperty(jsonObject, "predefinedValue", ddmFormField.getPredefinedValue());
        this.addLocalizedProperty(jsonObject, "style", ddmFormField.getStyle());
        this.addLocalizedProperty(jsonObject, "tip", ddmFormField.getTip());
        this.addNestedFields(jsonObject, ddmFormField.getNestedDDMFormFields());
        this.addOptions(jsonObject, ddmFormField.getDDMFormFieldOptions());
        this.addSimpleProperties(jsonObject, ddmFormField);
        return jsonObject;
    }

    protected JSONObject toJSONObject(LocalizedValue localizedValue) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        for (Locale availableLocale : localizedValue.getAvailableLocales()) {
            jsonObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), localizedValue.getString(availableLocale));
        }
        return jsonObject;
    }
}

