/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.io;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portlet.dynamicdatamapping.io.DDMFormJSONDeserializer;
import com.liferay.portlet.dynamicdatamapping.model.DDMForm;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormField;
import com.liferay.portlet.dynamicdatamapping.model.DDMFormFieldOptions;
import com.liferay.portlet.dynamicdatamapping.model.LocalizedValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DDMFormJSONDeserializerImpl
implements DDMFormJSONDeserializer {
    public DDMForm deserialize(String serializedDDMForm) throws PortalException {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)serializedDDMForm);
            DDMForm ddmForm = new DDMForm();
            this.setDDMFormAvailableLocales(jsonObject.getJSONArray("availableLanguageIds"), ddmForm);
            this.setDDMFormDefaultLocale(jsonObject.getString("defaultLanguageId"), ddmForm);
            this.setDDMFormFields(jsonObject.getJSONArray("fields"), ddmForm);
            this.setDDMFormLocalizedValuesDefaultLocale(ddmForm);
            return ddmForm;
        }
        catch (JSONException jsone) {
            throw new PortalException((Throwable)jsone);
        }
    }

    protected void addOptionValueLabels(JSONObject jsonObject, DDMFormFieldOptions ddmFormFieldOptions, String optionValue) {
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            ddmFormFieldOptions.addOptionLabel(optionValue, LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
    }

    protected Set<Locale> getAvailableLocales(JSONArray jsonArray) {
        HashSet<Locale> availableLocales = new HashSet<Locale>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Locale availableLocale = LocaleUtil.fromLanguageId((String)jsonArray.getString(i));
            availableLocales.add(availableLocale);
        }
        return availableLocales;
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) {
        String name = jsonObject.getString("name");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        ddmFormField.setDataType(jsonObject.getString("dataType"));
        ddmFormField.setIndexType(jsonObject.getString("indexType"));
        ddmFormField.setLocalizable(jsonObject.getBoolean("localizable", true));
        ddmFormField.setMultiple(jsonObject.getBoolean("multiple"));
        ddmFormField.setNamespace(jsonObject.getString("fieldNamespace"));
        ddmFormField.setReadOnly(jsonObject.getBoolean("readOnly"));
        ddmFormField.setRepeatable(jsonObject.getBoolean("repeatable"));
        ddmFormField.setRequired(jsonObject.getBoolean("required"));
        ddmFormField.setShowLabel(jsonObject.getBoolean("showLabel", true));
        this.setDDMFormFieldLocalizedValue(jsonObject.getJSONObject("label"), ddmFormField.getLabel());
        this.setDDMFormFieldLocalizedValue(jsonObject.getJSONObject("predefinedValue"), ddmFormField.getPredefinedValue());
        this.setDDMFormFieldLocalizedValue(jsonObject.getJSONObject("style"), ddmFormField.getStyle());
        this.setDDMFormFieldLocalizedValue(jsonObject.getJSONObject("tip"), ddmFormField.getTip());
        if (type.equals("radio") || type.equals("select")) {
            this.setDDMFormFieldOptions(jsonObject.getJSONArray("options"), ddmFormField);
        } else {
            this.setNestedDDMFormField(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        }
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            ddmFormFieldOptions.addOption(value);
            this.addOptionValueLabels(jsonObject.getJSONObject("label"), ddmFormFieldOptions, value);
        }
        return ddmFormFieldOptions;
    }

    protected List<DDMFormField> getDDMFormFields(JSONArray jsonArray) {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField ddmFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormFields.add(ddmFormField);
        }
        return ddmFormFields;
    }

    protected void setDDMFormAvailableLocales(JSONArray jsonArray, DDMForm ddmForm) {
        Set<Locale> availableLocales = this.getAvailableLocales(jsonArray);
        ddmForm.setAvailableLocales(availableLocales);
    }

    protected void setDDMFormDefaultLocale(String defaultLanguageId, DDMForm ddmForm) {
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmForm.setDefaultLocale(defaultLocale);
    }

    protected void setDDMFormFieldLocalizedValue(JSONObject jsonObject, LocalizedValue localizedValue) {
        if (jsonObject == null) {
            return;
        }
        Iterator itr = jsonObject.keys();
        while (itr.hasNext()) {
            String languageId = (String)itr.next();
            localizedValue.addString(LocaleUtil.fromLanguageId((String)languageId), jsonObject.getString(languageId));
        }
    }

    protected void setDDMFormFieldLocalizedValuesDefaultLocale(DDMFormField ddmFormField, Locale defaultLocale) {
        LocalizedValue label = ddmFormField.getLabel();
        label.setDefaultLocale(defaultLocale);
        LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
        predefinedValue.setDefaultLocale(defaultLocale);
        LocalizedValue style = ddmFormField.getStyle();
        style.setDefaultLocale(defaultLocale);
        LocalizedValue tip = ddmFormField.getTip();
        tip.setDefaultLocale(defaultLocale);
        DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
        ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(nestedDDMFormField, defaultLocale);
        }
    }

    protected void setDDMFormFieldOptions(JSONArray jsonArray, DDMFormField ddmFormField) {
        DDMFormFieldOptions ddmFormFieldOptions = this.getDDMFormFieldOptions(jsonArray);
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
    }

    protected void setDDMFormFields(JSONArray jsonArray, DDMForm ddmForm) {
        List<DDMFormField> ddmFormFields = this.getDDMFormFields(jsonArray);
        ddmForm.setDDMFormFields(ddmFormFields);
    }

    protected void setDDMFormLocalizedValuesDefaultLocale(DDMForm ddmForm) {
        for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
            this.setDDMFormFieldLocalizedValuesDefaultLocale(ddmFormField, ddmForm.getDefaultLocale());
        }
    }

    protected void setNestedDDMFormField(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return;
        }
        List<DDMFormField> nestedDDMFormFields = this.getDDMFormFields(jsonArray);
        ddmFormField.setNestedDDMFormFields(nestedDDMFormFields);
    }
}

