/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.action.ActionUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CopyStructureAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            DDMStructure structure = this.copyStructure(actionRequest);
            String redirect = this.getSaveAndContinueRedirect(portletConfig, actionRequest, structure);
            String closeRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"closeRedirect");
            if (Validator.isNotNull((String)closeRedirect)) {
                redirect = HttpUtil.setParameter((String)redirect, (String)"closeRedirect", (String)closeRedirect);
                SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".closeRedirect"), (Object)closeRedirect);
            }
            this.sendRedirect(actionRequest, actionResponse, redirect);
        }
        catch (Exception e) {
            if (e instanceof NoSuchStructureException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.dynamic_data_mapping.error");
            }
            if (e instanceof StructureNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
            throw e;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getStructure((PortletRequest)renderRequest);
        }
        catch (NoSuchStructureException nsse) {
        }
        catch (Exception e) {
            if (e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return actionMapping.findForward("portlet.dynamic_data_mapping.error");
            }
            throw e;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.dynamic_data_mapping.copy_structure"));
    }

    protected DDMStructure copyStructure(ActionRequest actionRequest) throws Exception {
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMStructure.class.getName(), (PortletRequest)actionRequest);
        DDMStructure structure = DDMStructureServiceUtil.copyStructure((long)classPK, (Map)nameMap, (Map)descriptionMap, (ServiceContext)serviceContext);
        this.copyTemplates(actionRequest, classPK, structure.getStructureId());
        return structure;
    }

    protected void copyTemplates(ActionRequest actionRequest, long oldClassPK, long newClassPK) throws Exception {
        boolean copyFormTemplates;
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMTemplate.class.getName(), (PortletRequest)actionRequest);
        boolean copyDisplayTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyDisplayTemplates");
        if (copyDisplayTemplates) {
            DDMTemplateServiceUtil.copyTemplates((long)classNameId, (long)oldClassPK, (long)newClassPK, (String)"display", (ServiceContext)serviceContext);
        }
        if (copyFormTemplates = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"copyFormTemplates")) {
            DDMTemplateServiceUtil.copyTemplates((long)classNameId, (long)oldClassPK, (long)newClassPK, (String)"form", (ServiceContext)serviceContext);
        }
    }

    protected String getSaveAndContinueRedirect(PortletConfig portletConfig, ActionRequest actionRequest, DDMStructure structure) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURLImpl portletURL = new PortletURLImpl((PortletRequest)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
        portletURL.setParameter("struts_action", "/dynamic_data_mapping/copy_structure");
        long classNameId = PortalUtil.getClassNameId(DDMStructure.class);
        portletURL.setParameter("classNameId", String.valueOf(classNameId), false);
        portletURL.setParameter("classPK", String.valueOf(structure.getStructureId()), false);
        portletURL.setParameter("copyFormTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyFormTemplates"), false);
        portletURL.setParameter("copyDisplayTemplates", ParamUtil.getString((PortletRequest)actionRequest, (String)"copyDisplayTemplates"), false);
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }
}

